/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit;

import de.iani.cubesideutils.Pair;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public class SerializablePair<T, S>
extends Pair<T, S>
implements ConfigurationSerializable {
    public SerializablePair(T first, S second) {
        super(first, second);
    }

    public SerializablePair(Pair<T, S> copyOf) {
        this(copyOf.first, copyOf.second);
    }

    public SerializablePair(Map<String, Object> serialized) {
        this(serialized.get("first"), serialized.get("second"));
    }

    @Override
    public SerializablePair<T, S> setFirst(T first) {
        return new SerializablePair<T, Object>(first, this.second);
    }

    @Override
    public SerializablePair<T, S> setSecond(S second) {
        return new SerializablePair<Object, S>(this.first, second);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(2);
        result.put("first", this.first);
        result.put("second", this.second);
        return result;
    }

    static {
        ConfigurationSerialization.registerClass(SerializablePair.class);
    }
}

