/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.items;

import de.iani.cubesideutils.bukkit.items.ItemGroups;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;

public class ItemStacks {
    private static final UUID attackSpeedUUID = UUID.fromString("34f5963d-3fc6-474b-a576-c4f05c2af419");
    private static final UUID attackDamageUUID = UUID.fromString("ea434c08-d745-4b5c-858e-1db76cc70088");

    private ItemStacks() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static ItemStack unbreakable(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.setUnbreakable(true);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack hideProperties(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_DESTROYS, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_PLACED_ON, ItemFlag.HIDE_POTION_EFFECTS, ItemFlag.HIDE_UNBREAKABLE});
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack enchant(ItemStack itemStack, Enchantment enchantment, int level) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.addEnchant(enchantment, level, true);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack rename(ItemStack itemStack, String name) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.setDisplayName(name);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack colorize(ItemStack itemStack, Color color) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof LeatherArmorMeta) {
            ((LeatherArmorMeta)meta).setColor(color);
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack potion(ItemStack itemStack, PotionData potion) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof PotionMeta) {
            ((PotionMeta)meta).setBasePotionData(potion);
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack fastPvP(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return itemStack;
        }
        ItemMeta meta = itemStack.getItemMeta();
        Material type = itemStack.getType();
        double addDamage = Double.NaN;
        if (type == Material.WOODEN_SWORD) {
            addDamage = 3.0;
        } else if (type == Material.GOLDEN_SWORD) {
            addDamage = 3.0;
        } else if (type == Material.STONE_SWORD) {
            addDamage = 4.0;
        } else if (type == Material.IRON_SWORD) {
            addDamage = 5.0;
        } else if (type == Material.DIAMOND_SWORD) {
            addDamage = 6.0;
        }
        if (!Double.isNaN(addDamage)) {
            Collection attackDamageModifiers;
            Collection attackSpeedModifiers;
            boolean attackModifierExists = false;
            if (meta.hasAttributeModifiers() && (attackSpeedModifiers = meta.getAttributeModifiers(Attribute.GENERIC_ATTACK_SPEED)) != null) {
                for (AttributeModifier m : attackSpeedModifiers) {
                    if (!m.getUniqueId().equals(attackSpeedUUID)) continue;
                    attackModifierExists = true;
                }
            }
            if (!attackModifierExists) {
                meta.addAttributeModifier(Attribute.GENERIC_ATTACK_SPEED, new AttributeModifier(attackSpeedUUID, "1.8-attackspeed", 1.5, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.HAND));
            }
            boolean attackDamageExists = false;
            if (meta.hasAttributeModifiers() && (attackDamageModifiers = meta.getAttributeModifiers(Attribute.GENERIC_ATTACK_DAMAGE)) != null) {
                for (AttributeModifier m : attackDamageModifiers) {
                    if (!m.getUniqueId().equals(attackDamageUUID)) continue;
                    attackDamageExists = true;
                }
            }
            if (!attackDamageExists) {
                meta.addAttributeModifier(Attribute.GENERIC_ATTACK_DAMAGE, new AttributeModifier(attackDamageUUID, "1.8-attackdamage", addDamage, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.HAND));
            }
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack[] deepCopy(ItemStack[] of) {
        ItemStack[] result = new ItemStack[of.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = of[i] == null ? null : new ItemStack(of[i]);
        }
        return result;
    }

    public static boolean addToInventoryIfFits(Inventory inventory, ItemStack ... items) {
        ItemStack[] contents = ItemStacks.deepCopy(inventory.getStorageContents());
        for (ItemStack item : items) {
            int remaining;
            int add;
            if (item == null || ItemGroups.isAir(item.getType())) continue;
            int firstPartial = -1;
            for (remaining = item.getAmount(); remaining > 0 && (firstPartial = ItemStacks.getFirstPartial(item, contents, firstPartial + 1)) >= 0; remaining -= add) {
                ItemStack content = contents[firstPartial];
                add = Math.min(content.getMaxStackSize() - content.getAmount(), remaining);
                content.setAmount(content.getAmount() + add);
            }
            int firstFree = -1;
            while (remaining > 0) {
                ItemStack content;
                if ((firstFree = ItemStacks.getFirstFree(contents, firstFree + 1)) < 0) {
                    return false;
                }
                contents[firstFree] = content = new ItemStack(item);
                int add2 = Math.min(Math.max(content.getMaxStackSize(), 1), remaining);
                content.setAmount(add2);
                remaining -= add2;
            }
        }
        inventory.setStorageContents(contents);
        return true;
    }

    private static int getFirstPartial(ItemStack item, ItemStack[] contents, int start) {
        for (int i = start; i < contents.length; ++i) {
            ItemStack content = contents[i];
            if (content == null || !content.isSimilar(item) || content.getAmount() >= content.getMaxStackSize()) continue;
            return i;
        }
        return -1;
    }

    private static int getFirstFree(ItemStack[] contents, int start) {
        for (int i = start; i < contents.length; ++i) {
            ItemStack content = contents[i];
            if (content != null && content.getAmount() != 0 && !ItemGroups.isAir(content.getType())) continue;
            return i;
        }
        return -1;
    }

    public static Map<ItemStack, Integer> countItems(ItemStack[] items) {
        LinkedHashMap<ItemStack, Integer> counts = new LinkedHashMap<ItemStack, Integer>();
        for (ItemStack item : items) {
            if (item == null || item.getAmount() == 0 || item.getType() == Material.AIR) continue;
            ItemStack key = item.clone();
            key.setAmount(1);
            counts.merge(key, item.getAmount(), (old, add) -> old + add);
        }
        return counts;
    }

    public static ItemStack[] shrink(ItemStack[] items) {
        Map<ItemStack, Integer> counts = ItemStacks.countItems(items);
        ArrayList<ItemStack> resultList = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, Integer> entry : counts.entrySet()) {
            ItemStack item = entry.getKey();
            for (int count = entry.getValue().intValue(); count > 0; count -= Math.min(count, Math.max(1, item.getMaxStackSize()))) {
                item = item.clone();
                item.setAmount(Math.min(count, Math.max(1, item.getMaxStackSize())));
                resultList.add(item);
            }
        }
        return resultList.toArray(new ItemStack[resultList.size()]);
    }

    public static boolean isEmpty(ItemStack[] items) {
        for (ItemStack item : items) {
            if (item == null || item.getAmount() <= 0 || item.getType() == Material.AIR) continue;
            return false;
        }
        return true;
    }

    public static ItemStack[] doesHave(Player player, ItemStack[] items, boolean removeIfYes) {
        return ItemStacks.doesHave(player, items, removeIfYes, true);
    }

    public static ItemStack[] doesHave(Player player, ItemStack[] items, boolean removeIfYes, boolean includeNonStorage) {
        items = ItemStacks.deepCopy(items);
        ItemStack[] oldContents = includeNonStorage ? player.getInventory().getContents() : player.getInventory().getStorageContents();
        ItemStack[] contents = ItemStacks.deepCopy(oldContents);
        boolean has = true;
        block0: for (ItemStack toStack : items) {
            for (int i = 0; i < contents.length; ++i) {
                ItemStack hisStack = contents[i];
                if (hisStack == null || hisStack.getAmount() <= 0 || !hisStack.isSimilar(toStack)) continue;
                if (toStack.getAmount() > hisStack.getAmount()) {
                    toStack.setAmount(toStack.getAmount() - hisStack.getAmount());
                    contents[i] = null;
                    continue;
                }
                if (toStack.getAmount() < hisStack.getAmount()) {
                    hisStack.setAmount(hisStack.getAmount() - toStack.getAmount());
                    toStack.setAmount(0);
                    continue block0;
                }
                contents[i] = null;
                toStack.setAmount(0);
                continue block0;
            }
            has = false;
        }
        if (!has) {
            ItemStack[] missing = ItemStacks.shrink(items);
            if (missing.length == 0) {
                throw new AssertionError();
            }
            return missing;
        }
        if (removeIfYes) {
            if (includeNonStorage) {
                player.getInventory().setContents(contents);
            } else {
                player.getInventory().setStorageContents(contents);
            }
            player.updateInventory();
        }
        return new ItemStack[0];
    }

    public static boolean equals(ItemStack[] i1, ItemStack[] i2) {
        return ItemStacks.countItems(i1).equals(ItemStacks.countItems(i2));
    }
}

