/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit;

import de.iani.cubesideutils.StringUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class ComponentUtil {
    private ComponentUtil() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static BaseComponent createTranslatableComponentFor(Material m) {
        String key = m.getKey().getKey();
        if (key.startsWith("music_disc_") || key.endsWith("_banner_pattern")) {
            return new TextComponent(new BaseComponent[]{new TranslatableComponent("item.minecraft." + key, new Object[0]), new TextComponent(": "), new TranslatableComponent("item.minecraft." + key + ".desc", new Object[0])});
        }
        return new TranslatableComponent((m.isBlock() ? "block.minecraft." : "item.minecraft.") + key, new Object[0]);
    }

    public static BaseComponent createTranslatableComponentFor(ItemStack stack) {
        ItemMeta meta;
        Material m = stack.getType();
        if ((m == Material.TIPPED_ARROW || m == Material.POTION || m == Material.SPLASH_POTION || m == Material.LINGERING_POTION) && (meta = stack.getItemMeta()) instanceof PotionMeta) {
            String key = m.getKey().getKey();
            PotionType type = ((PotionMeta)meta).getBasePotionData().getType();
            return new TranslatableComponent("item.minecraft." + key + ".effect." + ComponentUtil.getInternalPotionName(type), new Object[0]);
        }
        String key = m.getKey().getKey();
        if (key.startsWith("music_disc_")) {
            return new TextComponent(new BaseComponent[]{new TranslatableComponent("item.minecraft." + key, new Object[0]), new TextComponent(": "), new TranslatableComponent("item.minecraft." + key + ".desc", new Object[0])});
        }
        return new TranslatableComponent((m.isBlock() ? "block.minecraft." : "item.minecraft.") + key, new Object[0]);
    }

    public static BaseComponent createTranslatableComponentFor(EntityType t) {
        return new TranslatableComponent("entity.minecraft." + t.getKey().getKey(), new Object[0]);
    }

    public static BaseComponent createTranslatableComponentFor(Entity e) {
        return ComponentUtil.createTranslatableComponentFor(e.getType());
    }

    private static String getInternalPotionName(PotionType t) {
        switch (t) {
            case UNCRAFTABLE: {
                return "empty";
            }
            case JUMP: {
                return "leaping";
            }
            case SPEED: {
                return "swiftness";
            }
            case INSTANT_HEAL: {
                return "healing";
            }
            case INSTANT_DAMAGE: {
                return "harming";
            }
            case REGEN: {
                return "regeneration";
            }
        }
        return t.name().toLowerCase();
    }

    public static BaseComponent convertEscaped(String text) throws ParseException {
        return ComponentUtil.convertEscaped(text, 0, text.length());
    }

    public static BaseComponent convertEscaped(String text, int from, int to) throws ParseException {
        return new EscapedConverter(text, from, to).convert();
    }

    private static class EscapedConverter {
        private static final Pattern ESCAPED_LEFT_BRACE_PATTERN = Pattern.compile("\\\\\\{");
        private static final Pattern ESCAPED_RIGHT_BRACE_PATTERN = Pattern.compile("\\\\\\}");
        private String text;
        private int to;
        private List<BaseComponent> components;
        private int index;
        private StringBuilder currentBuilder;
        private TextComponent currentComponent;

        EscapedConverter(String text, int from, int to) {
            this.text = Objects.requireNonNull(text);
            this.to = to;
            this.components = new ArrayList<BaseComponent>();
            this.index = from;
            this.currentBuilder = new StringBuilder();
            this.currentComponent = new TextComponent();
        }

        BaseComponent convert() throws ParseException {
            while (this.index < this.to) {
                char current = this.text.charAt(this.index);
                switch (current) {
                    case '&': {
                        char next = this.charAtOrException(this.index + 1);
                        if (next == '&') {
                            this.currentBuilder.append('&');
                            ++this.index;
                            break;
                        }
                        if (ChatColor.getByChar((char)next) != null || next == 'x') {
                            ChatColor color;
                            if (next == 'x') {
                                if (this.index + 2 + 6 > this.to) {
                                    throw new ParseException("illegal hex code", this.index);
                                }
                                color = StringUtil.parseHexColor(this.text, this.index + 2);
                                if (color == null) {
                                    throw new ParseException("illegal hex code", this.index);
                                }
                                this.index += 7;
                            } else {
                                color = ChatColor.getByChar((char)next);
                                ++this.index;
                            }
                            this.finishComponent();
                            if (color == ChatColor.BOLD) {
                                this.currentComponent.setBold(Boolean.valueOf(true));
                                break;
                            }
                            if (color == ChatColor.ITALIC) {
                                this.currentComponent.setItalic(Boolean.valueOf(true));
                                break;
                            }
                            if (color == ChatColor.MAGIC) {
                                this.currentComponent.setObfuscated(Boolean.valueOf(true));
                                break;
                            }
                            if (color == ChatColor.STRIKETHROUGH) {
                                this.currentComponent.setStrikethrough(Boolean.valueOf(true));
                                break;
                            }
                            if (color == ChatColor.UNDERLINE) {
                                this.currentComponent.setUnderlined(Boolean.valueOf(true));
                                break;
                            }
                            this.currentComponent.setColor(color);
                            break;
                        }
                        throw new ParseException("character after '&' was neither a color char nor '&' or 'x'", this.index);
                    }
                    case '\\': {
                        char next = this.charAtOrException(this.index + 1);
                        if (next == '\\' || next == '&' || next == '{' || next == '}') {
                            this.currentBuilder.append(next);
                            ++this.index;
                            break;
                        }
                        if (next == 'n') {
                            this.currentBuilder.append('\n');
                            ++this.index;
                            break;
                        }
                        if (next == 'r') {
                            char resetType = this.charAtOrException(this.index + 2);
                            if (resetType != 'a' && resetType != 'e' && resetType != 'f') {
                                throw new ParseException("unknown reset type " + resetType, this.index + 2);
                            }
                            this.finishComponent(resetType == 'a' ? ComponentBuilder.FormatRetention.NONE : (resetType == 'e' ? ComponentBuilder.FormatRetention.FORMATTING : ComponentBuilder.FormatRetention.EVENTS));
                            this.index += 2;
                            break;
                        }
                        if (next == 'h') {
                            char actionType = this.charAtOrException(this.index + 2);
                            if (actionType != 't' && actionType != 'i' && actionType != 'e') {
                                throw new ParseException("unknown action type " + actionType, this.index + 2);
                            }
                            if (this.charAtOrException(this.index + 3) != '{') {
                                throw new ParseException("expected {", this.index + 3);
                            }
                            int contentStartIndex = this.index + 4;
                            int contentEndIndex = EscapedConverter.findMatchingRightBrace(this.text, this.index + 3, this.to);
                            if (contentEndIndex < 0) {
                                throw new ParseException("unmatched left brace", this.index + 3);
                            }
                            if (actionType != 't') {
                                throw new ParseException("action types i and e are currently not implemented", this.index + 2);
                            }
                            HoverEvent.Action action = HoverEvent.Action.SHOW_TEXT;
                            Content[] content = new Content[]{new Text(new BaseComponent[]{ComponentUtil.convertEscaped(this.text, contentStartIndex, contentEndIndex)})};
                            this.finishComponent();
                            this.currentComponent.setHoverEvent(new HoverEvent(action, content));
                            this.index = contentEndIndex;
                            break;
                        }
                        if (next == 'c') {
                            ClickEvent.Action action;
                            char actionType = this.charAtOrException(this.index + 2);
                            if (actionType == 'r') {
                                action = ClickEvent.Action.RUN_COMMAND;
                            } else if (actionType == 's') {
                                action = ClickEvent.Action.SUGGEST_COMMAND;
                            } else if (actionType == 'c') {
                                action = ClickEvent.Action.COPY_TO_CLIPBOARD;
                            } else if (actionType == 'p') {
                                action = ClickEvent.Action.CHANGE_PAGE;
                            } else if (actionType == 'u') {
                                action = ClickEvent.Action.OPEN_URL;
                            } else {
                                if (actionType == 'f') {
                                    throw new ParseException("action type f is rejected by clients", this.index + 2);
                                }
                                throw new ParseException("unknown action type " + actionType, this.index + 2);
                            }
                            if (this.charAtOrException(this.index + 3) != '{') {
                                throw new ParseException("expected {", this.index + 3);
                            }
                            int contentStartIndex = this.index + 4;
                            int contentEndIndex = EscapedConverter.findMatchingRightBrace(this.text, this.index + 3, this.to);
                            if (contentEndIndex < 0) {
                                throw new ParseException("unmatched left brace", this.index + 3);
                            }
                            String value = this.text.substring(contentStartIndex, contentEndIndex);
                            value = ESCAPED_LEFT_BRACE_PATTERN.matcher(value).replaceAll("{");
                            value = ESCAPED_RIGHT_BRACE_PATTERN.matcher(value).replaceAll("}");
                            this.finishComponent();
                            this.currentComponent.setClickEvent(new ClickEvent(action, value));
                            this.index = contentEndIndex;
                            break;
                        }
                        throw new ParseException("unknown control sequence " + next, this.index);
                    }
                    case '{': {
                        int closingIndex = EscapedConverter.findMatchingRightBrace(this.text, this.index, this.to);
                        if (closingIndex < 0) {
                            throw new ParseException("unmatched left brace", this.index);
                        }
                        this.finishComponent();
                        BaseComponent subComponent = ComponentUtil.convertEscaped(this.text, this.index + 1, closingIndex);
                        this.currentComponent.addExtra(subComponent);
                        this.index = closingIndex;
                        break;
                    }
                    case '}': {
                        throw new ParseException("unmatched right brace", this.index);
                    }
                    default: {
                        this.currentBuilder.append(current);
                        break;
                    }
                }
                ++this.index;
            }
            this.currentComponent.addExtra(this.currentBuilder.toString());
            this.components.add((BaseComponent)this.currentComponent);
            return new TextComponent(this.components.toArray(new BaseComponent[this.components.size()]));
        }

        private char charAtOrException(int i) throws ParseException {
            if (i >= this.to) {
                throw new ParseException("unexpected end of string", this.to);
            }
            return this.text.charAt(i);
        }

        private void finishComponent() {
            this.finishComponent(ComponentBuilder.FormatRetention.ALL);
        }

        private void finishComponent(ComponentBuilder.FormatRetention retention) {
            this.currentComponent.addExtra(this.currentBuilder.toString());
            this.components.add((BaseComponent)this.currentComponent);
            TextComponent newComponent = new TextComponent();
            newComponent.copyFormatting((BaseComponent)this.currentComponent, retention, true);
            this.currentComponent = newComponent;
            this.currentBuilder = new StringBuilder();
        }

        private static int findMatchingRightBrace(String text, int leftBraceIndex, int endIndex) {
            return EscapedConverter.findMatchingRightBrace(text, leftBraceIndex, endIndex, false);
        }

        private static int findMatchingRightBrace(String text, int leftBraceIndex, int endIndex, boolean ignoreLeftBraces) {
            int depth = ignoreLeftBraces ? 1 : 0;
            block5: for (int i = leftBraceIndex; i < endIndex; ++i) {
                switch (text.charAt(i)) {
                    case '\\': {
                        ++i;
                        break;
                    }
                    case '{': {
                        depth += ignoreLeftBraces ? 0 : 1;
                        break;
                    }
                    case '}': {
                        --depth;
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                if (depth != 0) continue;
                return i;
            }
            return -1;
        }
    }
}

