/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.commands;

import de.iani.cubesideutils.commands.CommandRouter;
import de.iani.cubesideutils.commands.exceptions.DisallowsCommandBlockException;
import de.iani.cubesideutils.commands.exceptions.IllegalSyntaxException;
import de.iani.cubesideutils.commands.exceptions.InternalCommandException;
import de.iani.cubesideutils.commands.exceptions.NoPermissionException;
import de.iani.cubesideutils.commands.exceptions.NoPermissionForPathException;
import de.iani.cubesideutils.commands.exceptions.RequiresPlayerException;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;

public interface CommandExceptionHandler {
    public static final CommandExceptionHandler DEFAULT_HANDLER = new CommandExceptionHandler(){};

    default public boolean handleDisallowsCommandBlock(DisallowsCommandBlockException thrown) {
        CommandSender sender = thrown.getSender();
        sender.sendMessage(ChatColor.RED + thrown.getMessage());
        return true;
    }

    default public boolean handleRequiresPlayer(RequiresPlayerException thrown) {
        CommandSender sender = thrown.getSender();
        sender.sendMessage(ChatColor.RED + thrown.getMessage());
        return true;
    }

    default public boolean handleNoPermission(NoPermissionException thrown) {
        CommandSender sender = thrown.getSender();
        sender.sendMessage(ChatColor.RED + thrown.getMessage());
        return true;
    }

    default public boolean handleNoPermissionForPath(NoPermissionForPathException thrown) {
        CommandSender sender = thrown.getSender();
        sender.sendMessage(ChatColor.RED + thrown.getMessage());
        return true;
    }

    default public boolean handleIllegalSyntax(IllegalSyntaxException thrown) {
        CommandRouter router = thrown.getRouter();
        CommandSender sender = thrown.getSender();
        String alias = thrown.getAlias();
        String[] args = thrown.getArgs();
        router.showHelp(sender, alias, args);
        return true;
    }

    default public boolean handleInternalException(InternalCommandException thrown) {
        Throwable cause;
        if (thrown.getMessage() != null) {
            CommandSender sender = thrown.getSender();
            sender.sendMessage(ChatColor.RED + thrown.getMessage());
        }
        if ((cause = thrown.getCause()) instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new RuntimeException(cause);
    }
}

