/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.plugin;

import de.cubeside.connection.GlobalServer;
import de.iani.cubesideutils.plugin.PlayerData;
import de.iani.cubesideutils.plugin.UtilsGlobalDataHelper;
import de.iani.cubesideutils.plugin.UtilsPlugin;
import de.iani.cubesideutils.plugin.events.LocalAfkStateChangeEvent;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class OnlinePlayerData
extends PlayerData {
    private long lastLocalAction;
    private boolean manuallySetAfk;
    private boolean locallyAfk;

    OnlinePlayerData(UUID playerId, long firstJoin, long lastJoin, long lastSeen, boolean afk, long lastAction, boolean manuallySetAfk, String rank) {
        super(playerId, firstJoin, lastJoin, lastSeen, afk, rank);
        this.lastLocalAction = lastAction;
        this.manuallySetAfk = manuallySetAfk;
        this.locallyAfk = afk;
    }

    synchronized void quit() {
        this.setLocallyAfk(false, false);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)UtilsPlugin.getInstance(), this::notifyChanges);
    }

    public Player getPlayer() {
        Player result = Bukkit.getPlayer((UUID)this.getPlayerId());
        if (!(result != null || (result = UtilsPlugin.getInstance().getPlayerDataCache().getCurrentlyLoggingInPlayer()) != null && result.getUniqueId().equals(this.getPlayerId()))) {
            return null;
        }
        return result;
    }

    public synchronized long getLastAction() {
        return this.lastLocalAction;
    }

    synchronized void madeAction() {
        this.lastLocalAction = System.currentTimeMillis();
        this.manuallySetAfk = false;
        this.checkAfk(true);
    }

    public synchronized void checkAfk(boolean messagePlayer) {
        boolean afk;
        boolean bl = afk = System.currentTimeMillis() >= this.lastLocalAction + 120000L;
        if (afk == this.isLocallyAfk() || !afk && this.manuallySetAfk) {
            return;
        }
        if (Bukkit.isPrimaryThread()) {
            this.setLocallyAfk(afk, messagePlayer);
        } else {
            Bukkit.getScheduler().runTask((Plugin)UtilsPlugin.getInstance(), () -> this.setLocallyAfk(afk, messagePlayer));
        }
    }

    public synchronized boolean isLocallyAfk() {
        return this.locallyAfk;
    }

    public synchronized boolean isManuallySetAfk() {
        return this.manuallySetAfk;
    }

    public synchronized void manuallySetAfk(boolean messagePlayer) {
        this.manuallySetAfk = true;
        this.setLocallyAfk(true, messagePlayer);
    }

    public synchronized void setLocallyAfk(boolean afk, boolean messagePlayer) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("May only be invoked on the bukkit primary thread.");
        }
        if (this.locallyAfk == afk) {
            return;
        }
        LocalAfkStateChangeEvent event = new LocalAfkStateChangeEvent(this, afk);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.locallyAfk = afk;
        if (!afk) {
            this.manuallySetAfk = false;
        }
        try {
            UtilsPlugin.getInstance().getDatabase().setLocallyAfk(this.getPlayerId(), afk);
        }
        catch (SQLException e) {
            UtilsPlugin.getInstance().getLogger().log(Level.SEVERE, "Could not save AFK-status in database.", e);
        }
        this.checkGloballyAfk();
        if (messagePlayer) {
            this.getPlayer().sendMessage(ChatColor.GRAY + "* Du bist nun" + (this.locallyAfk ? "" : " nicht mehr") + " abwesend.");
        }
    }

    private void checkGloballyAfk() {
        Set<String> afkServers;
        if (this.locallyAfk && this.isGloballyAfk()) {
            return;
        }
        if (!this.locallyAfk && !this.isGloballyAfk()) {
            return;
        }
        if (!this.locallyAfk) {
            this.setGloballyAfkInternal(false);
            return;
        }
        UtilsGlobalDataHelper globalHelper = UtilsPlugin.getInstance().getGlobalDataHelper();
        List<GlobalServer> servers = globalHelper.getServers(this.getPlayerId());
        assert (servers.contains(globalHelper.getThisServer()));
        if (servers.size() == 1) {
            this.setGloballyAfkInternal(true);
            return;
        }
        try {
            afkServers = UtilsPlugin.getInstance().getDatabase().getAfkServers(this.getPlayerId());
        }
        catch (SQLException e) {
            UtilsPlugin.getInstance().getLogger().log(Level.SEVERE, "Could not load AFK-status from database.", e);
            return;
        }
        for (GlobalServer server : servers) {
            if (afkServers.contains(server.getName())) continue;
            return;
        }
        this.setGloballyAfkInternal(true);
    }

    @Override
    public void checkRank() {
        String rank = null;
        for (String possible : UtilsPlugin.getInstance().getRanks()) {
            String permission = UtilsPlugin.getInstance().getPermission(possible);
            if (permission != null && !this.getPlayer().hasPermission(permission)) continue;
            rank = possible;
            break;
        }
        this.setRank(rank);
    }
}

