/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.plugin;

import de.cubeside.connection.ConnectionAPI;
import de.cubeside.connection.GlobalClientPlugin;
import de.cubeside.connection.GlobalPlayer;
import de.cubeside.connection.GlobalServer;
import de.cubeside.connection.PlayerMessageAPI;
import de.cubeside.connection.PlayerPropertiesAPI;
import de.iani.cubesideutils.FunctionUtil;
import de.iani.cubesideutils.plugin.UtilsPlugin;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.OfflinePlayer;

public class GlobalDataBundle
implements ConnectionAPI,
PlayerMessageAPI,
PlayerPropertiesAPI {
    private ConnectionAPI connectionApi;
    private PlayerMessageAPI playerMsgApi;
    private PlayerPropertiesAPI playerPropertiesApi;

    public GlobalDataBundle() {
        GlobalClientPlugin globalClientPlugin = UtilsPlugin.getInstance().getGlobalClientPlugin();
        this.connectionApi = globalClientPlugin.getConnectionAPI();
        this.playerMsgApi = globalClientPlugin.getMessageAPI();
        this.playerPropertiesApi = globalClientPlugin.getPlayerPropertiesAPI();
    }

    public GlobalPlayer getPlayer(OfflinePlayer player) {
        return this.connectionApi.getPlayer(player.getUniqueId());
    }

    public GlobalPlayer getPlayer(UUID playerId) {
        return this.connectionApi.getPlayer(playerId);
    }

    public GlobalPlayer getPlayer(String name) {
        return this.connectionApi.getPlayer(name);
    }

    public Collection<GlobalPlayer> getPlayers() {
        return this.connectionApi.getPlayers();
    }

    public Collection<GlobalServer> getServers() {
        return this.connectionApi.getServers();
    }

    public GlobalServer getServer(String serverName) {
        return this.connectionApi.getServer(serverName);
    }

    public GlobalServer getThisServer() {
        return this.connectionApi.getThisServer();
    }

    public String getThisServerName() {
        return this.connectionApi.getThisServer().getName();
    }

    public void sendMessage(OfflinePlayer player, String message) {
        this.sendMessage(this.getPlayer(player), message);
    }

    public void sendMessage(UUID playerId, String message) {
        this.sendMessage(this.getPlayer(playerId), message);
    }

    public void sendMessage(String playerName, String message) {
        this.sendMessage(this.getPlayer(playerName), message);
    }

    public void sendMessage(GlobalPlayer player, String message) {
        this.playerMsgApi.sendMessage(player, message);
    }

    public void sendMessage(OfflinePlayer player, BaseComponent ... message) {
        this.sendMessage(this.getPlayer(player), message);
    }

    public void sendMessage(UUID playerId, BaseComponent ... message) {
        this.sendMessage(this.getPlayer(playerId), message);
    }

    public void sendMessage(String playerName, BaseComponent ... message) {
        this.sendMessage(this.getPlayer(playerName), message);
    }

    public void sendMessage(GlobalPlayer player, BaseComponent ... message) {
        this.playerMsgApi.sendMessage(player, message);
    }

    public void sendActionBarMessage(OfflinePlayer player, String message) {
        this.sendActionBarMessage(this.getPlayer(player), message);
    }

    public void sendActionBarMessage(UUID playerId, String message) {
        this.sendActionBarMessage(this.getPlayer(playerId), message);
    }

    public void sendActionBarMessage(String playerName, String message) {
        this.sendActionBarMessage(this.getPlayer(playerName), message);
    }

    public void sendActionBarMessage(GlobalPlayer player, String message) {
        this.playerMsgApi.sendActionBarMessage(player, message);
    }

    public void sendTitleBarMessage(OfflinePlayer player, String title, String subtitle, int fadeInTicks, int durationTicks, int fadeOutTicks) {
        this.sendTitleBarMessage(this.getPlayer(player), title, subtitle, fadeInTicks, durationTicks, fadeOutTicks);
    }

    public void sendTitleBarMessage(UUID playerId, String title, String subtitle, int fadeInTicks, int durationTicks, int fadeOutTicks) {
        this.sendTitleBarMessage(this.getPlayer(playerId), title, subtitle, fadeInTicks, durationTicks, fadeOutTicks);
    }

    public void sendTitleBarMessage(String playerName, String title, String subtitle, int fadeInTicks, int durationTicks, int fadeOutTicks) {
        this.sendTitleBarMessage(this.getPlayer(playerName), title, subtitle, fadeInTicks, durationTicks, fadeOutTicks);
    }

    public void sendTitleBarMessage(GlobalPlayer player, String title, String subtitle, int fadeInTicks, int durationTicks, int fadeOutTicks) {
        this.playerMsgApi.sendTitleBarMessage(player, title, subtitle, fadeInTicks, durationTicks, fadeOutTicks);
    }

    public boolean hasProperty(OfflinePlayer player, String property) {
        return this.hasProperty(this.getPlayer(player), property);
    }

    public boolean hasProperty(UUID playerId, String property) {
        return this.hasProperty(this.getPlayer(playerId), property);
    }

    public boolean hasProperty(String playerName, String property) {
        return this.hasProperty(this.getPlayer(playerName), property);
    }

    public boolean hasProperty(GlobalPlayer player, String property) {
        return this.playerPropertiesApi.hasProperty(player, property);
    }

    public String getPropertyValue(OfflinePlayer player, String property) {
        return this.getPropertyValue(this.getPlayer(player), property);
    }

    public String getPropertyValue(UUID playerId, String property) {
        return this.getPropertyValue(this.getPlayer(playerId), property);
    }

    public String getPropertyValue(String playerName, String property) {
        return this.getPropertyValue(this.getPlayer(playerName), property);
    }

    public String getPropertyValue(GlobalPlayer player, String property) {
        return this.playerPropertiesApi.getPropertyValue(player, property);
    }

    public Map<String, String> getAllProperties(OfflinePlayer player) {
        return this.getAllProperties(this.getPlayer(player));
    }

    public Map<String, String> getAllProperties(UUID playerId) {
        return this.getAllProperties(this.getPlayer(playerId));
    }

    public Map<String, String> getAllProperties(String playerName) {
        return this.getAllProperties(this.getPlayer(playerName));
    }

    public Map<String, String> getAllProperties(GlobalPlayer player) {
        return this.playerPropertiesApi.getAllProperties(player);
    }

    public void setPropertyValue(OfflinePlayer player, String property, String value) {
        this.setPropertyValue(this.getPlayer(player), property, value);
    }

    public void setPropertyValue(UUID playerId, String property, String value) {
        this.setPropertyValue(this.getPlayer(playerId), property, value);
    }

    public void setPropertyValue(String playerName, String property, String value) {
        this.setPropertyValue(this.getPlayer(playerName), property, value);
    }

    public void setPropertyValue(GlobalPlayer player, String property, String value) {
        this.playerPropertiesApi.setPropertyValue(player, property, value);
    }

    public boolean isReal(GlobalServer server) {
        return this.isReal(server.getName());
    }

    public boolean isReal(String serverName) {
        Set<String> realServers;
        Map<String, Boolean> cached = UtilsPlugin.getInstance().getCachedRealServers();
        Boolean result = cached.get(serverName);
        if (result != null) {
            return result;
        }
        cached.values().removeIf(Boolean::booleanValue);
        try {
            realServers = UtilsPlugin.getInstance().getDatabase().getRealServers();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        for (String real : realServers) {
            cached.put(real, true);
        }
        return cached.computeIfAbsent(serverName, name -> false);
    }

    public List<GlobalServer> getServers(OfflinePlayer player) {
        return this.getServers(player, false);
    }

    public List<GlobalServer> getServers(OfflinePlayer player, boolean includeNonReals) {
        return this.getServers(this.getPlayer(player), includeNonReals);
    }

    public List<GlobalServer> getServers(UUID playerId) {
        return this.getServers(playerId, false);
    }

    public List<GlobalServer> getServers(UUID playerId, boolean includeNonReals) {
        return this.getServers(this.getPlayer(playerId), includeNonReals);
    }

    public List<GlobalServer> getServers(String playerName) {
        return this.getServers(playerName, false);
    }

    public List<GlobalServer> getServers(String playerName, boolean includeNonReals) {
        return this.getServers(this.getPlayer(playerName), includeNonReals);
    }

    public List<GlobalServer> getServers(GlobalPlayer gPlayer) {
        return this.getServers(gPlayer, false);
    }

    public List<GlobalServer> getServers(GlobalPlayer gPlayer, boolean includeNonReals) {
        if (gPlayer == null) {
            return Collections.emptyList();
        }
        ArrayList<GlobalServer> result = gPlayer.getCurrentServers();
        if (includeNonReals) {
            return result;
        }
        try {
            result.removeIf(FunctionUtil.negate(this::isReal));
        }
        catch (UnsupportedOperationException e) {
            result = new ArrayList<GlobalServer>(result);
            result.removeIf(FunctionUtil.negate(this::isReal));
        }
        return result;
    }

    public boolean isOnAnyServer(OfflinePlayer player) {
        return this.isOnAnyServer(player, false);
    }

    public boolean isOnAnyServer(OfflinePlayer player, boolean includeNonReals) {
        return this.isOnAnyServer(this.getPlayer(player), includeNonReals);
    }

    public boolean isOnAnyServer(UUID playerId) {
        return this.isOnAnyServer(playerId, false);
    }

    public boolean isOnAnyServer(UUID playerId, boolean includeNonReals) {
        return this.isOnAnyServer(this.getPlayer(playerId), includeNonReals);
    }

    public boolean isOnAnyServer(String playerName) {
        return this.isOnAnyServer(playerName, false);
    }

    public boolean isOnAnyServer(String playerName, boolean includeNonReals) {
        return this.isOnAnyServer(this.getPlayer(playerName), includeNonReals);
    }

    public boolean isOnAnyServer(GlobalPlayer gPlayer) {
        return this.isOnAnyServer(gPlayer, false);
    }

    public boolean isOnAnyServer(GlobalPlayer gPlayer, boolean includeNonReals) {
        if (gPlayer == null) {
            return false;
        }
        if (includeNonReals) {
            return gPlayer.isOnAnyServer();
        }
        return gPlayer.getCurrentServers().stream().anyMatch(this::isReal);
    }

    public Collection<GlobalPlayer> getOnlinePlayers() {
        return this.getOnlinePlayers(false);
    }

    public Collection<GlobalPlayer> getOnlinePlayers(boolean includeNonReals) {
        Collection result = this.getPlayers();
        if (!includeNonReals) {
            result = result.stream().filter(this::isOnAnyServer).collect(Collectors.toList());
        }
        return result;
    }

    public Set<String> getOnlinePlayerNames() {
        return this.getOnlinePlayerNames(false);
    }

    public Set<String> getOnlinePlayerNames(boolean includeNonReals) {
        Stream<GlobalPlayer> stream = this.getPlayers().stream();
        if (!includeNonReals) {
            stream = stream.filter(this::isOnAnyServer);
        }
        return stream.map(GlobalPlayer::getName).collect(Collectors.toSet());
    }

    public void sendData(String channel, byte[] data) {
        this.connectionApi.sendData(channel, data);
    }

    public void sendData(String channel, byte[] data, boolean sendToRestriced) {
        this.connectionApi.sendData(channel, data, sendToRestriced);
    }
}

