/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.plugin;

import de.cubeside.connection.event.GlobalPlayerJoinedEvent;
import de.iani.cubesideutils.plugin.PlayerData;
import de.iani.cubesideutils.plugin.UtilsGlobalDataHelper;
import de.iani.cubesideutils.plugin.UtilsPlugin;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.plugin.Plugin;

class EventListener
implements Listener {
    private UtilsPlugin plugin = UtilsPlugin.getInstance();

    public EventListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    private void madeAction(Player player) {
        PlayerData data = this.plugin.getPlayerDataCache().get(player.getUniqueId());
        data.getOnlineData().madeAction();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onGlobalPlayerJoinedEvent(GlobalPlayerJoinedEvent event) {
        if (!event.hasJustJoinedTheNetwork()) {
            return;
        }
        PlayerData data = this.plugin.getPlayerDataCache().get(event.getPlayer().getUniqueId(), true);
        if (data.getFirstJoin() == 0L) {
            data.setFirstJoinAndLastJoinAndSeen(System.currentTimeMillis());
        } else {
            data.setLastJoinAndSeen(System.currentTimeMillis());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        UtilsGlobalDataHelper globalData = this.plugin.getGlobalDataHelper();
        globalData.setPropertyValue((OfflinePlayer)event.getPlayer(), "worldDisplayName:" + globalData.getThisServerName(), this.plugin.getWorldDisplayName((LivingEntity)event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerChangedWorldEvent(PlayerChangedWorldEvent event) {
        UtilsGlobalDataHelper globalData = this.plugin.getGlobalDataHelper();
        globalData.setPropertyValue((OfflinePlayer)event.getPlayer(), "worldDisplayName:" + globalData.getThisServerName(), this.plugin.getWorldDisplayName((LivingEntity)event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuitEvent(PlayerQuitEvent event) {
        UtilsGlobalDataHelper globalData = this.plugin.getGlobalDataHelper();
        globalData.setPropertyValue((OfflinePlayer)event.getPlayer(), "worldDisplayName:" + globalData.getThisServerName(), null);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onAsynchPlayerChatEvent(AsyncPlayerChatEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerCommandPreprocessEvent(PlayerCommandPreprocessEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void PlayerPlayerDropItemEvent(PlayerDropItemEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerEditBookEvent(PlayerEditBookEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerInteractEntityEvent(PlayerInteractEntityEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerInteractAtEntityEvent(PlayerInteractAtEntityEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerItemHeldEvent(PlayerItemHeldEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerMoveEvent(PlayerMoveEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerSwapHandItemsEvent(PlayerSwapHandItemsEvent event) {
        this.madeAction(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onInventoryClickEvent(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        this.madeAction((Player)event.getWhoClicked());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onInventoryCloseEvent(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        this.madeAction((Player)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onInventoryOpenEvent(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        this.madeAction((Player)event.getPlayer());
    }
}

