/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.plugin;

import de.iani.cubesideutils.ChatUtil;
import de.iani.cubesideutils.StringUtil;
import de.iani.cubesideutils.commands.ArgsParser;
import de.iani.cubesideutils.commands.SubCommand;
import de.iani.cubesideutils.plugin.UtilsPlugin;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

class ListRankInformationCommand
extends SubCommand {
    static final String COMMAND_PATH = "list";
    static final String FULL_COMMAND = "ranks list";

    ListRankInformationCommand() {
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String alias, String commandString, ArgsParser args) {
        int page = 0;
        if (args.hasNext()) {
            page = args.getNext(0) - 1;
        }
        List msgs = UtilsPlugin.getInstance().getRanks().stream().map(rank -> {
            int priority = UtilsPlugin.getInstance().getPriority((String)rank);
            String permission = UtilsPlugin.getInstance().getPermission((String)rank);
            String prefix = UtilsPlugin.getInstance().getPrefix((String)rank);
            StringBuilder info = new StringBuilder((String)rank).append(": ");
            info.append("priority ").append(priority).append(", ");
            info.append("permission ").append(permission == null ? "-" : permission).append(", ");
            info.append("prefix ").append(StringUtil.revertColors(prefix));
            return new ChatUtil.StringMsg(info.toString());
        }).collect(Collectors.toList());
        ChatUtil.sendMessagesPaged(sender, msgs, page, "Rank Information", FULL_COMMAND);
        return true;
    }
}

