/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.collections;

import de.iani.cubesideutils.collections.GeneralHashMap;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;

public class LinkedGeneralHashMap<K, V>
extends GeneralHashMap<K, V> {
    private static final long serialVersionUID = 3801124242820219131L;
    private transient Entry head;
    private transient Entry tail;
    private final boolean accessOrder;

    private void linkNodeLast(Entry p) {
        Entry last = this.tail;
        this.tail = p;
        if (last == null) {
            this.head = p;
        } else {
            p.before = last;
            last.after = p;
        }
    }

    private void transferLinks(Entry src, Entry dst) {
        Entry b = dst.before = src.before;
        Entry a = dst.after = src.after;
        if (b == null) {
            this.head = dst;
        } else {
            b.after = dst;
        }
        if (a == null) {
            this.tail = dst;
        } else {
            a.before = dst;
        }
    }

    @Override
    void reinitialize() {
        super.reinitialize();
        this.tail = null;
        this.head = null;
    }

    @Override
    GeneralHashMap.Node newNode(int hash, K key, V value, GeneralHashMap.Node e) {
        Entry p = new Entry(hash, key, value, e);
        this.linkNodeLast(p);
        return p;
    }

    @Override
    GeneralHashMap.Node replacementNode(GeneralHashMap.Node p, GeneralHashMap.Node next) {
        Entry q = (Entry)p;
        Entry t = new Entry(q.hash, q.key, q.value, next);
        this.transferLinks(q, t);
        return t;
    }

    @Override
    void afterNodeRemoval(GeneralHashMap.Node e) {
        Entry p = (Entry)e;
        Entry b = p.before;
        Entry a = p.after;
        p.after = null;
        p.before = null;
        if (b == null) {
            this.head = a;
        } else {
            b.after = a;
        }
        if (a == null) {
            this.tail = b;
        } else {
            a.before = b;
        }
    }

    @Override
    void afterNodeInsertion(boolean evict) {
        Entry first;
        if (evict && (first = this.head) != null && this.removeEldestEntry(first)) {
            Object key = first.key;
            this.removeNode(this.hash(key), key, null, false, true);
        }
    }

    @Override
    void afterNodeAccess(GeneralHashMap.Node e) {
        Entry last;
        if (this.accessOrder && (last = this.tail) != e) {
            Entry p = (Entry)e;
            Entry b = p.before;
            Entry a = p.after;
            p.after = null;
            if (b == null) {
                this.head = a;
            } else {
                b.after = a;
            }
            if (a != null) {
                a.before = b;
            } else {
                last = b;
            }
            if (last == null) {
                this.head = p;
            } else {
                p.before = last;
                last.after = p;
            }
            this.tail = p;
            ++this.modCount;
        }
    }

    @Override
    void internalWriteEntries(ObjectOutputStream s) throws IOException {
        Entry e = this.head;
        while (e != null) {
            s.writeObject(e.key);
            s.writeObject(e.value);
            e = e.after;
        }
    }

    public LinkedGeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality, int initialCapacity, float loadFactor) {
        super(hasher, equality, initialCapacity, loadFactor);
        this.accessOrder = false;
    }

    public LinkedGeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality, int initialCapacity) {
        super(hasher, equality, initialCapacity);
        this.accessOrder = false;
    }

    public LinkedGeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality) {
        super(hasher, equality);
        this.accessOrder = false;
    }

    public LinkedGeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality, Map<? extends K, ? extends V> m) {
        super(hasher, equality);
        this.accessOrder = false;
        this.putMapEntries(m, false);
    }

    public LinkedGeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality, int initialCapacity, float loadFactor, boolean accessOrder) {
        super(hasher, equality, initialCapacity, loadFactor);
        this.accessOrder = accessOrder;
    }

    @Override
    public boolean containsValue(Object value) {
        Entry e = this.head;
        while (e != null) {
            Object v = e.value;
            if (v == value || value != null && value.equals(v)) {
                return true;
            }
            e = e.after;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        GeneralHashMap.Node e = this.getNode(this.hash(key), key);
        if (e == null) {
            return null;
        }
        if (this.accessOrder) {
            this.afterNodeAccess(e);
        }
        return e.value;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        GeneralHashMap.Node e = this.getNode(this.hash(key), key);
        if (e == null) {
            return defaultValue;
        }
        if (this.accessOrder) {
            this.afterNodeAccess(e);
        }
        return e.value;
    }

    @Override
    public void clear() {
        super.clear();
        this.tail = null;
        this.head = null;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return false;
    }

    @Override
    public Set<K> keySet() {
        Set ks = this.keySet;
        if (ks == null) {
            this.keySet = ks = new LinkedKeySet();
        }
        return ks;
    }

    @Override
    public Collection<V> values() {
        Collection vs = this.values;
        if (vs == null) {
            this.values = vs = new LinkedValues();
        }
        return vs;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set es = this.entrySet;
        return es == null ? (this.entrySet = new LinkedEntrySet()) : es;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        int mc = this.modCount;
        Entry e = this.head;
        while (e != null) {
            action.accept(e.key, e.value);
            e = e.after;
        }
        if (this.modCount != mc) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        int mc = this.modCount;
        Entry e = this.head;
        while (e != null) {
            e.value = function.apply(e.key, e.value);
            e = e.after;
        }
        if (this.modCount != mc) {
            throw new ConcurrentModificationException();
        }
    }

    final class LinkedEntryIterator
    extends LinkedHashIterator
    implements Iterator<Map.Entry<K, V>> {
        LinkedEntryIterator() {
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.nextNode();
        }
    }

    final class LinkedValueIterator
    extends LinkedHashIterator
    implements Iterator<V> {
        LinkedValueIterator() {
        }

        @Override
        public final V next() {
            return this.nextNode().value;
        }
    }

    final class LinkedKeyIterator
    extends LinkedHashIterator
    implements Iterator<K> {
        LinkedKeyIterator() {
        }

        @Override
        public final K next() {
            return this.nextNode().getKey();
        }
    }

    abstract class LinkedHashIterator {
        Entry next;
        Entry current;
        int expectedModCount;

        LinkedHashIterator() {
            this.next = LinkedGeneralHashMap.this.head;
            this.expectedModCount = LinkedGeneralHashMap.this.modCount;
            this.current = null;
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry nextNode() {
            Entry e = this.next;
            if (LinkedGeneralHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.current = e;
            this.next = e.after;
            return e;
        }

        public final void remove() {
            Entry p = this.current;
            if (p == null) {
                throw new IllegalStateException();
            }
            if (LinkedGeneralHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.current = null;
            Object key = p.key;
            LinkedGeneralHashMap.this.removeNode(LinkedGeneralHashMap.this.hash(key), key, null, false, false);
            this.expectedModCount = LinkedGeneralHashMap.this.modCount;
        }
    }

    final class LinkedEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        LinkedEntrySet() {
        }

        @Override
        public final int size() {
            return LinkedGeneralHashMap.this.size;
        }

        @Override
        public final void clear() {
            LinkedGeneralHashMap.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new LinkedEntryIterator();
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            GeneralHashMap.Node candidate = LinkedGeneralHashMap.this.getNode(LinkedGeneralHashMap.this.hash(key), key);
            return candidate != null && candidate.equals(e);
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return LinkedGeneralHashMap.this.removeNode(LinkedGeneralHashMap.this.hash(key), key, value, true, true) != null;
            }
            return false;
        }

        @Override
        public final Spliterator<Map.Entry<K, V>> spliterator() {
            return Spliterators.spliterator(this, 81);
        }

        @Override
        public final void forEach(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = LinkedGeneralHashMap.this.modCount;
            Entry e = LinkedGeneralHashMap.this.head;
            while (e != null) {
                action.accept(e);
                e = e.after;
            }
            if (LinkedGeneralHashMap.this.modCount != mc) {
                throw new ConcurrentModificationException();
            }
        }
    }

    final class LinkedValues
    extends AbstractCollection<V> {
        LinkedValues() {
        }

        @Override
        public final int size() {
            return LinkedGeneralHashMap.this.size;
        }

        @Override
        public final void clear() {
            LinkedGeneralHashMap.this.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            return new LinkedValueIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return LinkedGeneralHashMap.this.containsValue(o);
        }

        @Override
        public final Spliterator<V> spliterator() {
            return Spliterators.spliterator(this, 80);
        }

        @Override
        public final void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = LinkedGeneralHashMap.this.modCount;
            Entry e = LinkedGeneralHashMap.this.head;
            while (e != null) {
                action.accept(e.value);
                e = e.after;
            }
            if (LinkedGeneralHashMap.this.modCount != mc) {
                throw new ConcurrentModificationException();
            }
        }
    }

    final class LinkedKeySet
    extends AbstractSet<K> {
        LinkedKeySet() {
        }

        @Override
        public final int size() {
            return LinkedGeneralHashMap.this.size;
        }

        @Override
        public final void clear() {
            LinkedGeneralHashMap.this.clear();
        }

        @Override
        public final Iterator<K> iterator() {
            return new LinkedKeyIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return LinkedGeneralHashMap.this.containsKey(o);
        }

        @Override
        public final boolean remove(Object key) {
            return LinkedGeneralHashMap.this.removeNode(LinkedGeneralHashMap.this.hash(key), key, null, false, true) != null;
        }

        @Override
        public final Spliterator<K> spliterator() {
            return Spliterators.spliterator(this, 81);
        }

        @Override
        public final void forEach(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = LinkedGeneralHashMap.this.modCount;
            Entry e = LinkedGeneralHashMap.this.head;
            while (e != null) {
                action.accept(e.key);
                e = e.after;
            }
            if (LinkedGeneralHashMap.this.modCount != mc) {
                throw new ConcurrentModificationException();
            }
        }
    }

    class Entry
    extends GeneralHashMap.Node {
        Entry before;
        Entry after;

        Entry(int hash, K key, V value, GeneralHashMap.Node next) {
            super(hash, key, value, next);
        }
    }
}

