/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import java.util.List;
import java.util.Random;

public class RandomUtil {
    public static final Random SHARED_RANDOM = new Random();

    private RandomUtil() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static double pseudoGaussian(double bound, Random ran) {
        double result;
        if (bound <= 0.0) {
            throw new IllegalArgumentException("bound must be positive");
        }
        while ((result = ran.nextGaussian()) <= -bound || result >= bound) {
        }
        return result;
    }

    public static double pseudoGaussian(double bound) {
        return RandomUtil.pseudoGaussian(bound, SHARED_RANDOM);
    }

    public static <T> T randomElement(List<T> list, Random ran) {
        return list.get(ran.nextInt(list.size()));
    }

    public static <T> T randomElement(List<T> list) {
        return RandomUtil.randomElement(list, SHARED_RANDOM);
    }
}

