/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.cubesidestatswebapi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.cubeside.cubesidestatswebapi.StatsAPI;
import de.cubeside.cubesidestatswebapi.model.PlayerStatsEntry;
import de.cubeside.cubesidestatswebapi.model.PlayerStatsObject;
import de.cubeside.cubesidestatswebapi.model.PlayerStatsProvider;
import de.cubeside.cubesidestatswebapi.model.PlayerStatsProviderList;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsoup.Jsoup;

public class CubesideStats
implements StatsAPI {
    public static final Logger logger = Logger.getLogger("CubesideStats-WebAPI");
    private static final String url = "https://webinterface.cubeside.de/api/stats/";
    private final Gson gson = new GsonBuilder().create();

    @Override
    public Collection<PlayerStatsProvider> getAllStatsKeys() {
        try {
            String json = Jsoup.connect((String)"https://webinterface.cubeside.de/api/stats/list").ignoreContentType(true).execute().body();
            return ((PlayerStatsProviderList)this.gson.fromJson(json, PlayerStatsProviderList.class)).getProviders();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "", e);
            return null;
        }
    }

    @Override
    public PlayerStatsEntry getStatsFromPlayerOrUUID(String statsKey, String nameOrUUID) {
        return this.getStatsFromPlayersOrUUIDs(statsKey, Collections.singleton(nameOrUUID)).stream().findFirst().get();
    }

    @Override
    public Collection<PlayerStatsEntry> getStatsFromPlayersOrUUIDs(String statsKey, Collection<String> listOfNameOrUUID) {
        StringBuilder sb = new StringBuilder();
        sb.append(url).append("entries?id=").append(statsKey);
        for (String s : listOfNameOrUUID) {
            sb.append("&player=").append(s);
        }
        try {
            String json = Jsoup.connect((String)sb.toString()).ignoreContentType(true).execute().body();
            return ((PlayerStatsObject)this.gson.fromJson(json, PlayerStatsObject.class)).getEntries();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "", e);
            return null;
        }
    }

    @Override
    public PlayerStatsEntry getStatsFromPosition(String statsKey, int position) {
        return this.getStatsFromPositionRange(statsKey, position, position).stream().findFirst().get();
    }

    @Override
    public Collection<PlayerStatsEntry> getStatsFromPositionRange(String statsKey, int startPos, int endPos) {
        StringBuilder sb = new StringBuilder();
        sb.append(url).append("top?id=").append(statsKey).append("&start=").append(startPos).append("&count=").append(endPos);
        try {
            String json = Jsoup.connect((String)sb.toString()).ignoreContentType(true).execute().body();
            return ((PlayerStatsObject)this.gson.fromJson(json, PlayerStatsObject.class)).getEntries();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "", e);
            return null;
        }
    }
}

