/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import de.iani.cubesidestats.CubesideStatisticsImplementation;
import de.iani.cubesidestats.InternalPlayerWithScore;
import de.iani.cubesidestats.StatisticsDatabase;
import de.iani.cubesidestats.api.Callback;
import de.iani.cubesidestats.api.PlayerWithScore;
import de.iani.cubesidestats.api.StatisticKey;
import de.iani.cubesidestats.api.TimeFrame;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class StatisticKeyImplementation
implements StatisticKey {
    private final int id;
    private final String name;
    private final CubesideStatisticsImplementation stats;
    private String displayName;
    private boolean isMonthly;
    private boolean isDaily;

    public StatisticKeyImplementation(int id, String name, String properties, CubesideStatisticsImplementation impl) {
        this.id = id;
        this.name = name;
        this.stats = impl;
        YamlConfiguration conf = new YamlConfiguration();
        if (properties != null) {
            try {
                conf.loadFromString(properties);
            }
            catch (InvalidConfigurationException e) {
                impl.getPlugin().getLogger().log(Level.SEVERE, "Could not load properties for key " + name + " (" + id + ")", e);
            }
        }
        this.displayName = conf.getString("displayName");
        this.isMonthly = conf.getBoolean("isMonthly");
        this.isDaily = conf.getBoolean("isDaily");
    }

    public String getSerializedProperties() {
        YamlConfiguration conf = new YamlConfiguration();
        conf.set("displayName", (Object)this.displayName);
        conf.set("isMonthly", (Object)this.isMonthly);
        conf.set("isDaily", (Object)this.isDaily);
        return conf.saveToString();
    }

    private void save() {
        final StatisticKeyImplementation clone = new StatisticKeyImplementation(this.id, this.name, null, this.stats);
        clone.copyPropertiesFrom(this);
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    database.updateStatisticKey(clone);
                }
                catch (SQLException e) {
                    StatisticKeyImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not save statistic key " + StatisticKeyImplementation.this.name, e);
                }
            }
        });
    }

    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDisplayName(String name) {
        if (!Objects.equals(this.name, name)) {
            this.displayName = name;
            this.save();
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setIsMonthlyStats(boolean monthly) {
        if (this.isMonthly != monthly) {
            this.isMonthly = monthly;
            this.save();
        }
    }

    @Override
    public boolean isMonthlyStats() {
        return this.isMonthly;
    }

    @Override
    public void setIsDailyStats(boolean daily) {
        if (this.isDaily != daily) {
            this.isDaily = daily;
            this.save();
        }
    }

    @Override
    public boolean isDailyStats() {
        return this.isDaily;
    }

    public void copyPropertiesFrom(StatisticKeyImplementation e) {
        this.displayName = e.displayName;
        this.isMonthly = e.isMonthly;
        this.isDaily = e.isDaily;
    }

    @Override
    public void getTop(final int count, TimeFrame timeFrame, final Callback<List<PlayerWithScore>> resultCallback) {
        boolean daily;
        boolean monthly;
        boolean bl = monthly = timeFrame == TimeFrame.MONTH;
        if (monthly && !this.isMonthlyStats()) {
            throw new IllegalArgumentException("There are no monthly stats for this key");
        }
        boolean bl2 = daily = timeFrame == TimeFrame.DAY;
        if (daily && !this.isDailyStats()) {
            throw new IllegalArgumentException("There are no daily stats for this key");
        }
        if (resultCallback == null) {
            throw new NullPointerException("scoreCallback");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count must be >= 0");
        }
        int timekey = -1;
        if (monthly) {
            timekey = this.stats.getCurrentMonthKey();
        } else if (daily) {
            timekey = this.stats.getCurrentDayKey();
        }
        final int timekey2 = timekey;
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    final List<InternalPlayerWithScore> score = database.getTop(StatisticKeyImplementation.this, count, timekey2);
                    StatisticKeyImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)StatisticKeyImplementation.this.stats.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<PlayerWithScore> rv = new ArrayList<PlayerWithScore>();
                            for (InternalPlayerWithScore ip : score) {
                                rv.add(new PlayerWithScore(StatisticKeyImplementation.this.stats.getStatistics(ip.getPlayer()), ip.getScore(), ip.getPosition()));
                            }
                            resultCallback.call(rv);
                        }
                    });
                }
                catch (SQLException e) {
                    StatisticKeyImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not get top scores for " + StatisticKeyImplementation.this.name, e);
                }
            }
        });
    }
}

