/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats.api.conditions;

import de.iani.cubesidestats.api.CubesideStatisticsAPI;
import de.iani.cubesidestats.api.SettingKey;
import de.iani.cubesideutils.conditions.Condition;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class HasSettingCondition
implements Condition<Player> {
    public static final String SERIALIZATION_TYPE = "StatisticsHasSettingCondition";
    private static CubesideStatisticsAPI cubesideStatisticsAPI;
    private String settingKey;
    private int compare;
    private CompareOperation op;

    public static HasSettingCondition deserialize(String serialized) {
        String[] parts = serialized.split("\\,");
        return new HasSettingCondition(Condition.unescape((String)parts[0]), Integer.parseInt(parts[1]), CompareOperation.valueOf(parts[2]));
    }

    public HasSettingCondition(String settingKey, int compare, CompareOperation op) {
        this.settingKey = Objects.requireNonNull(settingKey);
        this.compare = compare;
        this.op = Objects.requireNonNull(op);
    }

    public boolean test(Player t) {
        SettingKey key = HasSettingCondition.getCubesideStatisticsAPI().getSettingKey(this.settingKey, false);
        if (key == null) {
            return false;
        }
        int value = HasSettingCondition.getCubesideStatisticsAPI().getStatistics(t.getUniqueId()).getSettingValueOrDefault(key);
        return this.op.apply(value, this.compare);
    }

    public String getSerializationType() {
        return SERIALIZATION_TYPE;
    }

    public String serializeToString() {
        return Condition.escape((String)this.settingKey) + "," + this.compare + "," + this.op.name();
    }

    private static CubesideStatisticsAPI getCubesideStatisticsAPI() {
        CubesideStatisticsAPI local = cubesideStatisticsAPI;
        if (local == null) {
            cubesideStatisticsAPI = local = (CubesideStatisticsAPI)Bukkit.getServer().getServicesManager().load(CubesideStatisticsAPI.class);
        }
        return local;
    }

    public static enum CompareOperation {
        EQUAL{

            @Override
            public boolean apply(int a, int b) {
                return a == b;
            }
        }
        ,
        NOT_EQUAL{

            @Override
            public boolean apply(int a, int b) {
                return a != b;
            }
        }
        ,
        LESS{

            @Override
            public boolean apply(int a, int b) {
                return a < b;
            }
        }
        ,
        LESS_OR_EQUAL{

            @Override
            public boolean apply(int a, int b) {
                return a <= b;
            }
        }
        ,
        GREATER{

            @Override
            public boolean apply(int a, int b) {
                return a > b;
            }
        }
        ,
        GREATER_OR_EQUAL{

            @Override
            public boolean apply(int a, int b) {
                return a >= b;
            }
        };


        public abstract boolean apply(int var1, int var2);
    }
}

