/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import de.iani.cubesidestats.CubesideStatisticsImplementation;
import de.iani.cubesidestats.StatisticsDatabase;
import de.iani.cubesidestats.api.StatisticKey;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class StatisticKeyImplementation
implements StatisticKey {
    private final int id;
    private final String name;
    private final CubesideStatisticsImplementation impl;
    private String displayName;
    private boolean isMonthly;

    public StatisticKeyImplementation(int id, String name, String properties, CubesideStatisticsImplementation impl) {
        this.id = id;
        this.name = name;
        this.impl = impl;
        YamlConfiguration conf = new YamlConfiguration();
        if (properties != null) {
            try {
                conf.loadFromString(properties);
            }
            catch (InvalidConfigurationException e) {
                impl.getPlugin().getLogger().log(Level.SEVERE, "Could not load properties for key " + name + " (" + id + ")", e);
            }
        }
        this.displayName = conf.getString("displayName");
        this.isMonthly = conf.getBoolean("isMonthly");
    }

    public String getSerializedProperties() {
        YamlConfiguration conf = new YamlConfiguration();
        conf.set("displayName", (Object)this.displayName);
        conf.set("isMonthly", (Object)this.isMonthly);
        return conf.saveToString();
    }

    private void save() {
        final StatisticKeyImplementation clone = new StatisticKeyImplementation(this.id, this.name, null, this.impl);
        clone.copyPropertiesFrom(this);
        this.impl.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    database.updateStatisticKey(clone);
                }
                catch (SQLException e) {
                    StatisticKeyImplementation.this.impl.getPlugin().getLogger().log(Level.SEVERE, "Could not save statistic key " + StatisticKeyImplementation.this.name, e);
                }
            }
        });
    }

    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDisplayName(String name) {
        if (Objects.equals(this.name, name)) {
            this.displayName = name;
            this.save();
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setIsMonthlyStats(boolean monthly) {
        if (this.isMonthly != monthly) {
            this.isMonthly = monthly;
            this.save();
        }
    }

    @Override
    public boolean isMonthlyStats() {
        return this.isMonthly;
    }

    public void copyPropertiesFrom(StatisticKeyImplementation e) {
        this.displayName = e.displayName;
        this.isMonthly = e.isMonthly;
    }
}

