/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import de.iani.cubesidestats.CubesideStatisticsImplementation;
import de.iani.cubesidestats.StatisticsDatabase;
import de.iani.cubesidestats.api.GamePlayerCount;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import org.bukkit.scheduler.BukkitRunnable;

public class GamePlayerCountImplementation
implements GamePlayerCount {
    private final CubesideStatisticsImplementation stats;
    private final HashMap<String, Integer> localPlayers;
    private HashMap<String, Integer> globalPlayers;
    private long lastUpdate;

    public GamePlayerCountImplementation(CubesideStatisticsImplementation stats) {
        this.stats = stats;
        this.localPlayers = new HashMap();
        this.globalPlayers = new HashMap();
        this.clearLocalPlayers();
        this.updateGlobalPlayerCount(null);
    }

    public void clearLocalPlayers() {
        this.localPlayers.clear();
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    database.deleteGamePlayers(GamePlayerCountImplementation.this.stats.getServerId());
                }
                catch (SQLException e) {
                    GamePlayerCountImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not clear games playercounts", e);
                }
            }
        });
    }

    @Override
    public void addLocalPlayers(String game, int amount) {
        if (amount == 0) {
            return;
        }
        int newAmount = amount + this.getLocalPlayers(game);
        if (newAmount != 0) {
            this.localPlayers.put(game, newAmount);
        } else {
            this.localPlayers.remove(game);
        }
        this.updateDatabasePlayers(game, newAmount);
    }

    @Override
    public void subtractLocalPlayers(String game, int amount) {
        this.addLocalPlayers(game, -amount);
    }

    @Override
    public void setLocalPlayers(String game, int amount) {
        if (amount != 0) {
            this.localPlayers.put(game, amount);
        } else {
            this.localPlayers.remove(game);
        }
        this.updateDatabasePlayers(game, amount);
    }

    private void updateDatabasePlayers(final String game, final int newAmount) {
        if (this.stats.getPlugin().isEnabled()) {
            this.stats.getPlugin().getServer().getScheduler().runTask(this.stats.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    GamePlayerCountImplementation.this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

                        @Override
                        public void process(StatisticsDatabase database) {
                            try {
                                database.setGamePlayers(GamePlayerCountImplementation.this.stats.getServerId(), game, newAmount);
                            }
                            catch (SQLException e) {
                                GamePlayerCountImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not set player amount " + game, e);
                            }
                        }
                    });
                }
            });
        }
    }

    @Override
    public void updateGlobalPlayerCount(final Runnable callback) {
        if (this.lastUpdate + 10000L > System.currentTimeMillis()) {
            if (callback != null) {
                callback.run();
            }
            return;
        }
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                HashMap<String, Integer> globalPlayersNew = null;
                try {
                    globalPlayersNew = database.getGamePlayers(GamePlayerCountImplementation.this.stats.getServerId());
                }
                catch (SQLException e) {
                    GamePlayerCountImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not get global player amount", e);
                }
                final HashMap<String, Integer> globalPlayersNew2 = globalPlayersNew;
                if (GamePlayerCountImplementation.this.stats.getPlugin().isEnabled()) {
                    new BukkitRunnable(){

                        public void run() {
                            if (globalPlayersNew2 != null) {
                                GamePlayerCountImplementation.this.globalPlayers = globalPlayersNew2;
                            }
                            GamePlayerCountImplementation.this.lastUpdate = System.currentTimeMillis();
                            if (callback != null) {
                                callback.run();
                            }
                        }
                    }.runTask(GamePlayerCountImplementation.this.stats.getPlugin());
                }
            }
        });
    }

    @Override
    public int getLocalPlayers(String game) {
        Integer local = this.localPlayers.get(game);
        return local == null ? 0 : local;
    }

    private int getGlobalPlayers(String game) {
        Integer global = this.globalPlayers.get(game);
        return global == null ? 0 : global;
    }

    @Override
    public int getPlayers(String game) {
        return this.getLocalPlayers(game) + this.getGlobalPlayers(game);
    }
}

