/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats.api.event;

import de.iani.cubesidestats.api.StatisticKey;
import java.util.UUID;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class PlayerStatisticUpdatedEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final StatisticKey statistic;
    private final UUID player;
    private final Integer previousValueAllTime;
    private final int newValueAllTime;
    private final Integer previousValueMonthly;
    private final int newValueMonthly;
    private final Integer previousValueDaily;
    private final int newValueDaily;

    public PlayerStatisticUpdatedEvent(UUID who, StatisticKey statistic, Integer previousAlltime, int newAlltime, Integer previousMonthly, int newMonthly, Integer previousDaily, int newDaily) {
        this.player = who;
        this.statistic = statistic;
        this.previousValueAllTime = previousAlltime;
        this.newValueAllTime = newAlltime;
        this.previousValueMonthly = previousMonthly;
        this.newValueMonthly = newMonthly;
        this.previousValueDaily = previousDaily;
        this.newValueDaily = newDaily;
    }

    public StatisticKey getStatistic() {
        return this.statistic;
    }

    public UUID getPlayerUUID() {
        return this.player;
    }

    public boolean hasPreviousValueAllTime() {
        return this.previousValueAllTime != null;
    }

    public int getPreviousValueAllTime() {
        if (this.previousValueAllTime == null) {
            throw new IllegalStateException("There is no previous all time value for " + this.statistic.getName() + " and " + this.player);
        }
        return this.previousValueAllTime;
    }

    public int getValueAllTime() {
        return this.newValueAllTime;
    }

    public boolean hasPreviousValueMonthly() {
        if (!this.statistic.isMonthlyStats()) {
            throw new IllegalStateException("Stats " + this.statistic.getName() + " is not recored monthly");
        }
        return this.previousValueMonthly != null;
    }

    public int getPreviousValueMonthly() {
        if (!this.statistic.isMonthlyStats()) {
            throw new IllegalStateException("Stats " + this.statistic.getName() + " is not recored monthly");
        }
        if (this.previousValueMonthly == null) {
            throw new IllegalStateException("There is no previous monthly value for " + this.statistic.getName() + " and " + this.player);
        }
        return this.previousValueMonthly;
    }

    public int getValueMonthly() {
        if (!this.statistic.isMonthlyStats()) {
            throw new IllegalStateException("Stats " + this.statistic.getName() + " is not recored monthly");
        }
        return this.newValueMonthly;
    }

    public boolean hasPreviousValueDaily() {
        if (!this.statistic.isDailyStats()) {
            throw new IllegalStateException("Stats " + this.statistic.getName() + " is not recored daily");
        }
        return this.previousValueDaily != null;
    }

    public int getPreviousValueDaily() {
        if (!this.statistic.isDailyStats()) {
            throw new IllegalStateException("Stats " + this.statistic.getName() + " is not recored daily");
        }
        if (this.previousValueDaily == null) {
            throw new IllegalStateException("There is no previous daily value for " + this.statistic.getName() + " and " + this.player);
        }
        return this.previousValueDaily;
    }

    public int getValueDaily() {
        if (!this.statistic.isDailyStats()) {
            throw new IllegalStateException("Stats " + this.statistic.getName() + " is not recored daily");
        }
        return this.newValueDaily;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

