/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import com.google.common.base.Preconditions;
import de.iani.cubesidestats.AchivementKeyImplementation;
import de.iani.cubesidestats.CubesideStatistics;
import de.iani.cubesidestats.GamePlayerCountImplementation;
import de.iani.cubesidestats.GlobalStatisticKeyImplementation;
import de.iani.cubesidestats.GlobalStatisticsImplementation;
import de.iani.cubesidestats.PlayerListener;
import de.iani.cubesidestats.PlayerStatisticsImplementation;
import de.iani.cubesidestats.SQLConfig;
import de.iani.cubesidestats.SettingKeyImplementation;
import de.iani.cubesidestats.StatisticKeyImplementation;
import de.iani.cubesidestats.StatisticsDatabase;
import de.iani.cubesidestats.TimestampedValue;
import de.iani.cubesidestats.api.AchivementKey;
import de.iani.cubesidestats.api.Callback;
import de.iani.cubesidestats.api.CubesideStatisticsAPI;
import de.iani.cubesidestats.api.GamePlayerCount;
import de.iani.cubesidestats.api.GlobalStatisticKey;
import de.iani.cubesidestats.api.GlobalStatistics;
import de.iani.cubesidestats.api.GlobalStatisticsQueryKey;
import de.iani.cubesidestats.api.PlayerAchivementQueryKey;
import de.iani.cubesidestats.api.PlayerStatistics;
import de.iani.cubesidestats.api.PlayerStatisticsQueryKey;
import de.iani.cubesidestats.api.SettingKey;
import de.iani.cubesidestats.api.StatisticKey;
import de.iani.cubesidestats.api.StatisticsQueryKey;
import de.iani.cubesidestats.api.TimeFrame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class CubesideStatisticsImplementation
implements CubesideStatisticsAPI {
    private GlobalStatisticsImplementation globalStatistics;
    private ConcurrentHashMap<String, GlobalStatisticKeyImplementation> globalStatisticKeys;
    private ConcurrentHashMap<String, StatisticKeyImplementation> statisticKeys;
    private ConcurrentHashMap<String, AchivementKeyImplementation> achivementKeys;
    private ConcurrentHashMap<String, SettingKeyImplementation> settingKeys;
    private HashMap<UUID, PlayerStatisticsImplementation> onlinePlayers;
    private HashMap<UUID, TimestampedValue<PlayerStatisticsImplementation>> offlinePlayers;
    private StatisticsDatabase database;
    private CubesideStatistics plugin;
    private WorkerThread workerThread;
    private int configSerial = -1;
    private static final int CONFIG_RELOAD_TICKS = 6000;
    private static final long MIN_CACHE_NANOS = 300000000000L;
    private final Calendar calender = Calendar.getInstance();
    private final UUID serverid;
    private final GamePlayerCountImplementation gamePlayerCount;
    private final Object playerListSync = new Object();
    private final Object keySync = new Object();

    public CubesideStatisticsImplementation(CubesideStatistics plugin) throws SQLException {
        this.plugin = plugin;
        plugin.saveDefaultConfig();
        this.serverid = this.loadOrCreateServerId();
        this.database = new StatisticsDatabase(this, new SQLConfig(plugin.getConfig().getConfigurationSection("database")));
        this.globalStatisticKeys = new ConcurrentHashMap();
        this.statisticKeys = new ConcurrentHashMap();
        this.achivementKeys = new ConcurrentHashMap();
        this.settingKeys = new ConcurrentHashMap();
        this.onlinePlayers = new HashMap();
        this.offlinePlayers = new HashMap();
        this.reloadConfigNow();
        plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                CubesideStatisticsImplementation.this.cleanupCache();
                CubesideStatisticsImplementation.this.reloadConfig();
            }
        }, 6000L, 6000L);
        plugin.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)plugin);
        this.workerThread = new WorkerThread();
        this.workerThread.start();
        this.gamePlayerCount = new GamePlayerCountImplementation(this);
        this.globalStatistics = new GlobalStatisticsImplementation(this);
    }

    private UUID loadOrCreateServerId() {
        File serveridFile = new File(this.plugin.getDataFolder().getParentFile().getParentFile(), "serverid");
        String serveridstring = null;
        if (serveridFile.isFile()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(serveridFile));
                serveridstring = reader.readLine();
                reader.close();
            }
            catch (IOException reader) {
                // empty catch block
            }
        }
        UUID localServerid = null;
        try {
            localServerid = serveridstring == null ? null : UUID.fromString(serveridstring);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (localServerid == null) {
            this.plugin.getLogger().info("Keine g\u00fcltige Server-ID vorhanden! Generiere neue ID!");
            localServerid = UUID.randomUUID();
            try {
                FileWriter writer = new FileWriter(serveridFile);
                writer.write(localServerid.toString());
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save server id file", e);
            }
        }
        return localServerid;
    }

    public void shutdown() {
        if (this.workerThread != null) {
            this.gamePlayerCount.clearLocalPlayers();
            this.workerThread.shutdown();
        }
    }

    public WorkerThread getWorkerThread() {
        return this.workerThread;
    }

    public CubesideStatistics getPlugin() {
        return this.plugin;
    }

    private void reloadConfig() {
        this.getWorkerThread().addWork(new WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                CubesideStatisticsImplementation.this.reloadConfigNow();
            }
        });
    }

    protected void reloadConfigNow() {
        try {
            final StatisticsDatabase.ConfigDTO config = this.database.loadConfig(this.configSerial);
            if (config == null) {
                return;
            }
            Runnable mainTheadLogic = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (config.getConfigSerial() <= CubesideStatisticsImplementation.this.configSerial) {
                        return;
                    }
                    CubesideStatisticsImplementation.this.configSerial = config.getConfigSerial();
                    Object object = CubesideStatisticsImplementation.this.keySync;
                    synchronized (object) {
                        Collection<GlobalStatisticKeyImplementation> newGlobalStatisticKeys = config.getGlobalStatisticKeys();
                        for (GlobalStatisticKeyImplementation globalStatisticKeyImplementation : newGlobalStatisticKeys) {
                            GlobalStatisticKeyImplementation globalStatisticKeyImplementation2 = CubesideStatisticsImplementation.this.globalStatisticKeys.get(globalStatisticKeyImplementation.getName());
                            if (globalStatisticKeyImplementation2 != null) {
                                globalStatisticKeyImplementation2.copyPropertiesFrom(globalStatisticKeyImplementation);
                                continue;
                            }
                            CubesideStatisticsImplementation.this.globalStatisticKeys.put(globalStatisticKeyImplementation.getName(), globalStatisticKeyImplementation);
                        }
                        Collection<StatisticKeyImplementation> newStatisticKeys = config.getStatisticKeys();
                        for (StatisticKeyImplementation statisticKeyImplementation : newStatisticKeys) {
                            StatisticKeyImplementation old = CubesideStatisticsImplementation.this.statisticKeys.get(statisticKeyImplementation.getName());
                            if (old != null) {
                                old.copyPropertiesFrom(statisticKeyImplementation);
                                continue;
                            }
                            CubesideStatisticsImplementation.this.statisticKeys.put(statisticKeyImplementation.getName(), statisticKeyImplementation);
                        }
                        Collection<AchivementKeyImplementation> collection = config.getAchivementKeys();
                        for (AchivementKeyImplementation e : collection) {
                            AchivementKeyImplementation old = CubesideStatisticsImplementation.this.achivementKeys.get(e.getName());
                            if (old != null) {
                                old.copyPropertiesFrom(e);
                                continue;
                            }
                            CubesideStatisticsImplementation.this.achivementKeys.put(e.getName(), e);
                        }
                        Collection<SettingKeyImplementation> collection2 = config.getSettingKeys();
                        for (SettingKeyImplementation e : collection2) {
                            SettingKeyImplementation old = CubesideStatisticsImplementation.this.settingKeys.get(e.getName());
                            if (old != null) {
                                old.copyPropertiesFrom(e);
                                continue;
                            }
                            CubesideStatisticsImplementation.this.settingKeys.put(e.getName(), e);
                        }
                    }
                    CubesideStatisticsImplementation.this.plugin.getLogger().info("Reloaded config from the database");
                }
            };
            if (this.plugin.getServer().isPrimaryThread()) {
                mainTheadLogic.run();
            } else {
                this.getPlugin().getServer().getScheduler().runTask((Plugin)this.getPlugin(), mainTheadLogic);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Could not reload the config from the database", e);
        }
    }

    @Override
    public GlobalStatistics getGlobalStatistics() {
        return this.globalStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlayerStatistics getStatistics(UUID owner) {
        Object object = this.playerListSync;
        synchronized (object) {
            PlayerStatisticsImplementation stats = this.onlinePlayers.get(owner);
            if (stats != null) {
                return stats;
            }
            TimestampedValue<PlayerStatisticsImplementation> timestampedStats = this.offlinePlayers.get(owner);
            if (timestampedStats != null) {
                return timestampedStats.get();
            }
            stats = new PlayerStatisticsImplementation(this, owner, null);
            this.offlinePlayers.put(owner, new TimestampedValue<PlayerStatisticsImplementation>(stats));
            return stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupCache() {
        Object object = this.playerListSync;
        synchronized (object) {
            if (!this.offlinePlayers.isEmpty()) {
                long minTimestamp = System.nanoTime() - 300000000000L;
                Iterator<TimestampedValue<PlayerStatisticsImplementation>> it = this.offlinePlayers.values().iterator();
                while (it.hasNext()) {
                    TimestampedValue<PlayerStatisticsImplementation> current = it.next();
                    if (current.getTimestamp() >= minTimestamp) continue;
                    it.remove();
                }
            }
        }
    }

    @Override
    public GlobalStatisticKey getGlobalStatisticKey(String id) {
        return this.getGlobalStatisticKey(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalStatisticKey getGlobalStatisticKey(String id, boolean create) {
        GlobalStatisticKeyImplementation existing = this.globalStatisticKeys.get(id);
        if (existing == null && create) {
            this.reloadConfigNow();
            Object object = this.keySync;
            synchronized (object) {
                existing = this.globalStatisticKeys.get(id);
                if (existing == null) {
                    try {
                        existing = this.database.createGlobalStatisticKey(id);
                        this.globalStatisticKeys.put(existing.getName(), existing);
                    }
                    catch (SQLException e) {
                        this.plugin.getLogger().log(Level.SEVERE, "Could not create global statistics key", e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return existing;
    }

    @Override
    public boolean hasGlobalStatisticKey(String id) {
        return this.globalStatisticKeys.containsKey(id);
    }

    @Override
    public Collection<? extends GlobalStatisticKey> getAllGlobalStatisticKeys() {
        return Collections.unmodifiableCollection(this.globalStatisticKeys.values());
    }

    @Override
    public StatisticKey getStatisticKey(String id) {
        return this.getStatisticKey(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatisticKey getStatisticKey(String id, boolean create) {
        StatisticKeyImplementation existing = this.statisticKeys.get(id);
        if (existing == null && create) {
            this.reloadConfigNow();
            Object object = this.keySync;
            synchronized (object) {
                existing = this.statisticKeys.get(id);
                if (existing == null) {
                    try {
                        existing = this.database.createStatisticKey(id);
                        this.statisticKeys.put(existing.getName(), existing);
                    }
                    catch (SQLException e) {
                        this.plugin.getLogger().log(Level.SEVERE, "Could not create statistics key", e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return existing;
    }

    @Override
    public boolean hasStatisticKey(String id) {
        return this.statisticKeys.containsKey(id);
    }

    @Override
    public Collection<? extends StatisticKey> getAllStatisticKeys() {
        return Collections.unmodifiableCollection(this.statisticKeys.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playerJoined(Player player) {
        Object object = this.playerListSync;
        synchronized (object) {
            TimestampedValue<PlayerStatisticsImplementation> old = this.offlinePlayers.remove(player.getUniqueId());
            this.onlinePlayers.put(player.getUniqueId(), old == null ? new PlayerStatisticsImplementation(this, player.getUniqueId(), this.settingKeys.values()) : old.get().reloadSettingsAsync(this.settingKeys.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playerDisconnected(Player player) {
        Object object = this.playerListSync;
        synchronized (object) {
            PlayerStatisticsImplementation old = this.onlinePlayers.remove(player.getUniqueId());
            if (old != null) {
                this.offlinePlayers.put(player.getUniqueId(), new TimestampedValue<PlayerStatisticsImplementation>(old));
            }
        }
    }

    public int getCurrentMonthKey() {
        this.calender.setTimeInMillis(System.currentTimeMillis());
        return this.calender.get(1) * 100 + this.calender.get(2) + 1;
    }

    public int getCurrentDayKey() {
        this.calender.setTimeInMillis(System.currentTimeMillis());
        return this.calender.get(1) * 1000 + this.calender.get(6);
    }

    public UUID getServerId() {
        return this.serverid;
    }

    @Override
    public GamePlayerCount getGamePlayerCount() {
        return this.gamePlayerCount;
    }

    @Override
    public AchivementKey getAchivementKey(String id) {
        return this.getAchivementKey(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AchivementKey getAchivementKey(String id, boolean create) {
        AchivementKeyImplementation existing = this.achivementKeys.get(id);
        if (existing == null && create) {
            this.reloadConfigNow();
            Object object = this.keySync;
            synchronized (object) {
                existing = this.achivementKeys.get(id);
                if (existing == null) {
                    try {
                        existing = this.database.createAchivementKey(id);
                        this.achivementKeys.put(existing.getName(), existing);
                    }
                    catch (SQLException e) {
                        this.plugin.getLogger().log(Level.SEVERE, "Could not create statistics key", e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return existing;
    }

    @Override
    public Collection<? extends AchivementKey> getAllAchivementKeys() {
        return Collections.unmodifiableCollection(this.achivementKeys.values());
    }

    @Override
    public boolean hasAchivementKey(String id) {
        return this.achivementKeys.containsKey(id);
    }

    @Override
    public SettingKey getSettingKey(String id) {
        return this.getSettingKey(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SettingKey getSettingKey(String id, boolean create) {
        SettingKeyImplementation existing = this.settingKeys.get(id);
        if (existing == null && create) {
            this.reloadConfigNow();
            Object object = this.keySync;
            synchronized (object) {
                existing = this.settingKeys.get(id);
                if (existing == null) {
                    try {
                        existing = this.database.createSettingKey(id);
                        this.settingKeys.put(existing.getName(), existing);
                    }
                    catch (SQLException e) {
                        this.plugin.getLogger().log(Level.SEVERE, "Could not create setting key", e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return existing;
    }

    @Override
    public boolean hasSettingKey(String id) {
        return this.settingKeys.containsKey(id);
    }

    @Override
    public Collection<? extends SettingKey> getAllSettingKeys() {
        return Collections.unmodifiableCollection(this.settingKeys.values());
    }

    @Override
    public Future<Map<StatisticsQueryKey, Integer>> queryStats(Collection<StatisticsQueryKey> querys) {
        return this.queryStatsInternal(querys, null);
    }

    @Override
    public void queryStats(Collection<StatisticsQueryKey> querys, Callback<Map<StatisticsQueryKey, Integer>> callback) {
        this.queryStatsInternal(querys, callback);
    }

    private Future<Map<StatisticsQueryKey, Integer>> queryStatsInternal(Collection<StatisticsQueryKey> querys, final Callback<Map<StatisticsQueryKey, Integer>> callback) {
        Preconditions.checkNotNull(querys, (Object)"querys");
        final ArrayList<StatisticsQueryKey> internalQuerys = new ArrayList<StatisticsQueryKey>(querys);
        final int currentMonthKey = this.getCurrentMonthKey();
        final int currentDayKey = this.getCurrentDayKey();
        final CompletableFuture<Map<StatisticsQueryKey, Integer>> future = new CompletableFuture<Map<StatisticsQueryKey, Integer>>();
        this.getWorkerThread().addWork(new WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                final HashMap<StatisticsQueryKey, Integer> result = new HashMap<StatisticsQueryKey, Integer>();
                for (StatisticsQueryKey queryKey : internalQuerys) {
                    Integer score;
                    StatisticsQueryKey playerQueryKey;
                    if (queryKey instanceof PlayerStatisticsQueryKey) {
                        Integer pos;
                        playerQueryKey = (PlayerStatisticsQueryKey)queryKey;
                        if (!(((PlayerStatisticsQueryKey)playerQueryKey).getPlayer() instanceof PlayerStatisticsImplementation)) continue;
                        int timeKey = -1;
                        if (((PlayerStatisticsQueryKey)playerQueryKey).getTimeFrame() == TimeFrame.MONTH) {
                            timeKey = currentMonthKey;
                        } else if (((PlayerStatisticsQueryKey)playerQueryKey).getTimeFrame() == TimeFrame.DAY) {
                            timeKey = currentDayKey;
                        }
                        PlayerStatisticsImplementation player = (PlayerStatisticsImplementation)((PlayerStatisticsQueryKey)playerQueryKey).getPlayer();
                        if (((PlayerStatisticsQueryKey)playerQueryKey).getType() == PlayerStatisticsQueryKey.QueryType.POSITION_MAX) {
                            pos = player.internalGetPositionMaxInMonth(database, ((PlayerStatisticsQueryKey)playerQueryKey).getKey(), timeKey);
                            if (pos == null) continue;
                            result.put(queryKey, pos);
                            continue;
                        }
                        if (((PlayerStatisticsQueryKey)playerQueryKey).getType() == PlayerStatisticsQueryKey.QueryType.POSITION_MIN) {
                            pos = player.internalGetPositionMinInMonth(database, ((PlayerStatisticsQueryKey)playerQueryKey).getKey(), timeKey);
                            if (pos == null) continue;
                            result.put(queryKey, pos);
                            continue;
                        }
                        if (((PlayerStatisticsQueryKey)playerQueryKey).getType() != PlayerStatisticsQueryKey.QueryType.SCORE) continue;
                        Integer score2 = player.internalGetScoreInMonth(database, ((PlayerStatisticsQueryKey)playerQueryKey).getKey(), timeKey);
                        result.put(queryKey, score2);
                        continue;
                    }
                    if (queryKey instanceof PlayerAchivementQueryKey) {
                        PlayerStatisticsImplementation player;
                        Integer level;
                        playerQueryKey = (PlayerAchivementQueryKey)queryKey;
                        if (!(((PlayerAchivementQueryKey)playerQueryKey).getPlayer() instanceof PlayerStatisticsImplementation) || (level = (player = (PlayerStatisticsImplementation)((PlayerAchivementQueryKey)playerQueryKey).getPlayer()).internalGetAchivementLevel(database, ((PlayerAchivementQueryKey)playerQueryKey).getKey())) == null) continue;
                        result.put(queryKey, level);
                        continue;
                    }
                    if (!(queryKey instanceof GlobalStatisticsQueryKey)) continue;
                    GlobalStatisticsQueryKey globalQueryKey = (GlobalStatisticsQueryKey)queryKey;
                    int timeKey = -1;
                    if (globalQueryKey.getTimeFrame() == TimeFrame.MONTH) {
                        timeKey = currentMonthKey;
                    } else if (globalQueryKey.getTimeFrame() == TimeFrame.DAY) {
                        timeKey = currentDayKey;
                    }
                    if ((score = CubesideStatisticsImplementation.this.globalStatistics.internalGetScoreInMonth(database, globalQueryKey.getKey(), timeKey)) == null) continue;
                    result.put(queryKey, score);
                }
                future.complete(result);
                if (callback != null) {
                    CubesideStatisticsImplementation.this.getPlugin().getServer().getScheduler().runTask((Plugin)CubesideStatisticsImplementation.this.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            callback.call(result);
                        }
                    });
                }
            }
        });
        return future;
    }

    public class WorkerThread
    extends Thread {
        private StatisticsDatabase database;
        private boolean stopping;
        private ArrayDeque<WorkEntry> work = new ArrayDeque();

        public WorkerThread() {
            this.database = CubesideStatisticsImplementation.this.database;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addWork(WorkEntry e) {
            ArrayDeque<WorkEntry> arrayDeque = this.work;
            synchronized (arrayDeque) {
                this.work.addLast(e);
                this.work.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            ArrayDeque<WorkEntry> arrayDeque = this.work;
            synchronized (arrayDeque) {
                this.stopping = true;
                this.work.notify();
            }
            boolean interrupt = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    interrupt = true;
                }
            }
            if (interrupt) {
                Thread.currentThread().interrupt();
            }
            if (this.database != null) {
                this.database.disconnect();
                this.database = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                WorkEntry e;
                ArrayDeque<WorkEntry> arrayDeque = this.work;
                synchronized (arrayDeque) {
                    e = this.work.pollFirst();
                    if (e == null) {
                        if (this.stopping) {
                            return;
                        }
                        try {
                            this.work.wait();
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                if (e == null || this.database == null) continue;
                try {
                    e.process(this.database);
                    continue;
                }
                catch (Throwable er) {
                    CubesideStatisticsImplementation.this.plugin.getLogger().log(Level.SEVERE, "Error in Statistics", er);
                    continue;
                }
                break;
            }
        }
    }

    public static interface WorkEntry {
        public void process(StatisticsDatabase var1);
    }
}

