/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import de.iani.cubesidestats.CubesideStatistics;
import de.iani.cubesidestats.PlayerListener;
import de.iani.cubesidestats.PlayerStatisticsImplementation;
import de.iani.cubesidestats.SQLConfig;
import de.iani.cubesidestats.StatisticKeyImplementation;
import de.iani.cubesidestats.StatisticsDatabase;
import de.iani.cubesidestats.TimestampedValue;
import de.iani.cubesidestats.api.CubesideStatisticsAPI;
import de.iani.cubesidestats.api.PlayerStatistics;
import de.iani.cubesidestats.api.StatisticKey;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class CubesideStatisticsImplementation
implements CubesideStatisticsAPI {
    private HashMap<String, StatisticKeyImplementation> statisticKeys;
    private HashMap<UUID, PlayerStatisticsImplementation> onlinePlayers;
    private HashMap<UUID, TimestampedValue<PlayerStatisticsImplementation>> offlinePlayers;
    private StatisticsDatabase database;
    private CubesideStatistics plugin;
    private WorkerThread workerThread;
    private int configSerial = -1;
    private static final int CONFIG_RELOAD_TICKS = 6000;
    private static final long MIN_CACHE_NANOS = 300000000000L;

    public CubesideStatisticsImplementation(CubesideStatistics plugin) throws SQLException {
        this.plugin = plugin;
        this.database = new StatisticsDatabase(plugin, new SQLConfig(plugin.getConfig().getConfigurationSection("database")));
        this.statisticKeys = new HashMap();
        this.onlinePlayers = new HashMap();
        this.offlinePlayers = new HashMap();
        this.reloadConfigNow();
        plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                CubesideStatisticsImplementation.this.cleanupCache();
                CubesideStatisticsImplementation.this.reloadConfig();
            }
        }, 6000L, 6000L);
        plugin.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)plugin);
        this.workerThread = new WorkerThread();
        this.workerThread.start();
    }

    public void shutdown() {
        if (this.workerThread != null) {
            this.workerThread.shutdown();
        }
    }

    public WorkerThread getWorkerThread() {
        return this.workerThread;
    }

    public CubesideStatistics getPlugin() {
        return this.plugin;
    }

    private void reloadConfig() {
        this.getWorkerThread().addWork(new WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                CubesideStatisticsImplementation.this.reloadConfigNow();
            }
        });
    }

    protected void reloadConfigNow() {
        try {
            final StatisticsDatabase.ConfigDTO config = this.database.loadConfig(this.configSerial);
            if (config == null) {
                return;
            }
            Runnable mainTheadLogic = new Runnable(){

                @Override
                public void run() {
                    if (config.getConfigSerial() <= CubesideStatisticsImplementation.this.configSerial) {
                        return;
                    }
                    CubesideStatisticsImplementation.this.configSerial = config.getConfigSerial();
                    Collection<StatisticKeyImplementation> keys = config.getStatisticKeys();
                    for (StatisticKeyImplementation e : keys) {
                        StatisticKeyImplementation old = (StatisticKeyImplementation)CubesideStatisticsImplementation.this.statisticKeys.get(e.getName());
                        if (old != null) {
                            old.copyPropertiesFrom(e);
                            continue;
                        }
                        CubesideStatisticsImplementation.this.statisticKeys.put(e.getName(), e);
                    }
                    CubesideStatisticsImplementation.this.plugin.getLogger().info("Reloaded config from the database");
                }
            };
            if (this.plugin.getServer().isPrimaryThread()) {
                mainTheadLogic.run();
            } else {
                this.getPlugin().getServer().getScheduler().runTask((Plugin)this.getPlugin(), mainTheadLogic);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Could not reload the config from the database", e);
        }
    }

    @Override
    public PlayerStatistics getStatistics(UUID owner) {
        PlayerStatisticsImplementation stats = this.onlinePlayers.get(owner);
        if (stats != null) {
            return stats;
        }
        TimestampedValue<PlayerStatisticsImplementation> timestampedStats = this.offlinePlayers.get(owner);
        if (timestampedStats != null) {
            return timestampedStats.get();
        }
        stats = new PlayerStatisticsImplementation(this, owner);
        this.offlinePlayers.put(owner, new TimestampedValue<PlayerStatisticsImplementation>(stats));
        return stats;
    }

    private void cleanupCache() {
        if (!this.offlinePlayers.isEmpty()) {
            long minTimestamp = System.nanoTime() - 300000000000L;
            Iterator<TimestampedValue<PlayerStatisticsImplementation>> it = this.offlinePlayers.values().iterator();
            while (it.hasNext()) {
                TimestampedValue<PlayerStatisticsImplementation> current = it.next();
                if (current.getTimestamp() >= minTimestamp) continue;
                it.remove();
            }
        }
    }

    @Override
    public StatisticKey getStatisticKey(String id) {
        return this.statisticKeys.get(id);
    }

    @Override
    public boolean hasStatisticKey(String id) {
        return this.statisticKeys.containsKey(id);
    }

    public void playerJoined(Player player) {
        TimestampedValue<PlayerStatisticsImplementation> old = this.offlinePlayers.remove(player.getUniqueId());
        this.onlinePlayers.put(player.getUniqueId(), old == null ? new PlayerStatisticsImplementation(this, player.getUniqueId()) : old.get());
    }

    public void playerDisconnected(Player player) {
        PlayerStatisticsImplementation old = this.onlinePlayers.remove(player.getUniqueId());
        if (old != null) {
            this.offlinePlayers.put(player.getUniqueId(), new TimestampedValue<PlayerStatisticsImplementation>(old));
        }
    }

    public static interface WorkEntry {
        public void process(StatisticsDatabase var1);
    }

    public class WorkerThread
    extends Thread {
        private StatisticsDatabase database;
        private boolean stopping;
        private ArrayDeque<WorkEntry> work = new ArrayDeque();

        public WorkerThread() {
            this.database = CubesideStatisticsImplementation.this.database;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addWork(WorkEntry e) {
            ArrayDeque<WorkEntry> arrayDeque = this.work;
            synchronized (arrayDeque) {
                this.work.addLast(e);
                this.work.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            ArrayDeque<WorkEntry> arrayDeque = this.work;
            synchronized (arrayDeque) {
                this.stopping = true;
                this.work.notify();
            }
            boolean interrupt = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    interrupt = true;
                }
            }
            if (interrupt) {
                Thread.currentThread().interrupt();
            }
            if (this.database != null) {
                this.database.disconnect();
                this.database = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                WorkEntry e;
                ArrayDeque<WorkEntry> arrayDeque = this.work;
                synchronized (arrayDeque) {
                    e = this.work.pollFirst();
                    if (e == null) {
                        if (this.stopping) {
                            return;
                        }
                        try {
                            this.work.wait();
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                if (e == null || this.database == null) continue;
                try {
                    e.process(this.database);
                    continue;
                }
                catch (Exception er) {
                    CubesideStatisticsImplementation.this.plugin.getLogger().log(Level.SEVERE, "Error in Statistics", er);
                    continue;
                }
                break;
            }
        }
    }
}

