/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import de.iani.cubesidestats.AchivementKeyImplementation;
import de.iani.cubesidestats.CubesideStatisticsImplementation;
import de.iani.cubesidestats.SettingKeyImplementation;
import de.iani.cubesidestats.StatisticKeyImplementation;
import de.iani.cubesidestats.StatisticsDatabase;
import de.iani.cubesidestats.api.AchivementKey;
import de.iani.cubesidestats.api.Callback;
import de.iani.cubesidestats.api.PlayerStatistics;
import de.iani.cubesidestats.api.SettingKey;
import de.iani.cubesidestats.api.StatisticKey;
import de.iani.cubesidestats.api.TimeFrame;
import de.iani.cubesidestats.api.event.PlayerSettingsLoadedEvent;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerStatisticsImplementation
implements PlayerStatistics {
    private CubesideStatisticsImplementation stats;
    private final UUID playerId;
    private int databaseId;
    private HashSet<SettingKeyImplementation> doNotLoadSettings;
    private final HashMap<SettingKeyImplementation, Integer> settings;
    private boolean settingsLoaded;

    public PlayerStatisticsImplementation(final CubesideStatisticsImplementation stats, final UUID player, final Collection<SettingKeyImplementation> settingKeys) {
        if (player == null) {
            throw new NullPointerException("player");
        }
        if (stats == null) {
            throw new NullPointerException("stats");
        }
        this.stats = stats;
        this.playerId = player;
        this.databaseId = -1;
        this.settingsLoaded = false;
        this.settings = new HashMap();
        stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    PlayerStatisticsImplementation.this.databaseId = database.getOrCreatePlayerId(player);
                    if (settingKeys != null) {
                        PlayerStatisticsImplementation.this.internalLoadSettings(settingKeys, database);
                    }
                }
                catch (SQLException e) {
                    stats.getPlugin().getLogger().log(Level.SEVERE, "Could not load database id or settings for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    public PlayerStatisticsImplementation reloadSettingsAsync(final Collection<SettingKeyImplementation> settingKeys) {
        this.settings.clear();
        this.doNotLoadSettings = null;
        this.settingsLoaded = false;
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    PlayerStatisticsImplementation.this.internalLoadSettings(settingKeys, database);
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not load settings for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
        return this;
    }

    protected void internalLoadSettings(Collection<SettingKeyImplementation> settingKeys, StatisticsDatabase database) throws SQLException {
        final HashMap<SettingKeyImplementation, Integer> settingsTemp = database.getSettingValues(this.databaseId, settingKeys);
        new BukkitRunnable(){

            public void run() {
                for (Map.Entry e : settingsTemp.entrySet()) {
                    SettingKeyImplementation key = (SettingKeyImplementation)e.getKey();
                    if (PlayerStatisticsImplementation.this.doNotLoadSettings != null && PlayerStatisticsImplementation.this.doNotLoadSettings.contains(key)) continue;
                    PlayerStatisticsImplementation.this.settings.put(key, e.getValue());
                }
                PlayerStatisticsImplementation.this.doNotLoadSettings = null;
                PlayerStatisticsImplementation.this.settingsLoaded = true;
                Player owner = PlayerStatisticsImplementation.this.stats.getPlugin().getServer().getPlayer(PlayerStatisticsImplementation.this.playerId);
                if (owner != null) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getServer().getPluginManager().callEvent((Event)new PlayerSettingsLoadedEvent(owner));
                }
            }
        }.runTask((Plugin)this.stats.getPlugin());
    }

    @Override
    public UUID getOwner() {
        return this.playerId;
    }

    @Override
    public void decreaseScore(StatisticKey key, int amount) {
        this.increaseScore(key, -amount);
    }

    @Override
    public void increaseScore(final StatisticKey key, final int amount) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        final int month = this.stats.getCurrentMonthKey();
        final int daykey = this.stats.getCurrentDayKey();
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    database.increaseScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month, daykey, amount);
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not increase score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    @Override
    public void setScore(final StatisticKey key, final int value) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        final int month = this.stats.getCurrentMonthKey();
        final int daykey = this.stats.getCurrentDayKey();
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    database.setScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month, daykey, value);
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not set score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    @Override
    public void maxScore(StatisticKey key, int value) {
        this.maxScore(key, value, null);
    }

    @Override
    public void maxScore(final StatisticKey key, final int value, final Callback<Boolean> updatedCallback) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        final int month = this.stats.getCurrentMonthKey();
        final int daykey = this.stats.getCurrentDayKey();
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    final boolean result = database.maxScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month, daykey, value);
                    if (updatedCallback != null) {
                        PlayerStatisticsImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)PlayerStatisticsImplementation.this.stats.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                updatedCallback.call(result);
                            }
                        });
                    }
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not set score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    @Override
    public void minScore(StatisticKey key, int value) {
        this.minScore(key, value, null);
    }

    @Override
    public void minScore(final StatisticKey key, final int value, final Callback<Boolean> updatedCallback) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        final int month = this.stats.getCurrentMonthKey();
        final int daykey = this.stats.getCurrentDayKey();
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    final boolean result = database.minScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month, daykey, value);
                    if (updatedCallback != null) {
                        PlayerStatisticsImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)PlayerStatisticsImplementation.this.stats.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                updatedCallback.call(result);
                            }
                        });
                    }
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not set score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    @Override
    public void getScore(StatisticKey key, TimeFrame timeFrame, Callback<Integer> scoreCallback) {
        this.getScoreInMonth(key, this.getMonthKey(timeFrame), scoreCallback);
    }

    @Override
    public void getPosition(StatisticKey key, TimeFrame timeFrame, Callback<Integer> positionCallback) {
        this.getPositionInMonth(key, this.getMonthKey(timeFrame), positionCallback);
    }

    private int getMonthKey(TimeFrame timeFrame) {
        int month = -1;
        if (timeFrame == TimeFrame.MONTH) {
            month = this.stats.getCurrentMonthKey();
        } else if (timeFrame == TimeFrame.DAY) {
            month = this.stats.getCurrentDayKey();
        }
        return month;
    }

    private void getScoreInMonth(final StatisticKey key, final int month, final Callback<Integer> scoreCallback) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        if (scoreCallback == null) {
            throw new NullPointerException("scoreCallback");
        }
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    final Integer score = database.getScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month);
                    PlayerStatisticsImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)PlayerStatisticsImplementation.this.stats.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            scoreCallback.call(score);
                        }
                    });
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not get score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    private void getPositionInMonth(final StatisticKey key, final int month, final Callback<Integer> scoreCallback) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        if (scoreCallback == null) {
            throw new NullPointerException("scoreCallback");
        }
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    final Integer score = database.getScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month);
                    PlayerStatisticsImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)PlayerStatisticsImplementation.this.stats.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            scoreCallback.call(score);
                        }
                    });
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not get score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    @Override
    public void grantAchivement(AchivementKey key) {
        this.grantAchivement(key, 1, null);
    }

    @Override
    public void grantAchivement(AchivementKey key, Callback<Integer> updatedCallback) {
        this.grantAchivement(key, 1, updatedCallback);
    }

    @Override
    public void grantAchivement(AchivementKey key, int level) {
        this.grantAchivement(key, level, null);
    }

    @Override
    public void grantAchivement(final AchivementKey key, final int level, final Callback<Integer> updatedCallback) {
        if (!(key instanceof AchivementKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        if (level < 1 || level > key.getMaxLevel()) {
            throw new IllegalArgumentException("level");
        }
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    final Integer oldLevel = database.maxAchivementLevel(PlayerStatisticsImplementation.this.databaseId, (AchivementKeyImplementation)key, level, updatedCallback != null);
                    if (updatedCallback != null && (oldLevel == null || level != oldLevel)) {
                        PlayerStatisticsImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)PlayerStatisticsImplementation.this.stats.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                updatedCallback.call(oldLevel);
                            }
                        });
                    }
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not grant achivement " + key.getName() + " for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    @Override
    public void revokeAchivement(AchivementKey key) {
        this.revokeAchivement(key, null);
    }

    @Override
    public void revokeAchivement(final AchivementKey key, final Callback<Integer> updatedCallback) {
        if (!(key instanceof AchivementKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    final Integer oldLevel = database.setAchivementLevel(PlayerStatisticsImplementation.this.databaseId, (AchivementKeyImplementation)key, 0, updatedCallback != null);
                    if (updatedCallback != null && oldLevel != null && oldLevel > 0) {
                        PlayerStatisticsImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)PlayerStatisticsImplementation.this.stats.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                updatedCallback.call(oldLevel);
                            }
                        });
                    }
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not revoke achivement " + key.getName() + " for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    @Override
    public void hasAchivement(final AchivementKey key, final Callback<Boolean> achivementCallback) {
        if (!(key instanceof AchivementKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        if (achivementCallback == null) {
            throw new NullPointerException("achivementCallback");
        }
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    final Integer level = database.getAchivementLevel(PlayerStatisticsImplementation.this.databaseId, (AchivementKeyImplementation)key);
                    PlayerStatisticsImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)PlayerStatisticsImplementation.this.stats.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            achivementCallback.call(level > 0);
                        }
                    });
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not get achivement " + key.getName() + " for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    @Override
    public void getAchivementLevel(final AchivementKey key, final Callback<Integer> achivementCallback) {
        if (!(key instanceof AchivementKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        if (achivementCallback == null) {
            throw new NullPointerException("achivementCallback");
        }
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    final Integer level = database.getAchivementLevel(PlayerStatisticsImplementation.this.databaseId, (AchivementKeyImplementation)key);
                    PlayerStatisticsImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)PlayerStatisticsImplementation.this.stats.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            achivementCallback.call(level);
                        }
                    });
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not get achivement " + key.getName() + " for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    public boolean areSettingsLoaded() {
        return this.settingsLoaded;
    }

    public Integer getSettingValueIfLoaded(SettingKey setting) {
        return this.settings.get(setting);
    }

    public int getSettingValueOrDefault(SettingKey setting) {
        Integer value = this.getSettingValueIfLoaded(setting);
        return value != null ? value.intValue() : setting.getDefault();
    }

    public void setSettingValue(final SettingKey key, final int value) {
        if (!(key instanceof SettingKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        this.settings.put((SettingKeyImplementation)key, value);
        if (!this.settingsLoaded) {
            if (this.doNotLoadSettings == null) {
                this.doNotLoadSettings = new HashSet();
            }
            this.doNotLoadSettings.add((SettingKeyImplementation)key);
        }
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    database.setSettingValue(PlayerStatisticsImplementation.this.databaseId, (SettingKeyImplementation)key, value, false);
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not set setting value for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }
}

