/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import de.iani.cubesidestats.CubesideStatistics;
import de.iani.cubesidestats.PlayerListener;
import de.iani.cubesidestats.PlayerStatisticsImplementation;
import de.iani.cubesidestats.SQLConfig;
import de.iani.cubesidestats.StatisticsDatabase;
import de.iani.cubesidestats.api.AchivementKey;
import de.iani.cubesidestats.api.CubesideStatisticsAPI;
import de.iani.cubesidestats.api.PlayerStatistics;
import de.iani.cubesidestats.api.StatisticKey;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class CubesideStatisticsImplementation
implements CubesideStatisticsAPI {
    private HashMap<UUID, PlayerStatisticsImplementation> onlinePlayers;
    private StatisticsDatabase database;
    private CubesideStatistics plugin;
    private WorkerThread workerThread;

    public CubesideStatisticsImplementation(CubesideStatistics plugin) throws SQLException {
        this.plugin = plugin;
        this.database = new StatisticsDatabase(plugin, new SQLConfig(plugin.getConfig().getConfigurationSection("database")));
        this.onlinePlayers = new HashMap();
        plugin.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)plugin);
        this.workerThread = new WorkerThread();
        this.workerThread.start();
    }

    public void shutdown() {
        if (this.workerThread != null) {
            this.workerThread.shutdown();
        }
    }

    public WorkerThread getWorkerThread() {
        return this.workerThread;
    }

    public CubesideStatistics getPlugin() {
        return this.plugin;
    }

    @Override
    public PlayerStatistics getStatistics(UUID owner) {
        return null;
    }

    @Override
    public StatisticKey getStatisticKey(String id) {
        return null;
    }

    @Override
    public boolean hasStatisticKey(String id) {
        return false;
    }

    @Override
    public AchivementKey getAchivementKey(String id) {
        return null;
    }

    @Override
    public boolean hasAchivementKey(String id) {
        return false;
    }

    public void playerJoined(Player player) {
        this.onlinePlayers.put(player.getUniqueId(), new PlayerStatisticsImplementation(this, player.getUniqueId()));
    }

    public static interface WorkEntry {
        public void process(StatisticsDatabase var1);
    }

    public class WorkerThread
    extends Thread {
        private StatisticsDatabase database;
        private boolean stopping;
        private ArrayDeque<WorkEntry> work = new ArrayDeque();

        public WorkerThread() {
            this.database = CubesideStatisticsImplementation.this.database;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addWork(WorkEntry e) {
            ArrayDeque<WorkEntry> arrayDeque = this.work;
            synchronized (arrayDeque) {
                this.work.addLast(e);
                this.work.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            ArrayDeque<WorkEntry> arrayDeque = this.work;
            synchronized (arrayDeque) {
                this.stopping = true;
                this.work.notify();
            }
            boolean interrupt = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    interrupt = true;
                }
            }
            if (interrupt) {
                Thread.currentThread().interrupt();
            }
            if (this.database != null) {
                this.database.disconnect();
                this.database = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                WorkEntry e;
                ArrayDeque<WorkEntry> arrayDeque = this.work;
                synchronized (arrayDeque) {
                    e = this.work.pollFirst();
                    if (e == null) {
                        if (this.stopping) {
                            return;
                        }
                        try {
                            this.work.wait();
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                if (e == null || this.database == null) continue;
                try {
                    e.process(this.database);
                    continue;
                }
                catch (Exception er) {
                    CubesideStatisticsImplementation.this.plugin.getLogger().log(Level.SEVERE, "Error in Statistics", er);
                    continue;
                }
                break;
            }
        }
    }
}

