/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import de.iani.cubesidestats.Callback;
import de.iani.cubesidestats.CubesideStatisticsImplementation;
import de.iani.cubesidestats.StatisticsDatabase;
import de.iani.cubesidestats.api.AchivementKey;
import de.iani.cubesidestats.api.PlayerStatistics;
import de.iani.cubesidestats.api.StatisticKey;
import java.sql.SQLException;
import java.util.UUID;
import java.util.logging.Level;

public class PlayerStatisticsImplementation
implements PlayerStatistics {
    private final UUID playerId;
    private int databaseId;

    public PlayerStatisticsImplementation(final CubesideStatisticsImplementation stats, final UUID player) {
        this.playerId = player;
        this.databaseId = -1;
        stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    PlayerStatisticsImplementation.this.databaseId = database.getOrCreatePlayerId(player);
                }
                catch (SQLException e) {
                    stats.getPlugin().getLogger().log(Level.SEVERE, "Could not load database id for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    @Override
    public UUID getOwner() {
        return this.playerId;
    }

    @Override
    public void increaseScore(StatisticKey key, int amount) {
    }

    @Override
    public void decreaseScore(StatisticKey key, int amount) {
    }

    @Override
    public void setScore(StatisticKey key, int value) {
    }

    @Override
    public void getScore(StatisticKey key, Callback<Integer> scoreCallback) {
    }

    @Override
    public void getPosition(StatisticKey key, Callback<Integer> positionCallback) {
    }

    @Override
    public void getScoreThisMonth(StatisticKey key, Callback<Integer> scoreCallback) {
    }

    @Override
    public void getPositionThisMonth(StatisticKey key, Callback<Integer> positionCallback) {
    }

    @Override
    public void grantAchivement(AchivementKey key) {
    }

    @Override
    public void revokeAchivement(AchivementKey key) {
    }

    @Override
    public void hasAchivement(AchivementKey key, Callback<Boolean> achivementCallback) {
    }
}

