/*
 * Decompiled with CFR 0.152.
 */
package de.iani.settings.libs.de.iani.cubesideutils.commands;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArgsParser
implements Iterable<String>,
Iterator<String> {
    private String[] args;
    private int current;

    public ArgsParser(String[] args) {
        this.args = args;
        this.current = -1;
    }

    public ArgsParser(String[] args, int skipParts) {
        this.args = args;
        this.current = -1 + skipParts;
    }

    @Override
    public boolean hasNext() {
        return this.current < this.args.length - 1;
    }

    public int remaining() {
        return Math.max(this.args.length - 1 - this.current, 0);
    }

    public String getAll(String def) {
        ++this.current;
        if (this.args.length <= this.current) {
            return def;
        }
        StringBuilder sb = new StringBuilder();
        while (this.args.length > this.current) {
            sb.append(this.args[this.current]);
            sb.append(' ');
            ++this.current;
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String seeNext(String def) {
        if (this.args.length <= this.current + 1) {
            return def;
        }
        return this.args[this.current + 1];
    }

    public String getNext(String def) {
        ++this.current;
        if (this.args.length <= this.current) {
            return def;
        }
        return this.args[this.current];
    }

    @Override
    public String next() {
        return this.getNext();
    }

    public String getNext() {
        String res = this.getNext(null);
        if (res == null) {
            throw new NoSuchElementException();
        }
        return res;
    }

    public int getNext(int def) {
        String next = this.getNext(null);
        if (next == null) {
            return def;
        }
        try {
            return Integer.parseInt(next);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public double getNext(double def) {
        String next = this.getNext(null);
        if (next == null) {
            return def;
        }
        try {
            return Double.parseDouble(next);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public Boolean getNext(boolean ignored) {
        String next = this.getNext(null);
        if (next == null) {
            return null;
        }
        if (next.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (next.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public <T extends Enum<T>> T getNextEnum(Class<T> enumClass, T def) {
        if (!this.hasNext()) {
            return def;
        }
        Method matcher = null;
        boolean priority = false;
        for (Method method : enumClass.getMethods()) {
            if (method.isAnnotationPresent(ArgMatcher.class) && this.isLegalMatcherMethod(enumClass, method)) {
                matcher = method;
                break;
            }
            if (priority || !method.getName().equals("match") && !method.getName().equals("parse") || !this.isLegalMatcherMethod(enumClass, method)) continue;
            matcher = method;
            priority = method.getName().equals("parse");
        }
        try {
            if (matcher != null) {
                try {
                    return (T)((Enum)matcher.invoke(null, this.next()));
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    if (e.getCause() instanceof Error) {
                        throw (Error)e.getCause();
                    }
                    throw new AssertionError((Object)e.getCause());
                }
            }
            String arg = this.next();
            try {
                return (T)((Enum)enumClass.getMethod("valueOf", String.class).invoke(null, arg.toUpperCase()));
            }
            catch (InvocationTargetException e) {
                if (!(e.getCause() instanceof IllegalArgumentException)) {
                    if (e.getCause() instanceof Error) {
                        throw (Error)e.getCause();
                    }
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    throw new AssertionError((Object)e.getCause());
                }
                try {
                    Enum[] types;
                    for (Enum t : types = (Enum[])enumClass.getMethod("values", new Class[0]).invoke(null, new Object[0])) {
                        if (!t.name().equalsIgnoreCase(arg)) continue;
                        return (T)t;
                    }
                    for (Enum t : types) {
                        if (!t.toString().equalsIgnoreCase(arg)) continue;
                        return (T)t;
                    }
                }
                catch (InvocationTargetException e2) {
                    if (e2.getCause() instanceof Error) {
                        throw (Error)e2.getCause();
                    }
                    if (e2.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e2.getCause();
                    }
                    throw new AssertionError((Object)e2.getCause());
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        return null;
    }

    private <T extends Enum<T>> boolean isLegalMatcherMethod(Class<T> enumClass, Method method) {
        if ((method.getModifiers() & 8) == 0) {
            return false;
        }
        if (!enumClass.isAssignableFrom(method.getReturnType())) {
            return false;
        }
        if (!Arrays.equals(method.getParameterTypes(), new Class[]{String.class})) {
            return false;
        }
        return !Arrays.stream(method.getExceptionTypes()).anyMatch(type -> !RuntimeException.class.isAssignableFrom((Class<?>)type) && !Error.class.isAssignableFrom((Class<?>)type));
    }

    public long getNextTimespan() throws NumberFormatException, ParseException {
        String string = this.getNext();
        string = string.toLowerCase();
        long res = 0L;
        if (string.endsWith("s")) {
            res += (long)(Integer.parseInt(string.substring(0, string.length() - 1)) * 1000);
        } else if (string.endsWith("m")) {
            res += (long)(Integer.parseInt(string.substring(0, string.length() - 1)) * 1000 * 60);
        } else if (string.endsWith("h")) {
            res += (long)(Integer.parseInt(string.substring(0, string.length() - 1)) * 1000 * 60 * 60);
        } else if (string.endsWith("d")) {
            res += (long)(Integer.parseInt(string.substring(0, string.length() - 1)) * 1000 * 60 * 60 * 24);
        } else {
            throw new ParseException("String doesn't end with s, m h or d", string.length() - 1);
        }
        return res;
    }

    public long getAllTimespan() throws NumberFormatException, ParseException {
        long res = 0L;
        while (this.hasNext()) {
            res += this.getNextTimespan();
        }
        return res;
    }

    @Override
    public Iterator<String> iterator() {
        return this.clone();
    }

    public ArgsParser clone() {
        ArgsParser result = new ArgsParser(this.args);
        result.current = this.current;
        return result;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface ArgMatcher {
    }
}

