/*
 * Decompiled with CFR 0.152.
 */
package de.iani.settings.libs.de.iani.cubesideutils.collections;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;

public class GeneralHashMap<K, V>
extends AbstractMap<K, V>
implements Cloneable {
    public static final ToIntFunction<Object> DEFAULT_HASHER = Objects::hashCode;
    public static final BiPredicate<Object, Object> DEFAULT_EQUALITY = Objects::equals;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final ToIntFunction<? super K> hasher;
    private final BiPredicate<? super K, ? super K> equality;
    int elementCount;
    Entry[] elementData;
    int modCount = 0;
    private final float loadFactor;
    int threshold;
    Set<Map.Entry<K, V>> entrySet;
    Set<K> keySet;
    Collection<V> values;

    public static <T> ToIntFunction<T> createNullResistantHasher(ToIntFunction<T> original) {
        return x -> x == null ? 0 : original.applyAsInt(x);
    }

    public static <T> ToIntFunction<Object> createTypeResistantHasher(ToIntFunction<? super T> original, Class<T> type) {
        return x -> {
            if (x != null && !type.isInstance(x)) {
                return original.applyAsInt(x);
            }
            return 0;
        };
    }

    public static <T> ToIntFunction<Object> createResistantHasher(ToIntFunction<? super T> original, Class<T> type) {
        return x -> {
            if (x == null) {
                return 0;
            }
            return type.isInstance(x) ? original.applyAsInt(x) : 0;
        };
    }

    private static final int calculateCapacity(int x) {
        if (x >= 0x40000000) {
            return 0x40000000;
        }
        if (x == 0) {
            return 16;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    public GeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality, int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        initialCapacity = GeneralHashMap.calculateCapacity(initialCapacity);
        this.elementData = this.newElementArray(initialCapacity);
        this.loadFactor = loadFactor;
        this.elementCount = 0;
        this.computeThreshold();
        this.hasher = Objects.requireNonNull(hasher);
        this.equality = Objects.requireNonNull(equality);
    }

    public GeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality, int initialCapacity) {
        this(hasher, equality, initialCapacity, 0.75f);
    }

    public GeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality) {
        this(hasher, equality, 16, 0.75f);
    }

    public GeneralHashMap(ToIntFunction<? super K> hasher, BiPredicate<? super K, ? super K> equality, Map<? extends K, ? extends V> copyOf) {
        this(hasher, equality, 16, 0.75f);
        super.putAllImpl(copyOf);
    }

    Entry[] newElementArray(int s) {
        return new Entry[s];
    }

    @Override
    public void clear() {
        if (this.elementCount > 0) {
            this.elementCount = 0;
            Arrays.fill(this.elementData, null);
            ++this.modCount;
        }
    }

    @Override
    public Object clone() {
        try {
            GeneralHashMap map = (GeneralHashMap)super.clone();
            map.elementCount = 0;
            map.elementData = this.newElementArray(this.elementData.length);
            map.putAll(this);
            return map;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private void computeThreshold() {
        this.threshold = (int)((float)this.elementData.length * this.loadFactor);
    }

    @Override
    public boolean containsKey(Object key) {
        Entry m = this.getEntry(key);
        return m != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value != null) {
            for (int i = 0; i < this.elementData.length; ++i) {
                Entry entry = this.elementData[i];
                while (entry != null) {
                    if (this.areEqualValues(value, entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            for (int i = 0; i < this.elementData.length; ++i) {
                Entry entry = this.elementData[i];
                while (entry != null) {
                    if (entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public V get(Object key) {
        Entry m = this.getEntry(key);
        if (m != null) {
            return m.value;
        }
        return null;
    }

    final Entry getEntry(Object key) {
        int hash = this.computeHashCode(key);
        int index = hash & this.elementData.length - 1;
        Entry m = this.findEntry(key, index, hash);
        return m;
    }

    final Entry findEntry(Object key, int index, int keyHash) {
        Entry m = this.elementData[index];
        while (!(m == null || m.origKeyHash == keyHash && this.areEqualKeys(key, m.key))) {
            m = m.next;
        }
        return m;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return GeneralHashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return GeneralHashMap.this.size();
                }

                @Override
                public void clear() {
                    GeneralHashMap.this.clear();
                }

                @Override
                public boolean remove(Object key) {
                    Entry entry = GeneralHashMap.this.removeEntry(key);
                    return entry != null;
                }

                @Override
                public Iterator<K> iterator() {
                    return new KeyIterator();
                }
            };
        }
        return this.keySet;
    }

    @Override
    public V put(K key, V value) {
        return this.putImpl(key, value);
    }

    V putImpl(K key, V value) {
        int hash = this.computeHashCode(key);
        int index = hash & this.elementData.length - 1;
        Entry entry = this.findEntry(key, index, hash);
        if (entry == null) {
            ++this.modCount;
            entry = this.createHashedEntry(key, index, hash);
            if (++this.elementCount > this.threshold) {
                this.rehash();
            }
        }
        Object result = entry.value;
        entry.value = value;
        return result;
    }

    Entry createEntry(K key, int index, V value) {
        Entry entry = new Entry(key, value);
        entry.next = this.elementData[index];
        this.elementData[index] = entry;
        return entry;
    }

    Entry createHashedEntry(K key, int index, int hash) {
        Entry entry = new Entry(key, hash);
        entry.next = this.elementData[index];
        this.elementData[index] = entry;
        return entry;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (!map.isEmpty()) {
            this.putAllImpl(map);
        }
    }

    private void putAllImpl(Map<? extends K, ? extends V> map) {
        int capacity = this.elementCount + map.size();
        if (capacity > this.threshold) {
            this.rehash(capacity);
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.putImpl(entry.getKey(), entry.getValue());
        }
    }

    void rehash(int capacity) {
        int length = GeneralHashMap.calculateCapacity(capacity == 0 ? 1 : capacity << 1);
        Entry[] newData = this.newElementArray(length);
        for (int i = 0; i < this.elementData.length; ++i) {
            Entry entry = this.elementData[i];
            this.elementData[i] = null;
            while (entry != null) {
                int index = entry.origKeyHash & length - 1;
                Entry next = entry.next;
                entry.next = newData[index];
                newData[index] = entry;
                entry = next;
            }
        }
        this.elementData = newData;
        this.computeThreshold();
    }

    void rehash() {
        this.rehash(this.elementData.length);
    }

    @Override
    public V remove(Object key) {
        Entry entry = this.removeEntry(key);
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    final void removeEntry(Entry entry) {
        int index = entry.origKeyHash & this.elementData.length - 1;
        Entry m = this.elementData[index];
        if (m == entry) {
            this.elementData[index] = entry.next;
        } else {
            while (m.next != entry) {
                m = m.next;
            }
            m.next = entry.next;
        }
        ++this.modCount;
        --this.elementCount;
    }

    final Entry removeEntry(Object key) {
        Entry entry;
        int index = 0;
        Entry last = null;
        if (key != null) {
            int hash = this.computeHashCode(key);
            index = hash & this.elementData.length - 1;
            entry = this.elementData[index];
            while (!(entry == null || entry.origKeyHash == hash && this.areEqualKeys(key, entry.key))) {
                last = entry;
                entry = entry.next;
            }
        } else {
            entry = this.elementData[0];
            while (entry != null && entry.key != null) {
                last = entry;
                entry = entry.next;
            }
        }
        if (entry == null) {
            return null;
        }
        if (last == null) {
            this.elementData[index] = entry.next;
        } else {
            last.next = entry.next;
        }
        ++this.modCount;
        --this.elementCount;
        return entry;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return GeneralHashMap.this.containsValue(object);
                }

                @Override
                public int size() {
                    return GeneralHashMap.this.size();
                }

                @Override
                public void clear() {
                    GeneralHashMap.this.clear();
                }

                @Override
                public Iterator<V> iterator() {
                    return new ValueIterator();
                }
            };
        }
        return this.values;
    }

    int computeHashCode(Object key) {
        try {
            int h = this.hasher.applyAsInt(key);
            return h ^ h >>> 16;
        }
        catch (ClassCastException e) {
            return 0;
        }
    }

    private boolean areEqualKeys(Object key1, Object key2) {
        try {
            return this.equality.test(key1, key2);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private boolean areEqualValues(Object value1, Object value2) {
        return Objects.equals(value1, value2);
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public int size() {
            return GeneralHashMap.this.elementCount;
        }

        @Override
        public void clear() {
            GeneralHashMap.this.clear();
        }

        @Override
        public boolean remove(Object object) {
            Map.Entry oEntry;
            Entry entry;
            if (object instanceof Map.Entry && this.valuesEq(entry = GeneralHashMap.this.getEntry((oEntry = (Map.Entry)object).getKey()), oEntry)) {
                GeneralHashMap.this.removeEntry(entry);
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry oEntry = (Map.Entry)object;
                Entry entry = GeneralHashMap.this.getEntry(oEntry.getKey());
                return this.valuesEq(entry, oEntry);
            }
            return false;
        }

        private boolean valuesEq(Entry entry, Map.Entry<?, ?> oEntry) {
            return entry != null && (entry.value == null ? oEntry.getValue() == null : GeneralHashMap.this.areEqualValues(entry.value, oEntry.getValue()));
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }
    }

    private class ValueIterator
    extends AbstractMapIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            this.makeNext();
            return this.currentEntry.value;
        }
    }

    private class KeyIterator
    extends AbstractMapIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            this.makeNext();
            return this.currentEntry.key;
        }
    }

    private class EntryIterator
    extends AbstractMapIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            this.makeNext();
            return this.currentEntry;
        }
    }

    private class AbstractMapIterator {
        private int position = 0;
        int expectedModCount;
        Entry futureEntry;
        Entry currentEntry;
        Entry prevEntry;

        AbstractMapIterator() {
            this.expectedModCount = GeneralHashMap.this.modCount;
            this.futureEntry = null;
        }

        public boolean hasNext() {
            if (this.futureEntry != null) {
                return true;
            }
            while (this.position < GeneralHashMap.this.elementData.length) {
                if (GeneralHashMap.this.elementData[this.position] == null) {
                    ++this.position;
                    continue;
                }
                return true;
            }
            return false;
        }

        final void checkConcurrentMod() throws ConcurrentModificationException {
            if (this.expectedModCount != GeneralHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        final void makeNext() {
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.futureEntry == null) {
                this.currentEntry = GeneralHashMap.this.elementData[this.position++];
                this.futureEntry = this.currentEntry.next;
                this.prevEntry = null;
            } else {
                if (this.currentEntry != null) {
                    this.prevEntry = this.currentEntry;
                }
                this.currentEntry = this.futureEntry;
                this.futureEntry = this.futureEntry.next;
            }
        }

        public final void remove() {
            this.checkConcurrentMod();
            if (this.currentEntry == null) {
                throw new IllegalStateException();
            }
            if (this.prevEntry == null) {
                int index = this.currentEntry.origKeyHash & GeneralHashMap.this.elementData.length - 1;
                GeneralHashMap.this.elementData[index] = GeneralHashMap.this.elementData[index].next;
            } else {
                this.prevEntry.next = this.currentEntry.next;
            }
            this.currentEntry = null;
            ++this.expectedModCount;
            ++GeneralHashMap.this.modCount;
            --GeneralHashMap.this.elementCount;
        }
    }

    class Entry
    implements Map.Entry<K, V>,
    Cloneable {
        final K key;
        V value;
        final int origKeyHash;
        Entry next;

        Entry(K theKey, int hash) {
            this.origKeyHash = hash;
            this.key = theKey;
            this.value = null;
            this.next = null;
        }

        Entry(K theKey, V theValue) {
            this.origKeyHash = theKey == null ? 0 : GeneralHashMap.this.computeHashCode(theKey);
            this.key = theKey;
            this.value = theValue;
            this.next = null;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return GeneralHashMap.this.computeHashCode(this.key) ^ Objects.hashCode(this.value);
        }

        @Override
        public final V setValue(V newValue) {
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Map.Entry e;
            if (o == this) {
                return true;
            }
            return o instanceof Map.Entry && GeneralHashMap.this.areEqualKeys(this.key, (e = (Map.Entry)o).getKey()) && GeneralHashMap.this.areEqualValues(this.value, e.getValue());
        }

        public Object clone() {
            Entry entry;
            try {
                entry = (Entry)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
            if (this.next != null) {
                entry.next = (Entry)this.next.clone();
            }
            return entry;
        }
    }
}

