/*
 * Decompiled with CFR 0.152.
 */
package de.iani.settings;

import de.iani.settings.CommandRouter;
import de.iani.settings.CubesideSettingsAPI;
import de.iani.settings.PlayerListener;
import de.iani.settings.PlayerListener19;
import de.iani.settings.PlayerSettings;
import de.iani.settings.PluginConfig;
import de.iani.settings.SettingsDatabase;
import de.iani.settings.commands.AddAliasCommand;
import de.iani.settings.commands.ListAliasesCommand;
import de.iani.settings.commands.RemoveAliasCommand;
import de.iani.settings.commands.SettingsCommand;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.Dye;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class CubesideSettings
extends JavaPlugin
implements CubesideSettingsAPI {
    private PluginConfig pluginConfig;
    private SettingsDatabase settingsDatabase;
    private ItemStack settingsItem;
    private ConcurrentHashMap<UUID, PlayerSettings> playerSettings;
    private int minecraftMajorVersion = -1;
    private int minecraftMinorVersion = -1;
    private int minecraftReleaseVersion = -1;

    public void onEnable() {
        this.parseMinecraftVersion();
        this.saveDefaultConfig();
        this.playerSettings = new ConcurrentHashMap();
        this.pluginConfig = new PluginConfig(this.getConfig());
        try {
            this.settingsDatabase = new SettingsDatabase(this, this.pluginConfig.getDatabaseConfig());
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not connect to database", e);
        }
        this.settingsItem = new ItemStack(Material.DIODE, 1);
        ItemMeta meta = this.settingsItem.getItemMeta();
        meta.setDisplayName(ChatColor.BLUE.toString() + "Einstellungen");
        this.settingsItem.setItemMeta(meta);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        if (this.getMinecraftMajorVersion() > 1 || this.getMinecraftMajorVersion() == 1 && this.getMinecraftMinorVersion() > 8) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener19(this), (Plugin)this);
        }
        this.getServer().getServicesManager().register(CubesideSettingsAPI.class, (Object)this, (Plugin)this, ServicePriority.Normal);
        CommandRouter commandRouter = new CommandRouter(this.getCommand("settings"));
        commandRouter.addCommandMapping(new SettingsCommand(this), new String[0]);
        commandRouter.addCommandMapping(new AddAliasCommand(this), "addhighlight");
        commandRouter.addCommandMapping(new RemoveAliasCommand(this), "removehighlight");
        commandRouter.addCommandMapping(new ListAliasesCommand(this), "listhighlights");
    }

    private void parseMinecraftVersion() {
        try {
            int mcEnd;
            String version = this.getServer().getVersion();
            int mcStart = version.indexOf("(MC: ");
            if (mcStart >= 0) {
                version = version.substring(mcStart + 5);
            }
            if ((mcEnd = version.indexOf(")")) >= 0) {
                version = version.substring(0, mcEnd);
            }
            String[] parts = version.split("\\.");
            this.minecraftMajorVersion = Integer.parseInt(parts[0]);
            this.minecraftMinorVersion = 0;
            this.minecraftReleaseVersion = 0;
            this.minecraftMinorVersion = Integer.parseInt(parts[1]);
            if (parts.length > 2) {
                this.minecraftReleaseVersion = Integer.parseInt(parts[2]);
            }
            this.getLogger().info("Detected Minecraft Version: " + this.minecraftMajorVersion + "." + this.minecraftMinorVersion + "." + this.minecraftReleaseVersion);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Could not parse version", e);
        }
    }

    public int getMinecraftMajorVersion() {
        return this.minecraftMajorVersion;
    }

    public int getMinecraftMinorVersion() {
        return this.minecraftMinorVersion;
    }

    public int getMinecraftReleaseVersion() {
        return this.minecraftReleaseVersion;
    }

    public ItemStack getSettingsItem() {
        return this.settingsItem;
    }

    public String getSettingsInventoryTitle() {
        return ChatColor.BOLD + "Einstellungen";
    }

    public String getSettingsChatInventoryTitle() {
        return ChatColor.BOLD + "Einstellungen - Chat";
    }

    public String getSettingsSoundsInventoryTitle() {
        return ChatColor.BOLD + "Einstellungen - Sounds";
    }

    private Inventory createBaseInventory(Player p, int rows, String title, ItemStack backItem) {
        int i;
        Inventory inv = Bukkit.createInventory(null, (int)((rows + 2) * 9), (String)title);
        ItemStack frameSlot = this.createItemStack(Material.STAINED_GLASS_PANE, (short)3, ChatColor.BOLD.toString(), new String[0]);
        for (i = 0; i < 9; ++i) {
            if (i == 0 && backItem != null) {
                inv.setItem(i, backItem);
            } else {
                inv.setItem(i, frameSlot);
            }
            inv.setItem(i + (rows + 1) * 9, frameSlot);
        }
        for (i = 1; i < rows + 1; ++i) {
            inv.setItem(0 + i * 9, frameSlot);
            inv.setItem(8 + i * 9, frameSlot);
        }
        return inv;
    }

    public void openSettingsInventoryOnPlayer(Player p) {
        int rows = 3;
        Inventory inv = this.createBaseInventory(p, rows, this.getSettingsInventoryTitle(), null);
        ItemStack stack = this.createItemStack(Material.PAPER, ChatColor.GREEN.toString() + ChatColor.BOLD + "Chateinstellungen", new String[0]);
        inv.setItem(20, stack);
        stack = this.createItemStack(Material.NOTE_BLOCK, ChatColor.GREEN.toString() + ChatColor.BOLD + "Soundeinstellungen", new String[0]);
        inv.setItem(22, stack);
        p.openInventory(inv);
    }

    public void openChatSettingsInventoryOnPlayer(Player p) {
        int rows = 2;
        Inventory inv = this.createBaseInventory(p, rows, this.getSettingsChatInventoryTitle(), this.createItemStack(Material.BOOK, ChatColor.GREEN.toString() + ChatColor.BOLD + "zur\u00fcck zu den Einstellungen", new String[0]));
        PlayerSettings ps = this.getSettings(p);
        this.updateShowPublicChatItems(inv, ps);
        this.updateShowJoinQuitMessages(inv, ps);
        this.updateShowPrivateMessages(inv, ps);
        p.openInventory(inv);
    }

    public void openSoundsSettingsInventoryOnPlayer(Player p) {
        int rows = 2;
        Inventory inv = this.createBaseInventory(p, rows, this.getSettingsSoundsInventoryTitle(), this.createItemStack(Material.BOOK, ChatColor.GREEN.toString() + ChatColor.BOLD + "zur\u00fcck zu den Einstellungen", new String[0]));
        PlayerSettings ps = this.getSettings(p);
        this.updateSoundOnPrivateMessageItems(inv, ps);
        this.updateSoundOnReferenceMessages(inv, ps);
        p.openInventory(inv);
    }

    private void updateShowPublicChatItems(Inventory inv, PlayerSettings ps) {
        PlayerSettings.YesNoNotInGames pc = ps.getShowPublicChat();
        ItemStack stack = this.createItemStack(Material.PAPER, this.getYesNoNotInGamesToColor(pc) + ChatColor.BOLD + "\u00d6ffentlichen Chat anzeigen", this.getYesNoNotInGamesToColorAndText(pc), "", ChatColor.WHITE + "Klicken zum \u00c4ndern");
        ItemStack stack2 = this.setItemStack(this.getYesNoNotInGamesToDyeStack(pc), this.getYesNoNotInGamesToColor(pc) + ChatColor.BOLD + "\u00d6ffentlichen Chat anzeigen", this.getYesNoNotInGamesToColorAndText(pc), "", ChatColor.WHITE + "Klicken zum \u00c4ndern");
        inv.setItem(10, stack);
        inv.setItem(19, stack2);
    }

    private void updateShowJoinQuitMessages(Inventory inv, PlayerSettings ps) {
        PlayerSettings.YesNoNotInGames pc = ps.getShowJoinAndQuitMessages();
        ItemStack stack = this.createItemStack(Material.EYE_OF_ENDER, this.getYesNoNotInGamesToColor(pc) + ChatColor.BOLD + "Join/Quit-Nachrichten anzeigen", this.getYesNoNotInGamesToColorAndText(pc), "", ChatColor.WHITE + "Klicken zum \u00c4ndern");
        ItemStack stack2 = this.setItemStack(this.getYesNoNotInGamesToDyeStack(pc), this.getYesNoNotInGamesToColor(pc) + ChatColor.BOLD + "Join/Quit-Nachrichten anzeigen", this.getYesNoNotInGamesToColorAndText(pc), "", ChatColor.WHITE + "Klicken zum \u00c4ndern");
        inv.setItem(12, stack);
        inv.setItem(21, stack2);
    }

    private void updateShowPrivateMessages(Inventory inv, PlayerSettings ps) {
        PlayerSettings.YesNoNotInGames pc = PlayerSettings.YesNoNotInGames.valueOf(ps.getShowPrivateMessages());
        ItemStack stack = this.createItemStack(Material.MAP, this.getYesNoNotInGamesToColor(pc) + ChatColor.BOLD + "Private Nachrichten anzeigen", this.getYesNoNotInGamesToColorAndText(pc), "", ChatColor.WHITE + "Klicken zum \u00c4ndern");
        ItemStack stack2 = this.setItemStack(this.getYesNoNotInGamesToDyeStack(pc), this.getYesNoNotInGamesToColor(pc) + ChatColor.BOLD + "Private Nachrichten anzeigen", this.getYesNoNotInGamesToColorAndText(pc), "", ChatColor.WHITE + "Klicken zum \u00c4ndern");
        inv.setItem(14, stack);
        inv.setItem(23, stack2);
    }

    private void updateSoundOnPrivateMessageItems(Inventory inv, PlayerSettings ps) {
        PlayerSettings.YesNoNotInGames pc = ps.getSoundOnPrivateMessage();
        ItemStack stack = this.createItemStack(Material.MAP, this.getYesNoNotInGamesToColor(pc) + ChatColor.BOLD + "Sound bei privaten Nachrichten", this.getYesNoNotInGamesToColorAndText(pc), "", ChatColor.WHITE + "Klicken zum \u00c4ndern");
        ItemStack stack2 = this.setItemStack(this.getYesNoNotInGamesToDyeStack(pc), this.getYesNoNotInGamesToColor(pc) + ChatColor.BOLD + "Sound bei privaten Nachrichten", this.getYesNoNotInGamesToColorAndText(pc), "", ChatColor.WHITE + "Klicken zum \u00c4ndern");
        inv.setItem(10, stack);
        inv.setItem(19, stack2);
    }

    private void updateSoundOnReferenceMessages(Inventory inv, PlayerSettings ps) {
        PlayerSettings.YesNoNotInGames pc = ps.getSoundOnReference();
        ItemStack stack = this.createItemStack(Material.RAW_FISH, (short)3, this.getYesNoNotInGamesToColor(pc) + ChatColor.BOLD + "Sound bei Erw\u00e4hnung im Chat", this.getYesNoNotInGamesToColorAndText(pc), "", ChatColor.WHITE + "Klicken zum \u00c4ndern");
        ItemStack stack2 = this.setItemStack(this.getYesNoNotInGamesToDyeStack(pc), this.getYesNoNotInGamesToColor(pc) + ChatColor.BOLD + "Sound bei Erw\u00e4hnung im Chat", this.getYesNoNotInGamesToColorAndText(pc), "", ChatColor.WHITE + "Klicken zum \u00c4ndern");
        inv.setItem(12, stack);
        inv.setItem(21, stack2);
    }

    public String getYesNoNotInGamesToColor(PlayerSettings.YesNoNotInGames value) {
        return value == PlayerSettings.YesNoNotInGames.Yes ? ChatColor.GREEN.toString() : (value == PlayerSettings.YesNoNotInGames.No ? ChatColor.RED.toString() : ChatColor.YELLOW.toString());
    }

    public String getYesNoNotInGamesToColorAndText(PlayerSettings.YesNoNotInGames value) {
        return this.getYesNoNotInGamesToColor(value) + (value == PlayerSettings.YesNoNotInGames.Yes ? "Aktiv" : (value == PlayerSettings.YesNoNotInGames.No ? "Nicht aktiv" : "Nur ausserhalb von Spielrunden"));
    }

    public ItemStack getYesNoNotInGamesToDyeStack(PlayerSettings.YesNoNotInGames value) {
        DyeColor dc = value == PlayerSettings.YesNoNotInGames.Yes ? DyeColor.GREEN : (value == PlayerSettings.YesNoNotInGames.No ? DyeColor.RED : DyeColor.YELLOW);
        Dye dye = new Dye();
        dye.setColor(dc);
        return dye.toItemStack(1);
    }

    public PlayerSettings.YesNoNotInGames nextYesNoNotInGames(PlayerSettings.YesNoNotInGames old) {
        return PlayerSettings.YesNoNotInGames.valueOf((old.ordinal() + 1) % 3);
    }

    public ItemStack setItemStack(ItemStack stack, String name, String ... lore) {
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(Arrays.asList(lore));
        stack.setItemMeta(meta);
        return stack;
    }

    public ItemStack createItemStack(Material material, short data, String name, String ... lore) {
        ItemStack stack = new ItemStack(material, 1, data);
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(Arrays.asList(lore));
        stack.setItemMeta(meta);
        return stack;
    }

    public ItemStack createItemStack(Material material, String name, String ... lore) {
        ItemStack stack = new ItemStack(material, 1);
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(Arrays.asList(lore));
        stack.setItemMeta(meta);
        return stack;
    }

    public void checkForSettingsItem(Player p) {
        if (this.pluginConfig.getSettingsItemWorlds().contains(p.getWorld().getName())) {
            ItemStack compass = this.getSettingsItem();
            compass.setAmount(Integer.MAX_VALUE);
            p.getInventory().removeItem(new ItemStack[]{compass});
            if (!p.getInventory().containsAtLeast(compass, 1)) {
                compass.setAmount(1);
                if (this.pluginConfig.getSettingsItemSlot() >= 0) {
                    p.getInventory().setItem(this.pluginConfig.getSettingsItemSlot(), compass);
                } else {
                    p.getInventory().addItem(new ItemStack[]{compass});
                }
                p.updateInventory();
            }
        } else {
            ItemStack compass = this.getSettingsItem();
            compass.setAmount(Integer.MAX_VALUE);
            p.getInventory().removeItem(new ItemStack[]{compass});
        }
    }

    public SettingsDatabase getSettingsDatabase() {
        return this.settingsDatabase;
    }

    @Override
    public PlayerSettings getSettings(Player player) {
        return this.playerSettings.get(player.getUniqueId());
    }

    public void loadPlayerSettings(Player player) {
        try {
            this.playerSettings.put(player.getUniqueId(), this.settingsDatabase.getPlayerSettings(player.getUniqueId()));
        }
        catch (SQLException e) {
            this.getLogger().log(Level.SEVERE, "Could not load player settings for " + player.getName(), e);
            this.playerSettings.put(player.getUniqueId(), new PlayerSettings(this, player.getUniqueId()));
        }
    }

    public void removeLoadedPlayerSettings(Player player) {
        this.playerSettings.remove(player.getUniqueId());
    }

    public void handleSettingsInventoryClick(Inventory inventory, Player p, int slot) {
        if (slot == 20) {
            this.openChatSettingsInventoryOnPlayer(p);
        }
        if (slot == 22) {
            this.openSoundsSettingsInventoryOnPlayer(p);
        }
    }

    public void handleSettingsChatInventoryClick(Inventory inventory, Player p, int slot) {
        if (slot == 0) {
            this.openSettingsInventoryOnPlayer(p);
            return;
        }
        PlayerSettings ps = this.getSettings(p);
        if (slot == 10 || slot == 19) {
            ps.setShowPublicChat(this.nextYesNoNotInGames(ps.getShowPublicChat()));
            this.updateShowPublicChatItems(inventory, ps);
        }
        if (slot == 12 || slot == 21) {
            ps.setShowJoinAndQuitMessages(this.nextYesNoNotInGames(ps.getShowJoinAndQuitMessages()));
            this.updateShowJoinQuitMessages(inventory, ps);
        }
        if (slot == 14 || slot == 23) {
            ps.setShowPrivateMessages(!ps.getShowPrivateMessages());
            this.updateShowPrivateMessages(inventory, ps);
        }
    }

    public void handleSettingsSoundsInventoryClick(Inventory inventory, Player p, int slot) {
        if (slot == 0) {
            this.openSettingsInventoryOnPlayer(p);
            return;
        }
        PlayerSettings ps = this.getSettings(p);
        if (slot == 10 || slot == 19) {
            ps.setSoundOnPrivateMessage(this.nextYesNoNotInGames(ps.getSoundOnPrivateMessage()));
            this.updateSoundOnPrivateMessageItems(inventory, ps);
        }
        if (slot == 12 || slot == 21) {
            ps.setSoundOnReference(this.nextYesNoNotInGames(ps.getSoundOnReference()));
            this.updateSoundOnReferenceMessages(inventory, ps);
        }
    }
}

