/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.paper1_21_6;

import de.cubeside.nmsutils.MiscUtils;
import de.cubeside.nmsutils.NMSUtils;
import de.cubeside.nmsutils.paper1_21_6.NMSUtilsImpl;
import io.papermc.paper.adventure.PaperAdventure;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.numbers.BlankFormat;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftMagicNumbers;
import org.bukkit.scoreboard.Team;

public class MiscUtilsImpl
implements MiscUtils {
    private final NMSUtilsImpl nmsUtils;
    private Field fieldBlockBehaviour_properties;
    private MaterialMapColor transparentColor;
    private Field fieldBlockStateBase_materialColor;

    public MiscUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    @Override
    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    @Override
    public void setBlockMapColorTransparent(Material m) {
        if (this.fieldBlockBehaviour_properties == null) {
            Class<BlockBase.Info> classBlockProperties = BlockBase.Info.class;
            Class<BlockBase> classBlockBehaviour = BlockBase.class;
            this.fieldBlockBehaviour_properties = null;
            for (Field f : classBlockBehaviour.getDeclaredFields()) {
                if (f.getType() != classBlockProperties) continue;
                this.fieldBlockBehaviour_properties = f;
                this.fieldBlockBehaviour_properties.setAccessible(true);
            }
            if (this.fieldBlockBehaviour_properties == null) {
                throw new IllegalStateException("Could not find block properties field!");
            }
            Class<BlockBase.BlockData> classBlockStateBase = BlockBase.BlockData.class;
            for (Field f : classBlockStateBase.getDeclaredFields()) {
                if (f.getType() != MaterialMapColor.class) continue;
                this.fieldBlockStateBase_materialColor = f;
                this.fieldBlockStateBase_materialColor.setAccessible(true);
            }
            if (this.fieldBlockStateBase_materialColor == null) {
                throw new IllegalStateException("Could not find BlockStateBase materialColor field!");
            }
            try {
                Constructor constructorMaterialColor = MaterialMapColor.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE);
                constructorMaterialColor.setAccessible(true);
                this.transparentColor = (MaterialMapColor)constructorMaterialColor.newInstance(0, 0);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Could not create custom transparent MaterialColor!");
            }
        }
        if (!m.isBlock()) {
            throw new IllegalArgumentException("Material must be a block");
        }
        Block b2 = CraftMagicNumbers.getBlock((Material)m);
        try {
            BlockBase.Info properties = (BlockBase.Info)this.fieldBlockBehaviour_properties.get(b2);
            properties.a(this.transparentColor);
            for (IBlockData state : b2.l().a()) {
                this.fieldBlockStateBase_materialColor.set(state, this.transparentColor);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not set the MaterialColor!");
        }
    }

    @Override
    public Object createTeamParametersPacketObject(BaseComponent displayName, BaseComponent prefix, BaseComponent suffix, Team.OptionStatus nameTagDisplay, Team.OptionStatus collisionRule, ChatColor color, boolean seeFriendlyInvisibles, boolean allowFriendlyFire) {
        Scoreboard scoreboard = new Scoreboard();
        ScoreboardTeam team = new ScoreboardTeam(scoreboard, BaseComponent.toPlainText((BaseComponent[])new BaseComponent[]{displayName}));
        team.a(MiscUtilsImpl.baseComponentToComponent(displayName));
        team.b(MiscUtilsImpl.baseComponentToComponent(prefix));
        team.c(MiscUtilsImpl.baseComponentToComponent(suffix));
        team.a(ScoreboardTeamBase.EnumNameTagVisibility.values()[nameTagDisplay.ordinal()]);
        team.a(ScoreboardTeamBase.EnumTeamPush.values()[collisionRule.ordinal()]);
        team.a(color == null ? EnumChatFormat.v : CraftChatMessage.getColor((ChatColor)color));
        team.b(seeFriendlyInvisibles);
        team.a(allowFriendlyFire);
        return new PacketPlayOutScoreboardTeam.b(team);
    }

    private static IChatBaseComponent baseComponentToComponent(BaseComponent c2) {
        if (c2 == null) {
            return PaperAdventure.asVanilla((Component)Component.empty());
        }
        String json = ComponentSerializer.toString((BaseComponent)c2);
        return PaperAdventure.asVanilla((Component)GsonComponentSerializer.gson().deserialize((Object)json));
    }

    @Override
    public Class<? extends Object> getNumberFormatClass() {
        return NumberFormat.class;
    }

    @Override
    public Object getBlankNumberFormatInstance() {
        return BlankFormat.a;
    }
}

