/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils;

import de.cubeside.nmsutils.BiomeUtils;
import de.cubeside.nmsutils.EntityUtils;
import de.cubeside.nmsutils.MiscUtils;
import de.cubeside.nmsutils.WorldUtils;
import de.cubeside.nmsutils.nbt.NbtUtils;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public interface NMSUtils {
    public static final String CRAFTBUKKIT_PACKAGE = "org.bukkit.craftbukkit";

    public Plugin getPlugin();

    public EntityUtils getEntityUtils();

    public WorldUtils getWorldUtils();

    default public BiomeUtils getBiomeUtils() {
        throw new UnsupportedOperationException();
    }

    default public NbtUtils getNbtUtils() {
        throw new UnsupportedOperationException();
    }

    public MiscUtils getMiscUtils();

    public static NMSUtils createInstance(Plugin plugin) {
        String className2;
        String version = NMSUtils.getNmsVersion(plugin);
        try {
            NMSUtils result;
            className2 = NMSUtils.class.getPackage().getName() + "." + version + ".VersionedNMS";
            Class<?> versioningType = Class.forName(className2);
            if (VersionedNMS.class.isAssignableFrom(versioningType) && (result = ((VersionedNMS)versioningType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).createNMSUtils(plugin)) != null) {
                return result;
            }
        }
        catch (ClassNotFoundException className2) {
        }
        catch (ReflectiveOperationException ex) {
            NMSUtils.throwUnsupportedVersion(plugin, ex);
        }
        try {
            className2 = NMSUtils.class.getPackage().getName() + "." + version + ".NMSUtilsImpl";
            Class<?> numUtilsType = Class.forName(className2);
            if (NMSUtils.class.isAssignableFrom(numUtilsType)) {
                return (NMSUtils)numUtilsType.getDeclaredConstructor(Plugin.class).newInstance(plugin);
            }
        }
        catch (ClassNotFoundException ex) {
            NMSUtils.throwUnsupportedVersion(plugin);
        }
        catch (ReflectiveOperationException ex) {
            NMSUtils.throwUnsupportedVersion(plugin, ex);
        }
        NMSUtils.throwUnsupportedVersion(plugin);
        return null;
    }

    private static String getNmsVersion(Plugin plugin) {
        Server server = plugin.getServer();
        Class<?> serverClass = server.getClass();
        while (!serverClass.getPackage().getName().startsWith(CRAFTBUKKIT_PACKAGE)) {
            if ((serverClass = serverClass.getSuperclass()) != null) continue;
            NMSUtils.throwUnsupportedVersion(plugin);
        }
        String packageName = serverClass.getPackage().getName();
        int i = packageName.lastIndexOf(".");
        if (i == -1) {
            NMSUtils.throwUnsupportedVersion(plugin);
        }
        return packageName.substring(i + 1);
    }

    private static void throwUnsupportedVersion(Plugin plugin) {
        NMSUtils.throwUnsupportedVersion(plugin, null);
    }

    private static void throwUnsupportedVersion(Plugin plugin, Exception ex) {
        String msg = "Unsupported CraftBukkit version: " + plugin.getServer().getBukkitVersion();
        plugin.getLogger().severe(msg);
        throw new UnsupportedOperationException(msg, ex);
    }

    public static String getServerVersion() {
        String version = Bukkit.getServer().getVersion();
        int start = version.indexOf("(MC: ");
        if (start >= 0) {
            start += 5;
            int end = version.indexOf(")");
            if (end > 0) {
                return version.substring(start, end);
            }
        }
        throw new RuntimeException("Could not detect minecraft server version! Version is: " + version);
    }

    public static interface VersionedNMS {
        public NMSUtils createNMSUtils(Plugin var1) throws ReflectiveOperationException;
    }
}

