/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.nbt;

import com.google.common.base.Preconditions;
import de.cubeside.nmsutils.nbt.Tag;
import de.cubeside.nmsutils.nbt.TagType;
import java.util.Arrays;

public final class LongArrayTag
extends Tag {
    private long[] value;

    public LongArrayTag(long[] value) {
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    public long[] getValue() {
        return this.value;
    }

    public void setValue(long[] value) {
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    @Override
    public TagType getType() {
        return TagType.LONG_ARRAY;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof LongArrayTag)) return false;
        LongArrayTag o = (LongArrayTag)obj;
        if (!Arrays.equals(this.value, o.value)) return false;
        return true;
    }
}

