/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.v1_19_R3;

import com.destroystokyo.paper.entity.ai.VanillaGoal;
import de.cubeside.nmsutils.EntityUtils;
import de.cubeside.nmsutils.NMSUtils;
import de.cubeside.nmsutils.v1_19_R3.NMSUtilsImpl;
import de.cubeside.nmsutils.v1_19_R3.PathfinderGoalLimitedRandomStrollLand;
import java.io.Serializable;
import java.util.function.Function;
import java.util.logging.Level;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftBat;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftCamel;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftMob;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPiglin;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftRaider;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftShulker;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftVex;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftWolf;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Wolf;
import org.bukkit.util.Vector;

public class EntityUtilsImpl
implements EntityUtils {
    private final NMSUtilsImpl nmsUtils;

    public EntityUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    public void clearAI(Entity entity) {
        if (entity instanceof Mob) {
            this.nmsUtils.getPlugin().getServer().getMobGoals().removeAllGoals((Mob)entity);
        }
    }

    public void addGoalFloat(Mob mob) {
        if (!Bukkit.getMobGoals().hasGoal(mob, VanillaGoal.FLOAT)) {
            EntityInsentient h = ((CraftMob)mob).getHandle();
            h.bN.a(1, (PathfinderGoal)new PathfinderGoalFloat(h));
        }
    }

    public void addGoalLimitedStrollLand(Creature mob, double velocity, Function<Vector, Boolean> checkTargetFunction) {
        EntityCreature h = ((CraftCreature)mob).getHandle();
        h.bN.a(7, (PathfinderGoal)new PathfinderGoalLimitedRandomStrollLand(h, velocity, checkTargetFunction));
    }

    public int getShulkerOpenState(Entity shulker) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return 0;
            }
            CraftShulker cs = (CraftShulker)shulker;
            return cs.getHandle().fZ();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get shulker open state", e);
            return 0;
        }
    }

    public void setShulkerOpenState(Entity shulker, int state) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return;
            }
            state = Math.max(0, Math.min(127, state));
            CraftShulker cs = (CraftShulker)shulker;
            cs.getHandle().b(state);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set shulker open state", e);
        }
    }

    public boolean isPiglinDancing(Entity piglin) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return false;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            return cs.getHandle().ga();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get piglin dancing state", e);
            return false;
        }
    }

    public void setPiglinDancing(Entity piglin, boolean dancing) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            cs.getHandle().x(dancing);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set piglin dancing state", e);
        }
    }

    public void sendEntityPositionUpdate(Entity entity) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
        PlayerChunkMap.EntityTracker ete = handle.tracker;
        if (ete != null) {
            PacketPlayOutEntityTeleport positionPacket = new PacketPlayOutEntityTeleport(handle);
            ete.f.stream().forEach(viewer -> viewer.a((Packet)positionPacket));
        }
    }

    public void moveEntity(Entity e, double x, double y, double z) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.a(EnumMoveType.a, new Vec3D(x, y, z));
    }

    public void moveEntity(Entity e, Vector v) {
        this.moveEntity(e, v.getX(), v.getY(), v.getZ());
    }

    public void setEntityHeadRotation(Entity e, float headRotation) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        if (handle instanceof EntityLiving) {
            ((EntityLiving)handle).aV = headRotation;
        } else {
            handle.r(headRotation);
        }
    }

    public float getEntityHeadRotation(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.ck();
    }

    public void setEntityYaw(Entity e, float yaw) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.f(yaw);
    }

    public float getEntityYaw(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.dw();
    }

    public void setEntityPitch(Entity e, float pitch) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.e(pitch);
    }

    public float getEntityPitch(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.dy();
    }

    public void setEntityNavigationTarget(Entity entity, Location target, double speed) {
        if (entity instanceof Bat) {
            ((CraftBat)entity).getHandle().bS = new BlockPosition(target.getBlockX(), target.getBlockY(), target.getBlockZ());
        } else if (entity instanceof Vex) {
            EntityVex entityVex = ((CraftVex)entity).getHandle();
            entityVex.D().a(target.getX(), target.getY(), target.getZ(), speed);
            if (entityVex.P_() == null) {
                entityVex.C().a(target.getX(), target.getY(), target.getZ(), 180.0f, 20.0f);
            }
        } else if (entity instanceof CraftMob) {
            ((CraftMob)entity).getHandle().G().a(target.getX(), target.getY(), target.getZ(), speed);
        } else {
            throw new IllegalArgumentException("Cannot set the navigation target for this mob: " + (Serializable)((Object)(entity == null ? "null" : entity.getType())));
        }
    }

    public void setEntityLeftHanded(Entity ent, boolean left) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)nmsEntity;
            mob.u(left);
        }
    }

    public boolean isEntityLeftHanded(Entity ent) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)nmsEntity;
            return mob.fL();
        }
        return false;
    }

    public boolean isEntityInvisible(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.ca();
    }

    public void setEntityInvisible(Entity entity, boolean invisible) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.j(invisible);
    }

    public boolean hasEntityNoClip(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.ae;
    }

    public void setEntityNoClip(Entity entity, boolean noClip) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.ae = noClip;
    }

    public boolean areChunkEntitiesLoaded(Chunk c) {
        return ((CraftWorld)c.getWorld()).getHandle().c(ChunkCoordIntPair.c((int)c.getX(), (int)c.getZ()));
    }

    public void loadChunkEntities(Chunk c) {
        this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Call to unimplemented method", new RuntimeException());
    }

    public void setOnGround(Entity entity, boolean onGround) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.c(onGround);
    }

    public Entity getEntityById(World world, int id) {
        net.minecraft.world.entity.Entity entity = ((CraftWorld)world).getHandle().a(id);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public void setPose(Entity entity, Pose pose) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.b(EntityPose.values()[pose.ordinal()]);
    }

    public void setWolfAngerTime(Wolf entity, int timeInTicks) {
        EntityWolf nmsEntity = ((CraftWolf)entity).getHandle();
        nmsEntity.a(timeInTicks);
    }

    public void setAggressive(Mob entity, boolean aggressive) {
        EntityInsentient nmsEntity = ((CraftMob)entity).getHandle();
        nmsEntity.v(aggressive);
    }

    public boolean isAggressive(Mob entity) {
        EntityInsentient nmsEntity = ((CraftMob)entity).getHandle();
        return nmsEntity.fM();
    }

    public boolean isCelebrating(Raider entity) {
        EntityRaider nmsEntity = ((CraftRaider)entity).getHandle();
        return nmsEntity.gj();
    }

    public void setCelebrating(Raider entity, boolean celebrating) {
        EntityRaider nmsEntity = ((CraftRaider)entity).getHandle();
        nmsEntity.A(celebrating);
    }

    public void setCamelLastPoseChange(Camel entity, long tick) {
        net.minecraft.world.entity.animal.camel.Camel nmsEntity = ((CraftCamel)entity).getHandle();
        nmsEntity.a(nmsEntity.Y().U() - tick);
    }

    public long getCamelLastPoseChange(Camel entity) {
        net.minecraft.world.entity.animal.camel.Camel nmsEntity = ((CraftCamel)entity).getHandle();
        return nmsEntity.gg();
    }
}

