/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.v1_19_R1_0;

import com.destroystokyo.paper.entity.ai.VanillaGoal;
import de.cubeside.nmsutils.EntityUtils;
import de.cubeside.nmsutils.NMSUtils;
import de.cubeside.nmsutils.util.ReobfHelper;
import de.cubeside.nmsutils.v1_19_R1_0.NMSUtilsImpl;
import de.cubeside.nmsutils.v1_19_R1_0.PathfinderGoalLimitedRandomStrollLand;
import java.lang.reflect.Field;
import java.util.function.Function;
import java.util.logging.Level;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.entity.Visibility;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftBat;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftMob;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPiglin;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftShulker;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftVex;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Vex;
import org.bukkit.util.Vector;

public class EntityUtilsImpl
implements EntityUtils {
    private static final Field FIELD_BAT_TARGET = ReobfHelper.getFieldByMojangName(EntityBat.class, (String)"targetPosition");
    private static final Field FIELD_ENTITY_TRACKER = ReobfHelper.getFieldByMojangName(net.minecraft.world.entity.Entity.class, (String)"tracker");
    private final NMSUtilsImpl nmsUtils;

    public EntityUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    public void clearAI(Entity entity) {
        if (entity instanceof Mob) {
            this.nmsUtils.getPlugin().getServer().getMobGoals().removeAllGoals((Mob)entity);
        }
    }

    public void addGoalFloat(Mob mob) {
        if (!Bukkit.getMobGoals().hasGoal(mob, VanillaGoal.FLOAT)) {
            EntityInsentient h = ((CraftMob)mob).getHandle();
            h.bS.a(1, (PathfinderGoal)new PathfinderGoalFloat(h));
        }
    }

    public void addGoalLimitedStrollLand(Creature mob, double velocity, Function<Vector, Boolean> checkTargetFunction) {
        EntityCreature h = ((CraftCreature)mob).getHandle();
        h.bS.a(7, (PathfinderGoal)new PathfinderGoalLimitedRandomStrollLand(h, velocity, checkTargetFunction));
    }

    public int getShulkerOpenState(Entity shulker) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return 0;
            }
            CraftShulker cs = (CraftShulker)shulker;
            return cs.getHandle().fQ();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get shulker open state", e);
            return 0;
        }
    }

    public void setShulkerOpenState(Entity shulker, int state) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return;
            }
            state = Math.max(0, Math.min(127, state));
            CraftShulker cs = (CraftShulker)shulker;
            cs.getHandle().a(state);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set shulker open state", e);
        }
    }

    public boolean isPiglinDancing(Entity piglin) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return false;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            return cs.getHandle().fS();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get piglin dancing state", e);
            return false;
        }
    }

    public void setPiglinDancing(Entity piglin, boolean dancing) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            cs.getHandle().w(dancing);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set piglin dancing state", e);
        }
    }

    public void sendEntityPositionUpdate(Entity entity) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
        try {
            PlayerChunkMap.EntityTracker ete = (PlayerChunkMap.EntityTracker)FIELD_ENTITY_TRACKER.get(handle);
            if (ete != null) {
                PacketPlayOutEntityTeleport positionPacket = new PacketPlayOutEntityTeleport(handle);
                ete.f.stream().forEach(viewer -> viewer.a((Packet)positionPacket));
            }
        }
        catch (ReflectiveOperationException e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not send teleport packet", e);
        }
    }

    public void moveEntity(Entity e, double x, double y, double z) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.a(EnumMoveType.a, new Vec3D(x, y, z));
    }

    public void moveEntity(Entity e, Vector v) {
        this.moveEntity(e, v.getX(), v.getY(), v.getZ());
    }

    public void setEntityHeadRotation(Entity e, float headRotation) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        if (handle instanceof EntityLiving) {
            ((EntityLiving)handle).aZ = headRotation;
        } else {
            handle.l(headRotation);
        }
    }

    public float getEntityHeadRotation(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.ch();
    }

    public void setEntityYaw(Entity e, float yaw) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.o(yaw);
    }

    public float getEntityYaw(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.dr();
    }

    public void setEntityPitch(Entity e, float pitch) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        handle.p(pitch);
    }

    public float getEntityPitch(Entity e) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)e).getHandle();
        return handle.dt();
    }

    public void setEntityNavigationTarget(Entity entity, Location target, double speed) {
        if (entity instanceof Bat) {
            try {
                FIELD_BAT_TARGET.set(((CraftBat)entity).getHandle(), new BlockPosition(target.getX(), target.getY(), target.getZ()));
            }
            catch (ReflectiveOperationException e) {
                this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "could not set field", e);
            }
        } else if (entity instanceof Vex) {
            EntityVex entityVex = ((CraftVex)entity).getHandle();
            entityVex.A().a(target.getX(), target.getY(), target.getZ(), speed);
            if (entityVex.G() == null) {
                entityVex.z().a(target.getX(), target.getY(), target.getZ(), 180.0f, 20.0f);
            }
        } else if (entity instanceof CraftMob) {
            ((CraftMob)entity).getHandle().D().a(target.getX(), target.getY(), target.getZ(), speed);
        } else {
            throw new IllegalArgumentException("Cannot set the navigation target for this mob");
        }
    }

    public void setEntityLeftHanded(Entity ent, boolean left) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)nmsEntity;
            mob.t(left);
        }
    }

    public boolean isEntityLeftHanded(Entity ent) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)nmsEntity;
            return mob.fC();
        }
        return false;
    }

    public boolean isEntityInvisible(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.bY();
    }

    public void setEntityInvisible(Entity entity, boolean invisible) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.j(invisible);
    }

    public boolean hasEntityNoClip(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.Q;
    }

    public void setEntityNoClip(Entity entity, boolean noClip) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.Q = noClip;
    }

    public boolean areChunkEntitiesLoaded(Chunk c) {
        return ((CraftWorld)c.getWorld()).getHandle().c(ChunkCoordIntPair.c((int)c.getX(), (int)c.getZ()));
    }

    public void loadChunkEntities(Chunk c) {
        int x = c.getX();
        int z = c.getZ();
        World world = c.getWorld();
        if (!world.isChunkLoaded(x, z)) {
            world.getChunkAt(x, z);
        }
        if (this.areChunkEntitiesLoaded(c)) {
            return;
        }
        WorldServer serverLevel = ((CraftWorld)world).getHandle();
        serverLevel.P.a(new ChunkCoordIntPair(x, z), Visibility.b);
        if (!this.areChunkEntitiesLoaded(c)) {
            serverLevel.n().c(() -> {
                if (this.areChunkEntitiesLoaded(c)) {
                    return true;
                }
                serverLevel.P.a();
                return this.areChunkEntitiesLoaded(c);
            });
        }
    }

    public void setOnGround(Entity entity, boolean onGround) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.c(onGround);
    }

    public Entity getEntityById(World world, int id) {
        net.minecraft.world.entity.Entity entity = ((CraftWorld)world).getHandle().a(id);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public void setPose(Entity entity, Pose pose) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.b(EntityPose.values()[pose.ordinal()]);
    }
}

