/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.v1_17_R1_1;

import com.destroystokyo.paper.entity.ai.VanillaGoal;
import de.cubeside.nmsutils.EntityUtils;
import de.cubeside.nmsutils.NMSUtils;
import de.cubeside.nmsutils.v1_17_R1_1.NMSUtilsImpl;
import de.cubeside.nmsutils.v1_17_R1_1.PathfinderGoalLimitedRandomStrollLand;
import java.lang.reflect.Field;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftBat;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftMob;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPiglin;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftShulker;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftVex;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Vex;
import org.bukkit.util.Vector;

public class EntityUtilsImpl
implements EntityUtils {
    private static final String FIELD_BAT_TARGET_NAME = "bU";
    private final NMSUtilsImpl nmsUtils;
    private Field fieldEntityTracker;
    private Field fieldBatTarget;

    public EntityUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    public void clearAI(Entity entity) {
        if (entity instanceof Mob) {
            this.nmsUtils.getPlugin().getServer().getMobGoals().removeAllGoals((Mob)entity);
        }
    }

    public void addGoalFloat(Mob mob) {
        if (!Bukkit.getMobGoals().hasGoal(mob, VanillaGoal.FLOAT)) {
            atw h = ((CraftMob)mob).getHandle();
            h.bP.a(1, (azp)new azj(h));
        }
    }

    public void addGoalLimitedStrollLand(Creature mob, double velocity, Function<Vector, Boolean> checkTargetFunction) {
        aud h = ((CraftCreature)mob).getHandle();
        h.bP.a(7, (azp)new PathfinderGoalLimitedRandomStrollLand(h, velocity, checkTargetFunction));
    }

    public int getShulkerOpenState(Entity shulker) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return 0;
            }
            CraftShulker cs = (CraftShulker)shulker;
            return cs.getHandle().fC();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get shulker open state", e);
            return 0;
        }
    }

    public void setShulkerOpenState(Entity shulker, int state) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return;
            }
            state = Math.max(0, Math.min(127, state));
            CraftShulker cs = (CraftShulker)shulker;
            cs.getHandle().a(state);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set shulker open state", e);
        }
    }

    public boolean isPiglinDancing(Entity piglin) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return false;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            return cs.getHandle().fD();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get piglin dancing state", e);
            return false;
        }
    }

    public void setPiglinDancing(Entity piglin, boolean dancing) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            cs.getHandle().w(dancing);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set piglin dancing state", e);
        }
    }

    public void sendEntityPositionUpdate(Entity entity) {
        atg handle = ((CraftEntity)entity).getHandle();
        if (this.fieldEntityTracker == null) {
            try {
                this.fieldEntityTracker = atg.class.getDeclaredField("tracker");
                this.fieldEntityTracker.setAccessible(true);
            }
            catch (Exception e) {
                this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get tracker field", e);
            }
        }
        try {
            abe.b ete = (abe.b)this.fieldEntityTracker.get(handle);
            if (ete != null) {
                tf positionPacket = new tf(handle);
                ete.f.stream().forEach(viewer -> viewer.a((pk)positionPacket));
            }
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not send teleport packet", e);
        }
    }

    public void moveEntity(Entity e, double x, double y, double z) {
        atg handle = ((CraftEntity)e).getHandle();
        handle.a(aua.a, new dna(x, y, z));
    }

    public void moveEntity(Entity e, Vector v) {
        this.moveEntity(e, v.getX(), v.getY(), v.getZ());
    }

    public void setEntityHeadRotation(Entity e, float headRotation) {
        atg handle = ((CraftEntity)e).getHandle();
        if (handle instanceof atu) {
            ((atu)handle).aZ = headRotation;
        } else {
            handle.l(headRotation);
        }
    }

    public float getEntityHeadRotation(Entity e) {
        atg handle = ((CraftEntity)e).getHandle();
        return handle.bZ();
    }

    public void setEntityYaw(Entity e, float yaw) {
        atg handle = ((CraftEntity)e).getHandle();
        handle.o(yaw);
    }

    public float getEntityYaw(Entity e) {
        atg handle = ((CraftEntity)e).getHandle();
        return handle.dh();
    }

    public void setEntityPitch(Entity e, float pitch) {
        atg handle = ((CraftEntity)e).getHandle();
        handle.p(pitch);
    }

    public float getEntityPitch(Entity e) {
        atg handle = ((CraftEntity)e).getHandle();
        return handle.di();
    }

    public void setEntityNavigationTarget(Entity entity, Location target, double speed) {
        if (entity instanceof Bat) {
            try {
                if (this.fieldBatTarget == null) {
                    this.fieldBatTarget = bdt.class.getDeclaredField(FIELD_BAT_TARGET_NAME);
                    this.fieldBatTarget.setAccessible(true);
                }
                this.fieldBatTarget.set(((CraftBat)entity).getHandle(), new gg(target.getX(), target.getY(), target.getZ()));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "could not set field", e);
            }
        } else if (entity instanceof Vex) {
            bim entityVex = ((CraftVex)entity).getHandle();
            entityVex.B().a(target.getX(), target.getY(), target.getZ(), speed);
            if (entityVex.H() == null) {
                entityVex.A().a(target.getX(), target.getY(), target.getZ(), 180.0f, 20.0f);
            }
        } else {
            ((CraftCreature)entity).getHandle().F().a(target.getX(), target.getY(), target.getZ(), speed);
        }
    }

    public void setEntityLeftHanded(Entity ent, boolean left) {
        atg nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof atw) {
            ((atw)nmsEntity).t(left);
        }
    }

    public boolean isEntityLeftHanded(Entity ent) {
        atg nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof atw) {
            return ((atw)nmsEntity).fq();
        }
        return false;
    }

    public boolean isEntityInvisible(Entity entity) {
        atg nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.bP();
    }

    public void setEntityInvisible(Entity entity, boolean invisible) {
        atg nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.j(invisible);
    }

    public boolean hasEntityNoClip(Entity entity) {
        atg nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.P;
    }

    public void setEntityNoClip(Entity entity, boolean noClip) {
        atg nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.P = noClip;
    }

    public boolean areChunkEntitiesLoaded(Chunk c) {
        return ((CraftWorld)c.getWorld()).getHandle().b(bvv.a((int)c.getX(), (int)c.getZ()));
    }

    public void loadChunkEntities(Chunk c) {
        int x = c.getX();
        int z = c.getZ();
        World world = c.getWorld();
        if (!world.isChunkLoaded(x, z)) {
            world.getChunkAt(x, z);
        }
        if (this.areChunkEntitiesLoaded(c)) {
            return;
        }
        abr serverLevel = ((CraftWorld)world).getHandle();
        serverLevel.G.a(new bvv(x, z), cor.b);
        if (!this.areChunkEntitiesLoaded(c)) {
            serverLevel.n().c(() -> {
                if (this.areChunkEntitiesLoaded(c)) {
                    return true;
                }
                serverLevel.G.a();
                return this.areChunkEntitiesLoaded(c);
            });
        }
    }

    public void setOnGround(Entity entity, boolean onGround) {
        atg nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.c(onGround);
    }

    public Entity getEntityById(World world, int id) {
        atg entity = ((CraftWorld)world).getHandle().a(id);
        return entity == null ? null : entity.getBukkitEntity();
    }
}

