/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubeConomy.vault;

import de.iani.cubeConomy.CubeConomyAPI;
import de.iani.cubeConomy.MoneyDatabaseException;
import de.iani.cubeConomy.MoneyException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;

public class CubeConomyEconomy
implements Economy {
    private CubeConomyAPI cubeConomy;

    public CubeConomyEconomy(CubeConomyAPI cubeConomy) {
        this.cubeConomy = cubeConomy;
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return "CubeConomy";
    }

    public boolean hasBankSupport() {
        return false;
    }

    public String currencyNamePlural() {
        return this.cubeConomy.getCurrencyNamePlural();
    }

    public String currencyNameSingular() {
        return this.cubeConomy.getCurrencyName();
    }

    public String format(double amount) {
        return this.cubeConomy.formatMoney(amount);
    }

    public int fractionalDigits() {
        return 2;
    }

    private UUID getPlayerUUID(String playerName) {
        return this.cubeConomy.getPlayerUUID(playerName);
    }

    public boolean createPlayerAccount(UUID playerUUID) {
        if (playerUUID == null) {
            return false;
        }
        try {
            this.cubeConomy.createAccount(playerUUID);
            return true;
        }
        catch (MoneyDatabaseException e) {
            return false;
        }
    }

    public double getBalance(UUID playerUUID) {
        if (playerUUID == null) {
            return 0.0;
        }
        try {
            return this.cubeConomy.getMoney(playerUUID);
        }
        catch (MoneyDatabaseException e) {
            return 0.0;
        }
    }

    public EconomyResponse depositPlayer(UUID playerUUID, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot desposit negative funds");
        }
        if (playerUUID == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Invalid player");
        }
        try {
            double newAmount = this.cubeConomy.changeMoney(playerUUID, amount);
            return new EconomyResponse(amount, newAmount, EconomyResponse.ResponseType.SUCCESS, null);
        }
        catch (MoneyDatabaseException e) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, e.getMessage());
        }
    }

    public EconomyResponse withdrawPlayer(UUID playerUUID, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        if (playerUUID == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Invalid player");
        }
        try {
            double newMoney = this.cubeConomy.withdrawMoney(playerUUID, amount);
            return new EconomyResponse(amount, newMoney, EconomyResponse.ResponseType.SUCCESS, null);
        }
        catch (MoneyException e) {
            return new EconomyResponse(0.0, this.getBalance(playerUUID), EconomyResponse.ResponseType.FAILURE, e.getMessage());
        }
        catch (MoneyDatabaseException e) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, e.getMessage());
        }
    }

    @Deprecated
    public boolean createPlayerAccount(String player) {
        return this.createPlayerAccount(this.getPlayerUUID(player));
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        return this.createPlayerAccount(player.getUniqueId());
    }

    @Deprecated
    public boolean createPlayerAccount(String player, String world) {
        return this.createPlayerAccount(player);
    }

    public boolean createPlayerAccount(OfflinePlayer player, String world) {
        return this.createPlayerAccount(player);
    }

    @Deprecated
    public boolean hasAccount(String player) {
        return this.createPlayerAccount(player);
    }

    public boolean hasAccount(OfflinePlayer player) {
        return this.createPlayerAccount(player);
    }

    @Deprecated
    public boolean hasAccount(String player, String world) {
        return this.hasAccount(player);
    }

    public boolean hasAccount(OfflinePlayer player, String world) {
        return this.hasAccount(player);
    }

    @Deprecated
    public double getBalance(String player) {
        return this.getBalance(this.getPlayerUUID(player));
    }

    public double getBalance(OfflinePlayer player) {
        return this.getBalance(player.getUniqueId());
    }

    @Deprecated
    public double getBalance(String player, String world) {
        return this.getBalance(player);
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player);
    }

    @Deprecated
    public boolean has(String player, double amount) {
        return this.getBalance(player) >= amount;
    }

    public boolean has(OfflinePlayer player, double amount) {
        return this.getBalance(player) >= amount;
    }

    @Deprecated
    public boolean has(String player, String world, double amount) {
        return this.has(player, amount);
    }

    public boolean has(OfflinePlayer player, String world, double amount) {
        return this.has(player, amount);
    }

    @Deprecated
    public EconomyResponse depositPlayer(String player, double amount) {
        return this.depositPlayer(this.getPlayerUUID(player), amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        return this.depositPlayer(player.getUniqueId(), amount);
    }

    @Deprecated
    public EconomyResponse depositPlayer(String player, String world, double amount) {
        return this.depositPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String world, double amount) {
        return this.depositPlayer(player, amount);
    }

    @Deprecated
    public EconomyResponse withdrawPlayer(String player, double amount) {
        return this.withdrawPlayer(this.getPlayerUUID(player), amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        return this.withdrawPlayer(player.getUniqueId(), amount);
    }

    @Deprecated
    public EconomyResponse withdrawPlayer(String player, String world, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String world, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse bankBalance(String bank) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public EconomyResponse bankDeposit(String bank, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public EconomyResponse bankHas(String bank, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public EconomyResponse bankWithdraw(String bank, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    @Deprecated
    public EconomyResponse createBank(String bank, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public EconomyResponse createBank(String bank, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public EconomyResponse deleteBank(String bank) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    @Deprecated
    public EconomyResponse isBankMember(String bank, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public EconomyResponse isBankMember(String bank, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    @Deprecated
    public EconomyResponse isBankOwner(String bank, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public EconomyResponse isBankOwner(String bank, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported");
    }

    public List<String> getBanks() {
        return Collections.EMPTY_LIST;
    }
}

