/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubeConomy.data;

import de.iani.cubeConomy.CubeConomy;
import de.iani.cubeConomy.data.SQLConfig;
import org.bukkit.configuration.file.FileConfiguration;

public class CubeConomyConfig {
    private CubeConomy plugin;
    private SQLConfig sqlConfig;
    private String currencyName;
    private String currencyNamePlural;
    private double initialMoney;
    private boolean bungeeBroadcast;

    public CubeConomyConfig(CubeConomy plugin) {
        this.plugin = plugin;
        plugin.saveDefaultConfig();
        this.reloadConfig();
    }

    private void reloadConfig() {
        this.plugin.reloadConfig();
        FileConfiguration config = this.plugin.getConfig();
        this.sqlConfig = new SQLConfig(config.getConfigurationSection("database"));
        this.currencyName = config.getString("name");
        this.currencyNamePlural = config.getString("nameplural");
        this.initialMoney = config.getDouble("initialMoney");
        if (Double.isNaN(this.initialMoney) || Double.isInfinite(this.initialMoney)) {
            this.initialMoney = 0.0;
        }
        this.bungeeBroadcast = config.getBoolean("bungeeBroadcast");
    }

    public double getDefaultMoney() {
        return this.initialMoney;
    }

    public SQLConfig getSQLConfig() {
        return this.sqlConfig;
    }

    public String getCurrencyName() {
        return this.currencyName;
    }

    public String getCurrencyNamePlural() {
        return this.currencyNamePlural;
    }

    public boolean bungeeBroadcast() {
        return this.bungeeBroadcast;
    }
}

