/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubeConomy.commands.money;

import de.iani.cubeConomy.CubeConomy;
import de.iani.cubeConomy.MoneyDatabaseException;
import de.iani.cubeConomy.MoneyException;
import de.iani.cubeConomy.commands.ArgsParser;
import de.iani.cubeConomy.commands.SubCommand;
import de.iani.cubeConomy.events.Cause;
import de.iani.playerUUIDCache.CachedPlayer;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MoneyPayCommand
extends SubCommand {
    private CubeConomy plugin;

    public MoneyPayCommand(CubeConomy plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getUsage() {
        return "<name> <amount> [reason]";
    }

    @Override
    public boolean requiresPlayer() {
        return true;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String alias, String commandString, ArgsParser args) {
        String name = args.getNext(null);
        Player senderPlayer = (Player)sender;
        if (!args.hasNext()) {
            sender.sendMessage(commandString + this.getUsage());
            return true;
        }
        double amount = args.getNext(0.0);
        if (!Double.isFinite(amount = (double)Math.round(amount * 100.0) / 100.0) || amount < 0.01) {
            sender.sendMessage(CubeConomy.MESSAGE_PREFIX + String.valueOf(ChatColor.RED) + "Amount must be positive");
            return true;
        }
        CachedPlayer player = this.plugin.getPlayerUUIDCache().getPlayerFromNameOrUUID(name);
        if (player == null) {
            sender.sendMessage(CubeConomy.MESSAGE_PREFIX + String.valueOf(ChatColor.RED) + "Unknown player");
            return true;
        }
        if (senderPlayer.getUniqueId().equals(player.getUUID())) {
            sender.sendMessage(CubeConomy.MESSAGE_PREFIX + String.valueOf(ChatColor.RED) + "Cannot send money to yourself");
            return true;
        }
        String reason = args.getAll(null);
        try {
            this.plugin.transferMoney(sender, senderPlayer.getUniqueId(), player.getUUID(), amount, Cause.PAY_COMMAND, reason);
            this.plugin.getLogger().info(sender.getName() + " has sent " + this.plugin.formatMoney(amount) + " to " + player.getName() + (String)(reason == null ? "" : " with reason \"" + reason + "\""));
            String reasonMessage = reason == null ? "" : " for " + String.valueOf(ChatColor.WHITE) + reason + String.valueOf(ChatColor.DARK_GREEN);
            sender.sendMessage(CubeConomy.MESSAGE_PREFIX + "You have sent " + String.valueOf(ChatColor.WHITE) + this.plugin.formatMoney(amount) + String.valueOf(ChatColor.DARK_GREEN) + " to " + String.valueOf(ChatColor.WHITE) + player.getName() + String.valueOf(ChatColor.DARK_GREEN) + reasonMessage + ".");
            this.plugin.sendMessageTo(senderPlayer, player.getUUID(), CubeConomy.MESSAGE_PREFIX + String.valueOf(ChatColor.WHITE) + sender.getName() + String.valueOf(ChatColor.DARK_GREEN) + " has sent to you " + String.valueOf(ChatColor.WHITE) + this.plugin.formatMoney(amount) + String.valueOf(ChatColor.DARK_GREEN) + reasonMessage + ".");
        }
        catch (MoneyDatabaseException e) {
            sender.sendMessage(CubeConomy.MESSAGE_PREFIX + String.valueOf(ChatColor.RED) + "Database error: " + e.getMessage());
        }
        catch (MoneyException e) {
            sender.sendMessage(CubeConomy.MESSAGE_PREFIX + String.valueOf(ChatColor.RED) + e.getMessage());
        }
        return true;
    }

    @Override
    public ArrayList<String> onTabComplete(CommandSender sender, Command command, String alias, ArgsParser args) {
        if (args.remaining() == 1) {
            ArrayList<String> rv = new ArrayList<String>();
            for (Player p : this.plugin.getServer().getOnlinePlayers()) {
                rv.add(p.getName());
            }
            return rv;
        }
        return new ArrayList<String>();
    }
}

