/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubeConomy;

import de.iani.cubeConomy.BungeeBroadcast;
import de.iani.cubeConomy.CubeConomyAPI;
import de.iani.cubeConomy.MoneyDatabaseException;
import de.iani.cubeConomy.MoneyException;
import de.iani.cubeConomy.commands.CommandRouter;
import de.iani.cubeConomy.commands.money.MoneyCommand;
import de.iani.cubeConomy.commands.money.MoneyGiveCommand;
import de.iani.cubeConomy.commands.money.MoneyHelpCommand;
import de.iani.cubeConomy.commands.money.MoneyImportCommand;
import de.iani.cubeConomy.commands.money.MoneyPayCommand;
import de.iani.cubeConomy.commands.money.MoneySetCommand;
import de.iani.cubeConomy.commands.money.MoneyTakeCommand;
import de.iani.cubeConomy.commands.money.MoneyTopCommand;
import de.iani.cubeConomy.data.CubeConomyConfig;
import de.iani.cubeConomy.data.CubeConomyDatabase;
import de.iani.cubeConomy.events.Cause;
import de.iani.cubeConomy.events.MoneyChangedEvent;
import de.iani.cubeConomy.events.MoneyTransferedEvent;
import de.iani.cubeConomy.vault.CubeConomyEconomy;
import de.iani.playerUUIDCache.CachedPlayer;
import de.iani.playerUUIDCache.PlayerUUIDCache;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.UUID;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class CubeConomy
extends JavaPlugin
implements CubeConomyAPI {
    private PlayerUUIDCache playerUUIDCache;
    private CubeConomyConfig config;
    private CubeConomyDatabase database;
    private DecimalFormat moneyFormat;
    private BungeeBroadcast broadcaster;
    public static final String MESSAGE_PREFIX = ChatColor.DARK_GREEN + "[" + ChatColor.WHITE + "Money" + ChatColor.DARK_GREEN + "] ";

    public void onEnable() {
        this.playerUUIDCache = (PlayerUUIDCache)this.getServer().getPluginManager().getPlugin("PlayerUUIDCache");
        this.config = new CubeConomyConfig(this);
        try {
            this.database = new CubeConomyDatabase(this.config.getSQLConfig());
        }
        catch (SQLException e) {
            this.getLogger().log(Level.SEVERE, "Could not connect to database", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.moneyFormat = new DecimalFormat("###,##0.00");
        this.moneyFormat.setRoundingMode(RoundingMode.FLOOR);
        CommandRouter moneyCommand = new CommandRouter(this.getCommand("money"));
        moneyCommand.addCommandMapping(new MoneyCommand(this), new String[0]);
        moneyCommand.addCommandMapping(new MoneyHelpCommand(this), "help");
        moneyCommand.addCommandMapping(new MoneyPayCommand(this), "pay");
        moneyCommand.addCommandMapping(new MoneyTopCommand(this), "top");
        moneyCommand.addCommandMapping(new MoneyGiveCommand(this), "give");
        moneyCommand.addCommandMapping(new MoneyTakeCommand(this), "take");
        moneyCommand.addCommandMapping(new MoneySetCommand(this), "set");
        moneyCommand.addCommandMapping(new MoneyImportCommand(this), "import");
        CommandRouter payCommand = new CommandRouter(this.getCommand("pay"));
        payCommand.addCommandMapping(new MoneyPayCommand(this), new String[0]);
        if (this.getServer().getPluginManager().getPlugin("Vault") != null) {
            this.getServer().getServicesManager().register(Economy.class, (Object)new CubeConomyEconomy(this), (Plugin)this, ServicePriority.Highest);
            this.getLogger().info("Registered into Vault!");
        }
        if (this.config.bungeeBroadcast()) {
            this.broadcaster = new BungeeBroadcast(this);
        }
    }

    public void onDisable() {
        if (this.database != null) {
            this.database.disconnect();
            this.database = null;
        }
    }

    public PlayerUUIDCache getPlayerUUIDCache() {
        return this.playerUUIDCache;
    }

    public CubeConomyConfig getPluginConfig() {
        return this.config;
    }

    public CubeConomyDatabase getPluginDatabase() {
        return this.database;
    }

    @Override
    public UUID getPlayerUUID(String playerName) {
        CachedPlayer p = this.getPlayerUUIDCache().getPlayer(playerName);
        return p == null ? null : p.getUUID();
    }

    @Override
    public String getCurrencyName() {
        return this.config.getCurrencyName();
    }

    @Override
    public String getCurrencyNamePlural() {
        return this.config.getCurrencyNamePlural();
    }

    @Override
    public String formatMoney(double amount) {
        String formated = this.moneyFormat.format(amount);
        if (amount == 1.0) {
            return formated + " " + this.getCurrencyName();
        }
        return formated + " " + this.getCurrencyNamePlural();
    }

    @Override
    public void createAccount(UUID player) throws MoneyDatabaseException {
        if (player == null) {
            throw new NullPointerException("player is null");
        }
        try {
            this.database.createAccount(player, this.config.getDefaultMoney());
            return;
        }
        catch (SQLException e) {
            throw new MoneyDatabaseException("Could not query database", e);
        }
    }

    @Override
    public double getMoney(UUID player) throws MoneyDatabaseException {
        if (player == null) {
            throw new NullPointerException("player is null");
        }
        try {
            return this.database.getMoney(player, this.config.getDefaultMoney());
        }
        catch (SQLException e) {
            throw new MoneyDatabaseException("Could not query database", e);
        }
    }

    @Override
    public void setMoney(UUID player, double money) throws MoneyDatabaseException {
        this.setMoney(null, player, money, Cause.PLUGIN, null);
    }

    public void setMoney(CommandSender actor, UUID player, double money, Cause cause, String reason) throws MoneyDatabaseException {
        if (player == null) {
            throw new NullPointerException("player is null");
        }
        try {
            double delta = this.database.setMoney(player, money, this.config.getDefaultMoney());
            new MoneyChangedEvent(actor, delta, player, cause, reason).call();
            return;
        }
        catch (SQLException e) {
            throw new MoneyDatabaseException("Could not query database", e);
        }
    }

    @Override
    public double changeMoney(UUID player, double deltaMoney) throws MoneyDatabaseException {
        return this.changeMoney(null, player, deltaMoney, Cause.PLUGIN, null);
    }

    public double changeMoney(CommandSender actor, UUID player, double deltaMoney, Cause cause, String reason) throws MoneyDatabaseException {
        if (player == null) {
            throw new NullPointerException("player is null");
        }
        try {
            double result = this.database.changeMoney(player, deltaMoney, this.config.getDefaultMoney());
            new MoneyChangedEvent(actor, deltaMoney, player, cause, reason).call();
            return result;
        }
        catch (SQLException e) {
            throw new MoneyDatabaseException("Could not query database", e);
        }
    }

    @Override
    public double transferMoney(UUID fromPlayer, UUID toPlayer, double amount) throws MoneyException, MoneyDatabaseException {
        return this.transferMoney(null, fromPlayer, toPlayer, amount, Cause.PLUGIN, null);
    }

    public double transferMoney(CommandSender actor, UUID fromPlayer, UUID toPlayer, double amount, Cause cause, String reason) throws MoneyException, MoneyDatabaseException {
        if (fromPlayer == null) {
            throw new NullPointerException("fromPlayer is null");
        }
        if (toPlayer == null) {
            throw new NullPointerException("toPlayer is null");
        }
        try {
            CubeConomyDatabase.MoneyAndSuccess result = this.database.sendMoneyIfHas(fromPlayer, toPlayer, amount, this.config.getDefaultMoney());
            if (!result.isSuccess()) {
                throw new MoneyException("Insufficient funds");
            }
            new MoneyTransferedEvent(actor, amount, fromPlayer, toPlayer, cause, reason).call();
            return result.getNewAmount();
        }
        catch (SQLException e) {
            throw new MoneyDatabaseException("Could not query database", e);
        }
    }

    @Override
    public double withdrawMoney(UUID player, double withdrawMoney) throws MoneyException, MoneyDatabaseException {
        return this.withdrawMoney(null, player, withdrawMoney, Cause.PLUGIN, null);
    }

    public double withdrawMoney(CommandSender actor, UUID player, double withdrawMoney, Cause cause, String reason) throws MoneyException, MoneyDatabaseException {
        if (player == null) {
            throw new NullPointerException("player is null");
        }
        try {
            CubeConomyDatabase.MoneyAndSuccess result = this.database.withdrawMoneyIfHas(player, withdrawMoney, this.config.getDefaultMoney());
            if (!result.isSuccess()) {
                throw new MoneyException("Insufficient funds");
            }
            new MoneyChangedEvent(actor, -withdrawMoney, player, cause, reason).call();
            return result.getNewAmount();
        }
        catch (SQLException e) {
            throw new MoneyDatabaseException("Could not query database", e);
        }
    }

    public void sendMessageTo(Player senderPlayer, UUID targetUUID, String message) {
        Player target = this.getServer().getPlayer(targetUUID);
        if (target != null) {
            target.sendMessage(message);
        } else if (this.getPluginConfig().bungeeBroadcast() && this.broadcaster != null) {
            this.broadcaster.sendMessage(senderPlayer, targetUUID, message);
        }
    }
}

