/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreShopCreation;

import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class PriceChecker
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public static void onPreShopCreation(PreShopCreationEvent event) {
        Object line = event.getSignLine((byte)2).toUpperCase();
        String[] part = ((String)(line = ((String)line).replaceAll("(\\.\\d*?[1-9])0+", "$1"))).split(":");
        if (part.length > 2) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
            return;
        }
        if (part.length > 1 && (part[0].contains("S") || part[1].contains("B"))) {
            String temp = part[0];
            part[0] = part[1];
            part[1] = temp;
        }
        String buyPriceString = null;
        String sellPriceString = null;
        if (part[0].contains("S")) {
            sellPriceString = part[0].replace("S", "").trim();
        } else {
            buyPriceString = part[0].replace("B", "").trim();
            if (part.length > 1) {
                sellPriceString = part[1].replace("S", "").trim();
            }
        }
        if (buyPriceString != null && !PriceUtil.isPrice(buyPriceString)) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
            return;
        }
        if (sellPriceString != null && !PriceUtil.isPrice(sellPriceString)) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
            return;
        }
        if (buyPriceString != null && sellPriceString != null) {
            line = "B " + buyPriceString + " : " + sellPriceString + " S";
            if (((String)line).length() > 15) {
                line = "B" + buyPriceString + " : " + sellPriceString + "S";
            }
        } else if (buyPriceString != null) {
            line = "B " + buyPriceString;
        } else if (sellPriceString != null) {
            line = sellPriceString + " S";
        } else {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
            return;
        }
        if (((String)line).length() > 15) {
            line = ((String)line).replace(" ", "");
        }
        if (((String)line).length() > 15) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
            return;
        }
        event.setSignLine((byte)2, (String)line);
        if (!PriceUtil.hasBuyPrice((String)line) && !PriceUtil.hasSellPrice((String)line)) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
        }
    }
}

