/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Events;

import com.Acrobot.ChestShop.Signs.ChestShopMetaData;
import javax.annotation.Nullable;
import org.bukkit.block.Container;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;

public class ShopCreatedEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final Player creator;
    private final Sign sign;
    private final String[] signLines;
    private final ChestShopMetaData chestShopMetaData;
    @Nullable
    private final Container chest;

    public ShopCreatedEvent(Player creator, Sign sign, @Nullable Container chest, String[] signLines, ChestShopMetaData chestShopMetaData) {
        this.creator = creator;
        this.sign = sign;
        this.chest = chest;
        this.signLines = (String[])signLines.clone();
        this.chestShopMetaData = chestShopMetaData;
    }

    public boolean isAdminshop() {
        return this.chestShopMetaData.isAdminshop();
    }

    public ItemStack getItemStack() {
        return this.chestShopMetaData.getItemStack();
    }

    public int getQuantity() {
        return this.chestShopMetaData.getQuantity();
    }

    public String getSignLine(short line) {
        return this.signLines[line];
    }

    public String[] getSignLines() {
        return this.signLines;
    }

    public Player getPlayer() {
        return this.creator;
    }

    public Sign getSign() {
        return this.sign;
    }

    @Nullable
    public Container getChest() {
        return this.chest;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

