/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Utils;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.inventory.InventoryHolder;

public class uBlock {
    public static final BlockFace[] CHEST_EXTENSION_FACES = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH};
    public static final BlockFace[] SHOP_FACES = new BlockFace[]{BlockFace.DOWN, BlockFace.UP, BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH};

    public static Sign getConnectedSign(Block chestBlock) {
        return uBlock.getConnectedSign(chestBlock, null);
    }

    public static Sign getConnectedSign(Block chestBlock, Block ignoredSign) {
        Block neighbour;
        Sign sign = uBlock.findAnyNearbyShopSign(chestBlock, ignoredSign);
        if (sign == null && (neighbour = uBlock.getConnectedChest(chestBlock)) != null) {
            sign = uBlock.findAnyNearbyShopSign(neighbour, ignoredSign);
        }
        return sign;
    }

    public static Block getConnectedChest(Block chestBlock) {
        BlockData blockData = chestBlock.getBlockData();
        if (!(blockData instanceof Chest)) {
            return null;
        }
        Chest chestData = (Chest)blockData;
        if (chestData.getType() != Chest.Type.SINGLE) {
            Block face;
            BlockFace chestFace = chestData.getFacing();
            if (chestFace == BlockFace.WEST) {
                chestFace = BlockFace.NORTH;
            } else if (chestFace == BlockFace.NORTH) {
                chestFace = BlockFace.EAST;
            } else if (chestFace == BlockFace.EAST) {
                chestFace = BlockFace.SOUTH;
            } else if (chestFace == BlockFace.SOUTH) {
                chestFace = BlockFace.WEST;
            }
            if (chestData.getType() == Chest.Type.RIGHT) {
                chestFace = chestFace.getOppositeFace();
            }
            if ((face = chestBlock.getRelative(chestFace)).getType() == chestBlock.getType()) {
                return face;
            }
        }
        return null;
    }

    public static Container findConnectedChest(Sign sign) {
        WallSign signData;
        Block faceBlock;
        Block block = sign.getBlock();
        BlockFace signFace = null;
        BlockData data = sign.getBlockData();
        if (data instanceof WallSign && BlockUtil.isChest(faceBlock = block.getRelative(signFace = (signData = (WallSign)data).getFacing().getOppositeFace()))) {
            return (Container)faceBlock.getState();
        }
        for (BlockFace bf : SHOP_FACES) {
            Block faceBlock2;
            if (bf == signFace || !BlockUtil.isChest(faceBlock2 = block.getRelative(bf))) continue;
            return (Container)faceBlock2.getState();
        }
        return null;
    }

    private static Sign findAnyNearbyShopSign(Block block, Block ignoredSign) {
        for (BlockFace bf : SHOP_FACES) {
            Sign sign;
            Block faceBlock = block.getRelative(bf);
            if (ignoredSign != null && ignoredSign.equals(faceBlock) || !BlockUtil.isSign(faceBlock) || !ChestShopSign.isValid(sign = (Sign)faceBlock.getState())) continue;
            return sign;
        }
        return null;
    }

    public static boolean isShopChest(Block chest) {
        return uBlock.getConnectedSign(chest) != null;
    }

    public static boolean isShopChest(InventoryHolder holder) {
        Block block = uBlock.getInventoryHolderBlock(holder);
        return block != null && uBlock.isShopChest(block);
    }

    public static Block getInventoryHolderBlock(InventoryHolder holder) {
        if (holder instanceof DoubleChest) {
            return ((DoubleChest)holder).getLocation().getBlock();
        }
        if (holder instanceof BlockState) {
            return ((BlockState)holder).getBlock();
        }
        return null;
    }
}

