/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.ORMlite.stmt;

import com.Acrobot.ChestShop.ORMlite.dao.CloseableIterator;
import com.Acrobot.ChestShop.ORMlite.dao.Dao;
import com.Acrobot.ChestShop.ORMlite.dao.GenericRawResults;
import com.Acrobot.ChestShop.ORMlite.db.DatabaseType;
import com.Acrobot.ChestShop.ORMlite.field.FieldType;
import com.Acrobot.ChestShop.ORMlite.stmt.ArgumentHolder;
import com.Acrobot.ChestShop.ORMlite.stmt.PreparedQuery;
import com.Acrobot.ChestShop.ORMlite.stmt.StatementBuilder;
import com.Acrobot.ChestShop.ORMlite.stmt.query.ColumnNameOrRawSql;
import com.Acrobot.ChestShop.ORMlite.stmt.query.OrderBy;
import com.Acrobot.ChestShop.ORMlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class QueryBuilder<T, ID>
extends StatementBuilder<T, ID> {
    private final FieldType idField;
    private FieldType[] resultFieldTypes;
    private boolean distinct;
    private boolean selectIdColumn;
    private List<ColumnNameOrRawSql> selectList;
    private List<OrderBy> orderByList;
    private List<ColumnNameOrRawSql> groupByList;
    private boolean isInnerQuery;
    private String alias;
    private String countOfQuery;
    private String having;
    private Long limit;
    private Long offset;
    private List<JoinInfo> joinList;

    public QueryBuilder(DatabaseType databaseType, TableInfo<T, ID> tableInfo, Dao<T, ID> dao) {
        super(databaseType, tableInfo, dao, StatementBuilder.StatementType.SELECT);
        this.idField = tableInfo.getIdField();
        this.selectIdColumn = this.idField != null;
    }

    void enableInnerQuery() {
        this.isInnerQuery = true;
    }

    int getSelectColumnCount() {
        if (this.countOfQuery != null) {
            return 1;
        }
        if (this.selectList == null) {
            return 0;
        }
        return this.selectList.size();
    }

    String getSelectColumnsAsString() {
        if (this.countOfQuery != null) {
            return "COUNT(" + this.countOfQuery + ")";
        }
        if (this.selectList == null) {
            return "";
        }
        return this.selectList.toString();
    }

    public PreparedQuery<T> prepare() throws SQLException {
        boolean cacheStore = this.selectList == null;
        return super.prepareStatement(this.limit, cacheStore);
    }

    public QueryBuilder<T, ID> selectColumns(String ... columns) {
        for (String column : columns) {
            this.addSelectColumnToList(column);
        }
        return this;
    }

    public QueryBuilder<T, ID> selectColumns(Iterable<String> columns) {
        for (String column : columns) {
            this.addSelectColumnToList(column);
        }
        return this;
    }

    public QueryBuilder<T, ID> selectRaw(String ... columns) {
        for (String column : columns) {
            this.addSelectToList(ColumnNameOrRawSql.withRawSql(column));
        }
        return this;
    }

    public QueryBuilder<T, ID> groupBy(String columnName) {
        FieldType fieldType = this.verifyColumnName(columnName);
        if (fieldType.isForeignCollection()) {
            throw new IllegalArgumentException("Can't groupBy foreign collection field: " + columnName);
        }
        this.addGroupBy(ColumnNameOrRawSql.withColumnName(columnName));
        return this;
    }

    public QueryBuilder<T, ID> groupByRaw(String rawSql) {
        this.addGroupBy(ColumnNameOrRawSql.withRawSql(rawSql));
        return this;
    }

    public QueryBuilder<T, ID> orderBy(String columnName, boolean ascending) {
        FieldType fieldType = this.verifyColumnName(columnName);
        if (fieldType.isForeignCollection()) {
            throw new IllegalArgumentException("Can't orderBy foreign collection field: " + columnName);
        }
        this.addOrderBy(new OrderBy(columnName, ascending));
        return this;
    }

    public QueryBuilder<T, ID> orderByRaw(String rawSql) {
        this.addOrderBy(new OrderBy(rawSql, null));
        return this;
    }

    public QueryBuilder<T, ID> orderByRaw(String rawSql, ArgumentHolder ... args) {
        this.addOrderBy(new OrderBy(rawSql, args));
        return this;
    }

    public QueryBuilder<T, ID> distinct() {
        this.distinct = true;
        this.selectIdColumn = false;
        return this;
    }

    public QueryBuilder<T, ID> limit(Long maxRows) {
        this.limit = maxRows;
        return this;
    }

    public QueryBuilder<T, ID> offset(Long startRow) throws SQLException {
        if (this.databaseType.isOffsetSqlSupported()) {
            this.offset = startRow;
            return this;
        }
        throw new SQLException("Offset is not supported by this database");
    }

    public QueryBuilder<T, ID> setCountOf(boolean countOf) {
        return this.setCountOf("*");
    }

    public QueryBuilder<T, ID> setCountOf(String countOfQuery) {
        this.countOfQuery = countOfQuery;
        return this;
    }

    public QueryBuilder<T, ID> having(String having) {
        this.having = having;
        return this;
    }

    public QueryBuilder<T, ID> join(QueryBuilder<?, ?> joinedQueryBuilder) throws SQLException {
        this.addJoinInfo(JoinType.INNER, null, null, joinedQueryBuilder, JoinWhereOperation.AND);
        return this;
    }

    public QueryBuilder<T, ID> join(QueryBuilder<?, ?> joinedQueryBuilder, JoinType type, JoinWhereOperation operation) throws SQLException {
        this.addJoinInfo(type, null, null, joinedQueryBuilder, operation);
        return this;
    }

    public QueryBuilder<T, ID> joinOr(QueryBuilder<?, ?> joinedQueryBuilder) throws SQLException {
        this.addJoinInfo(JoinType.INNER, null, null, joinedQueryBuilder, JoinWhereOperation.OR);
        return this;
    }

    public QueryBuilder<T, ID> leftJoin(QueryBuilder<?, ?> joinedQueryBuilder) throws SQLException {
        this.addJoinInfo(JoinType.LEFT, null, null, joinedQueryBuilder, JoinWhereOperation.AND);
        return this;
    }

    public QueryBuilder<T, ID> leftJoinOr(QueryBuilder<?, ?> joinedQueryBuilder) throws SQLException {
        this.addJoinInfo(JoinType.LEFT, null, null, joinedQueryBuilder, JoinWhereOperation.OR);
        return this;
    }

    public QueryBuilder<T, ID> join(String localColumnName, String joinedColumnName, QueryBuilder<?, ?> joinedQueryBuilder) throws SQLException {
        this.addJoinInfo(JoinType.INNER, localColumnName, joinedColumnName, joinedQueryBuilder, JoinWhereOperation.AND);
        return this;
    }

    public QueryBuilder<T, ID> join(String localColumnName, String joinedColumnName, QueryBuilder<?, ?> joinedQueryBuilder, JoinType type, JoinWhereOperation operation) throws SQLException {
        this.addJoinInfo(type, localColumnName, joinedColumnName, joinedQueryBuilder, operation);
        return this;
    }

    public List<T> query() throws SQLException {
        return this.dao.query(this.prepare());
    }

    public GenericRawResults<String[]> queryRaw() throws SQLException {
        return this.dao.queryRaw(this.prepareStatementString(), new String[0]);
    }

    public T queryForFirst() throws SQLException {
        return this.dao.queryForFirst(this.prepare());
    }

    public String[] queryRawFirst() throws SQLException {
        return this.dao.queryRaw(this.prepareStatementString(), new String[0]).getFirstResult();
    }

    public CloseableIterator<T> iterator() throws SQLException {
        return this.dao.iterator(this.prepare());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countOf() throws SQLException {
        String countOfQuerySave = this.countOfQuery;
        try {
            this.setCountOf(true);
            long l = this.dao.countOf(this.prepare());
            return l;
        }
        finally {
            this.setCountOf(countOfQuerySave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countOf(String countOfQuery) throws SQLException {
        String countOfQuerySave = this.countOfQuery;
        try {
            this.setCountOf(countOfQuery);
            long l = this.dao.countOf(this.prepare());
            return l;
        }
        finally {
            this.setCountOf(countOfQuerySave);
        }
    }

    public QueryBuilder<T, ID> setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    @Override
    public void reset() {
        super.reset();
        this.distinct = false;
        boolean bl = this.selectIdColumn = this.idField != null;
        if (this.selectList != null) {
            this.selectList.clear();
            this.selectList = null;
        }
        if (this.orderByList != null) {
            this.orderByList.clear();
            this.orderByList = null;
        }
        if (this.groupByList != null) {
            this.groupByList.clear();
            this.groupByList = null;
        }
        this.isInnerQuery = false;
        this.countOfQuery = null;
        this.having = null;
        this.limit = null;
        this.offset = null;
        if (this.joinList != null) {
            this.joinList.clear();
            this.joinList = null;
        }
        this.addTableName = false;
        this.alias = null;
    }

    @Override
    protected void appendStatementStart(StringBuilder sb, List<ArgumentHolder> argList) {
        if (this.joinList == null) {
            this.setAddTableName(false);
        } else {
            this.setAddTableName(true);
        }
        sb.append("SELECT ");
        if (this.databaseType.isLimitAfterSelect()) {
            this.appendLimit(sb);
        }
        if (this.distinct) {
            sb.append("DISTINCT ");
        }
        if (this.countOfQuery == null) {
            this.appendSelects(sb);
        } else {
            this.type = StatementBuilder.StatementType.SELECT_LONG;
            sb.append("COUNT(").append(this.countOfQuery).append(") ");
        }
        sb.append("FROM ");
        this.databaseType.appendEscapedEntityName(sb, this.tableName);
        if (this.alias != null) {
            this.appendAlias(sb);
        }
        sb.append(' ');
        if (this.joinList != null) {
            this.appendJoinSql(sb);
        }
    }

    @Override
    protected FieldType[] getResultFieldTypes() {
        return this.resultFieldTypes;
    }

    @Override
    protected boolean appendWhereStatement(StringBuilder sb, List<ArgumentHolder> argList, StatementBuilder.WhereOperation operation) throws SQLException {
        boolean first;
        boolean bl = first = operation == StatementBuilder.WhereOperation.FIRST;
        if (this.where != null) {
            first = super.appendWhereStatement(sb, argList, operation);
        }
        if (this.joinList != null) {
            for (JoinInfo joinInfo : this.joinList) {
                operation = first ? StatementBuilder.WhereOperation.FIRST : joinInfo.operation.whereOperation;
                first = joinInfo.queryBuilder.appendWhereStatement(sb, argList, operation);
            }
        }
        return first;
    }

    @Override
    protected void appendStatementEnd(StringBuilder sb, List<ArgumentHolder> argList) throws SQLException {
        this.maybeAppendGroupBys(sb, true);
        this.maybeAppendHaving(sb);
        this.maybeAppendOrderBys(sb, argList, true);
        if (!this.databaseType.isLimitAfterSelect()) {
            this.appendLimit(sb);
        }
        this.appendOffset(sb);
        this.setAddTableName(false);
    }

    @Override
    protected boolean shouldPrependTableNameToColumns() {
        return this.joinList != null;
    }

    protected void appendTableQualifier(StringBuilder sb) {
        this.databaseType.appendEscapedEntityName(sb, this.getTableName());
    }

    @Override
    protected String getTableName() {
        return this.alias == null ? this.tableName : this.alias;
    }

    private void addOrderBy(OrderBy orderBy) {
        if (this.orderByList == null) {
            this.orderByList = new ArrayList<OrderBy>();
        }
        this.orderByList.add(orderBy);
    }

    private void addGroupBy(ColumnNameOrRawSql groupBy) {
        if (this.groupByList == null) {
            this.groupByList = new ArrayList<ColumnNameOrRawSql>();
        }
        this.groupByList.add(groupBy);
        this.selectIdColumn = false;
    }

    private void setAddTableName(boolean addTableName) {
        this.addTableName = addTableName;
        if (this.joinList != null) {
            for (JoinInfo joinInfo : this.joinList) {
                super.setAddTableName(addTableName);
            }
        }
    }

    private void addJoinInfo(JoinType type, String localColumnName, String joinedColumnName, QueryBuilder<?, ?> joinedQueryBuilder, JoinWhereOperation operation) throws SQLException {
        JoinInfo joinInfo = new JoinInfo(type, joinedQueryBuilder, operation);
        if (localColumnName == null) {
            this.matchJoinedFields(joinInfo, joinedQueryBuilder);
        } else {
            this.matchJoinedFieldsByName(joinInfo, localColumnName, joinedColumnName, joinedQueryBuilder);
        }
        if (this.joinList == null) {
            this.joinList = new ArrayList<JoinInfo>();
        }
        this.joinList.add(joinInfo);
    }

    private void matchJoinedFieldsByName(JoinInfo joinInfo, String localColumnName, String joinedColumnName, QueryBuilder<?, ?> joinedQueryBuilder) throws SQLException {
        joinInfo.localField = this.tableInfo.getFieldTypeByColumnName(localColumnName);
        if (joinInfo.localField == null) {
            throw new SQLException("Could not find field in " + this.tableInfo.getDataClass() + " that has column-name '" + localColumnName + "'");
        }
        joinInfo.remoteField = joinedQueryBuilder.tableInfo.getFieldTypeByColumnName(joinedColumnName);
        if (joinInfo.remoteField == null) {
            throw new SQLException("Could not find field in " + joinedQueryBuilder.tableInfo.getDataClass() + " that has column-name '" + joinedColumnName + "'");
        }
    }

    private void matchJoinedFields(JoinInfo joinInfo, QueryBuilder<?, ?> joinedQueryBuilder) throws SQLException {
        for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
            FieldType foreignRefField = fieldType.getForeignRefField();
            if (!fieldType.isForeign() || !foreignRefField.equals(joinedQueryBuilder.tableInfo.getIdField())) continue;
            joinInfo.localField = fieldType;
            joinInfo.remoteField = foreignRefField;
            return;
        }
        for (FieldType fieldType : joinedQueryBuilder.tableInfo.getFieldTypes()) {
            if (!fieldType.isForeign() || !fieldType.getForeignIdField().equals(this.idField)) continue;
            joinInfo.localField = this.idField;
            joinInfo.remoteField = fieldType;
            return;
        }
        throw new SQLException("Could not find a foreign " + this.tableInfo.getDataClass() + " field in " + joinedQueryBuilder.tableInfo.getDataClass() + " or vice versa");
    }

    private void addSelectColumnToList(String columnName) {
        this.verifyColumnName(columnName);
        this.addSelectToList(ColumnNameOrRawSql.withColumnName(columnName));
    }

    private void addSelectToList(ColumnNameOrRawSql select) {
        if (this.selectList == null) {
            this.selectList = new ArrayList<ColumnNameOrRawSql>();
        }
        this.selectList.add(select);
    }

    private void appendJoinSql(StringBuilder sb) {
        for (JoinInfo joinInfo : this.joinList) {
            sb.append(joinInfo.type.sql).append(" JOIN ");
            this.databaseType.appendEscapedEntityName(sb, joinInfo.queryBuilder.tableName);
            if (joinInfo.queryBuilder.alias != null) {
                super.appendAlias(sb);
            }
            sb.append(" ON ");
            this.appendTableQualifier(sb);
            sb.append('.');
            this.databaseType.appendEscapedEntityName(sb, joinInfo.localField.getColumnName());
            sb.append(" = ");
            joinInfo.queryBuilder.appendTableQualifier(sb);
            sb.append('.');
            this.databaseType.appendEscapedEntityName(sb, joinInfo.remoteField.getColumnName());
            sb.append(' ');
            if (joinInfo.queryBuilder.joinList == null) continue;
            super.appendJoinSql(sb);
        }
    }

    private void appendSelects(StringBuilder sb) {
        this.type = StatementBuilder.StatementType.SELECT;
        if (this.selectList == null) {
            if (this.addTableName) {
                this.appendTableQualifier(sb);
                sb.append('.');
            }
            sb.append("* ");
            this.resultFieldTypes = this.tableInfo.getFieldTypes();
            return;
        }
        boolean first = true;
        boolean hasId = this.isInnerQuery;
        ArrayList<FieldType> fieldTypeList = new ArrayList<FieldType>(this.selectList.size() + 1);
        for (ColumnNameOrRawSql select : this.selectList) {
            if (select.getRawSql() != null) {
                this.type = StatementBuilder.StatementType.SELECT_RAW;
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(select.getRawSql());
                continue;
            }
            FieldType fieldType = this.tableInfo.getFieldTypeByColumnName(select.getColumnName());
            if (fieldType.isForeignCollection()) {
                fieldTypeList.add(fieldType);
                continue;
            }
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            this.appendFieldColumnName(sb, fieldType, fieldTypeList);
            if (fieldType != this.idField) continue;
            hasId = true;
        }
        if (this.type != StatementBuilder.StatementType.SELECT_RAW) {
            if (!hasId && this.selectIdColumn) {
                if (!first) {
                    sb.append(',');
                }
                this.appendFieldColumnName(sb, this.idField, fieldTypeList);
            }
            this.resultFieldTypes = fieldTypeList.toArray(new FieldType[fieldTypeList.size()]);
        }
        sb.append(' ');
    }

    private void appendFieldColumnName(StringBuilder sb, FieldType fieldType, List<FieldType> fieldTypeList) {
        this.appendColumnName(sb, fieldType.getColumnName());
        if (fieldTypeList != null) {
            fieldTypeList.add(fieldType);
        }
    }

    private void appendLimit(StringBuilder sb) {
        if (this.limit != null && this.databaseType.isLimitSqlSupported()) {
            this.databaseType.appendLimitValue(sb, this.limit, this.offset);
        }
    }

    private void appendOffset(StringBuilder sb) throws SQLException {
        if (this.offset == null) {
            return;
        }
        if (this.databaseType.isOffsetLimitArgument()) {
            if (this.limit == null) {
                throw new SQLException("If the offset is specified, limit must also be specified with this database");
            }
        } else {
            this.databaseType.appendOffsetValue(sb, this.offset);
        }
    }

    private boolean maybeAppendGroupBys(StringBuilder sb, boolean first) {
        if (this.groupByList != null && !this.groupByList.isEmpty()) {
            this.appendGroupBys(sb, first);
            first = false;
        }
        if (this.joinList != null) {
            for (JoinInfo joinInfo : this.joinList) {
                first = super.maybeAppendGroupBys(sb, first);
            }
        }
        return first;
    }

    private void appendGroupBys(StringBuilder sb, boolean first) {
        if (first) {
            sb.append("GROUP BY ");
        }
        for (ColumnNameOrRawSql groupBy : this.groupByList) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            if (groupBy.getRawSql() == null) {
                this.appendColumnName(sb, groupBy.getColumnName());
                continue;
            }
            sb.append(groupBy.getRawSql());
        }
        sb.append(' ');
    }

    private boolean maybeAppendOrderBys(StringBuilder sb, List<ArgumentHolder> argList, boolean first) {
        if (this.orderByList != null && !this.orderByList.isEmpty()) {
            this.appendOrderBys(sb, first, argList);
            first = false;
        }
        if (this.joinList != null) {
            for (JoinInfo joinInfo : this.joinList) {
                first = super.maybeAppendOrderBys(sb, argList, first);
            }
        }
        return first;
    }

    private void appendOrderBys(StringBuilder sb, boolean first, List<ArgumentHolder> argList) {
        if (first) {
            sb.append("ORDER BY ");
        }
        for (OrderBy orderBy : this.orderByList) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            if (orderBy.getRawSql() == null) {
                this.appendColumnName(sb, orderBy.getColumnName());
                if (orderBy.isAscending()) continue;
                sb.append(" DESC");
                continue;
            }
            sb.append(orderBy.getRawSql());
            if (orderBy.getOrderByArgs() == null) continue;
            for (ArgumentHolder arg : orderBy.getOrderByArgs()) {
                argList.add(arg);
            }
        }
        sb.append(' ');
    }

    private void appendColumnName(StringBuilder sb, String columnName) {
        if (this.addTableName) {
            this.appendTableQualifier(sb);
            sb.append('.');
        }
        this.databaseType.appendEscapedEntityName(sb, columnName);
    }

    private void maybeAppendHaving(StringBuilder sb) {
        if (this.having != null) {
            sb.append("HAVING ").append(this.having).append(' ');
        }
    }

    private void appendAlias(StringBuilder sb) {
        sb.append(" AS ");
        this.databaseType.appendEscapedEntityName(sb, this.alias);
    }

    public static enum JoinWhereOperation {
        AND(StatementBuilder.WhereOperation.AND),
        OR(StatementBuilder.WhereOperation.OR);

        final StatementBuilder.WhereOperation whereOperation;

        private JoinWhereOperation(StatementBuilder.WhereOperation whereOperation) {
            this.whereOperation = whereOperation;
        }
    }

    public static enum JoinType {
        INNER("INNER"),
        LEFT("LEFT");

        final String sql;

        private JoinType(String sql) {
            this.sql = sql;
        }
    }

    public static class InternalQueryBuilderWrapper {
        private final QueryBuilder<?, ?> queryBuilder;

        InternalQueryBuilderWrapper(QueryBuilder<?, ?> queryBuilder) {
            this.queryBuilder = queryBuilder;
        }

        public void appendStatementString(StringBuilder sb, List<ArgumentHolder> argList) throws SQLException {
            this.queryBuilder.appendStatementString(sb, argList);
        }

        public FieldType[] getResultFieldTypes() {
            return this.queryBuilder.getResultFieldTypes();
        }
    }

    private static class JoinInfo {
        final JoinType type;
        final QueryBuilder<?, ?> queryBuilder;
        FieldType localField;
        FieldType remoteField;
        JoinWhereOperation operation;

        public JoinInfo(JoinType type, QueryBuilder<?, ?> queryBuilder, JoinWhereOperation operation) {
            this.type = type;
            this.queryBuilder = queryBuilder;
            this.operation = operation;
        }
    }
}

