/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.ORMlite.db;

import com.Acrobot.ChestShop.ORMlite.db.BaseDatabaseType;
import com.Acrobot.ChestShop.ORMlite.field.BaseFieldConverter;
import com.Acrobot.ChestShop.ORMlite.field.DataPersister;
import com.Acrobot.ChestShop.ORMlite.field.FieldConverter;
import com.Acrobot.ChestShop.ORMlite.field.FieldType;
import com.Acrobot.ChestShop.ORMlite.field.SqlType;
import com.Acrobot.ChestShop.ORMlite.misc.IOUtils;
import com.Acrobot.ChestShop.ORMlite.misc.SqlExceptionUtil;
import com.Acrobot.ChestShop.ORMlite.support.DatabaseResults;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;

public class DerbyEmbeddedDatabaseType
extends BaseDatabaseType {
    protected static final String DATABASE_URL_PORTION = "derby";
    private static final String DRIVER_CLASS_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String DATABASE_NAME = "Derby";
    private static FieldConverter serializableConverter;
    private static FieldConverter booleanConverter;
    private static FieldConverter charConverter;

    @Override
    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        if (!DATABASE_URL_PORTION.equals(dbTypePart)) {
            return false;
        }
        String[] parts = url.split(":");
        return parts.length >= 3 && !parts[2].startsWith("//");
    }

    @Override
    protected String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    @Override
    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    @Override
    public FieldConverter getFieldConverter(DataPersister dataType, FieldType fieldType) {
        switch (dataType.getSqlType()) {
            case BOOLEAN: {
                if (booleanConverter == null) {
                    booleanConverter = new BaseDatabaseType.BooleanNumberFieldConverter();
                }
                return booleanConverter;
            }
            case CHAR: {
                if (charConverter == null) {
                    charConverter = new CharFieldConverter();
                }
                return charConverter;
            }
            case SERIALIZABLE: {
                if (serializableConverter == null) {
                    serializableConverter = new SerializableFieldConverter();
                }
                return serializableConverter;
            }
        }
        return super.getFieldConverter(dataType, fieldType);
    }

    @Override
    protected void appendLongStringType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("LONG VARCHAR");
    }

    @Override
    public void appendOffsetValue(StringBuilder sb, long offset) {
        sb.append("OFFSET ").append(offset).append(" ROWS ");
    }

    @Override
    protected void appendBooleanType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendCharType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendByteType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendByteArrayType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("LONG VARCHAR FOR BIT DATA");
    }

    @Override
    protected void configureGeneratedId(String tableName, StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter, List<String> additionalArgs, List<String> queriesAfter) {
        sb.append("GENERATED BY DEFAULT AS IDENTITY ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    @Override
    public void appendEscapedEntityName(StringBuilder sb, String name) {
        sb.append('\"').append(name).append('\"');
    }

    @Override
    public boolean isLimitSqlSupported() {
        return false;
    }

    @Override
    public String getPingStatement() {
        return "SELECT 1 FROM SYSIBM.SYSDUMMY1";
    }

    @Override
    public boolean isEntityNamesMustBeUpCase() {
        return true;
    }

    @Override
    public boolean isAllowGeneratedIdInsertSupported() {
        return false;
    }

    @Override
    public void appendInsertNoColumns(StringBuilder sb) {
        sb.append("VALUES(DEFAULT)");
    }

    private static class CharFieldConverter
    extends BaseFieldConverter {
        private CharFieldConverter() {
        }

        @Override
        public SqlType getSqlType() {
            return SqlType.INTEGER;
        }

        @Override
        public Object javaToSqlArg(FieldType fieldType, Object javaObject) {
            char character = ((Character)javaObject).charValue();
            return (int)character;
        }

        @Override
        public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
            if (defaultStr.length() != 1) {
                throw new SQLException("Problems with field " + fieldType + ", default string to long: '" + defaultStr + "'");
            }
            return (int)defaultStr.charAt(0);
        }

        @Override
        public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getInt(columnPos);
        }

        @Override
        public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
            int intVal = (Integer)sqlArg;
            return Character.valueOf((char)intVal);
        }

        @Override
        public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) {
            return this.sqlArgToJava(fieldType, Integer.parseInt(stringValue), columnPos);
        }
    }

    private static class SerializableFieldConverter
    extends BaseFieldConverter {
        private SerializableFieldConverter() {
        }

        @Override
        public SqlType getSqlType() {
            return SqlType.BLOB;
        }

        @Override
        public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
            throw new SQLException("Default values for serializable types are not supported");
        }

        @Override
        public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getBlobStream(columnPos);
        }

        @Override
        public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
            InputStream stream = (InputStream)sqlArg;
            try {
                ObjectInputStream objInStream = new ObjectInputStream(stream);
                Object object = objInStream.readObject();
                return object;
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Could not read serialized object from result blob", e);
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }

        @Override
        public Object javaToSqlArg(FieldType fieldType, Object javaObject) throws SQLException {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objOutStream = new ObjectOutputStream(outStream);
                objOutStream.writeObject(javaObject);
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Could not write serialized object to output stream", e);
            }
            return new SerialBlob(outStream.toByteArray());
        }

        @Override
        public boolean isStreamType() {
            return true;
        }

        @Override
        public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) throws SQLException {
            throw new SQLException("Parsing string value for serializable types is not supported");
        }
    }
}

