/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Economy.Plugins;

import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Events.Economy.AccountCheckEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyAddEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyAmountEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyCheckEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyFormatEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyHoldEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencySubtractEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyTransferEvent;
import java.math.BigDecimal;
import java.util.UUID;
import javax.annotation.Nullable;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultListener
implements Listener {
    private final Economy provider;

    private VaultListener(Economy provider) {
        this.provider = provider;
    }

    public boolean transactionCanFail() {
        return this.provider.getName().equals("Gringotts") || this.provider.getName().equals("GoldIsMoney") || this.provider.getName().equals("MultiCurrency");
    }

    @Nullable
    public static VaultListener initializeVault() {
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            return null;
        }
        RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return null;
        }
        Economy provider = (Economy)rsp.getProvider();
        if (provider == null) {
            return null;
        }
        return new VaultListener(provider);
    }

    @EventHandler
    public void onAmountCheck(CurrencyAmountEvent event) {
        if (!event.getAmount().equals(BigDecimal.ZERO)) {
            return;
        }
        double balance = this.provider.getBalance(Bukkit.getOfflinePlayer((UUID)event.getAccount()), event.getWorld().getName());
        if (balance > Double.MAX_VALUE) {
            balance = Double.MAX_VALUE;
        }
        event.setAmount(BigDecimal.valueOf(balance));
    }

    @EventHandler
    public void onCurrencyCheck(CurrencyCheckEvent event) {
        if (event.hasEnough()) {
            return;
        }
        World world = event.getWorld();
        if (this.provider.has(Bukkit.getOfflinePlayer((UUID)event.getAccount()), world.getName(), event.getAmount().doubleValue())) {
            event.hasEnough(true);
        }
    }

    @EventHandler
    public void onAccountCheck(AccountCheckEvent event) {
        if (event.hasAccount()) {
            return;
        }
        World world = event.getWorld();
        if (!this.provider.hasAccount(Bukkit.getOfflinePlayer((UUID)event.getAccount()), world.getName())) {
            event.hasAccount(false);
        }
    }

    @EventHandler
    public void onCurrencyFormat(CurrencyFormatEvent event) {
        if (!event.getFormattedAmount().isEmpty()) {
            return;
        }
        String formatted = this.provider.format(event.getAmount().doubleValue());
        event.setFormattedAmount(formatted);
    }

    @EventHandler
    public void onCurrencyAdd(CurrencyAddEvent event) {
        if (event.isAdded()) {
            return;
        }
        World world = event.getWorld();
        this.provider.depositPlayer(Bukkit.getOfflinePlayer((UUID)event.getTarget()), world.getName(), event.getAmount().doubleValue());
    }

    @EventHandler
    public void onCurrencySubtraction(CurrencySubtractEvent event) {
        if (event.isSubtracted()) {
            return;
        }
        World world = event.getWorld();
        this.provider.withdrawPlayer(Bukkit.getOfflinePlayer((UUID)event.getTarget()), world.getName(), event.getAmount().doubleValue());
    }

    @EventHandler
    public static void onCurrencyTransfer(CurrencyTransferEvent event) {
        if (event.hasBeenTransferred()) {
            return;
        }
        CurrencySubtractEvent currencySubtractEvent = new CurrencySubtractEvent(event.getAmount(), event.getSender(), event.getWorld());
        ChestShop.callEvent(currencySubtractEvent);
        if (!currencySubtractEvent.isSubtracted()) {
            return;
        }
        CurrencyAddEvent currencyAddEvent = new CurrencyAddEvent(currencySubtractEvent.getAmount(), event.getReceiver(), event.getWorld());
        ChestShop.callEvent(currencyAddEvent);
    }

    @EventHandler
    public void onCurrencyHoldCheck(CurrencyHoldEvent event) {
        if (event.getAccount() == null || !this.transactionCanFail()) {
            return;
        }
        if (!this.provider.hasAccount(Bukkit.getOfflinePlayer((UUID)event.getAccount()), event.getWorld().getName())) {
            event.canHold(false);
            return;
        }
        EconomyResponse response = this.provider.depositPlayer(Bukkit.getOfflinePlayer((UUID)event.getAccount()), event.getWorld().getName(), event.getAmount().doubleValue());
        if (!response.transactionSuccess()) {
            event.canHold(false);
            return;
        }
        this.provider.withdrawPlayer(Bukkit.getOfflinePlayer((UUID)event.getAccount()), event.getWorld().getName(), event.getAmount().doubleValue());
    }
}

