/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Database;

import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Database.ConnectionManager;
import com.Acrobot.ChestShop.Database.DatabaseFileName;
import com.Acrobot.ChestShop.ORMlite.dao.Dao;
import com.Acrobot.ChestShop.ORMlite.dao.DaoManager;
import com.Acrobot.ChestShop.ORMlite.dao.LruObjectCache;
import com.Acrobot.ChestShop.ORMlite.db.SqliteDatabaseType;
import com.Acrobot.ChestShop.ORMlite.jdbc.JdbcConnectionSource;
import com.Acrobot.ChestShop.ORMlite.support.ConnectionSource;
import com.Acrobot.ChestShop.ORMlite.table.TableUtils;
import java.security.InvalidParameterException;
import java.sql.SQLException;

public class DaoCreator {
    public static <ENTITY, ID> Dao<ENTITY, ID> getDao(Class<ENTITY> entity) throws InvalidParameterException, SQLException {
        if (!entity.isAnnotationPresent(DatabaseFileName.class)) {
            throw new InvalidParameterException("Entity not annotated with @DatabaseFileName!");
        }
        String fileName = entity.getAnnotation(DatabaseFileName.class).value();
        String uri = ConnectionManager.getURI(ChestShop.loadFile(fileName));
        JdbcConnectionSource connectionSource = new JdbcConnectionSource(uri, new SqliteDatabaseType());
        Object dao = DaoManager.createDao((ConnectionSource)connectionSource, entity);
        dao.setObjectCache(new LruObjectCache(200));
        return dao;
    }

    public static <ENTITY, ID> Dao<ENTITY, ID> getDaoAndCreateTable(Class<ENTITY> entity) throws SQLException, InvalidParameterException {
        Dao<ENTITY, ID> dao = DaoCreator.getDao(entity);
        TableUtils.createTableIfNotExists(dao.getConnectionSource(), entity);
        return dao;
    }
}

