/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreTransaction;

import com.Acrobot.Breeze.Utils.InventoryUtil;
import com.Acrobot.ChestShop.Events.PreTransactionEvent;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class StockFittingChecker
implements Listener {
    @EventHandler
    public static void onSellCheck(PreTransactionEvent event) {
        if (event.isCancelled() || event.getTransactionType() != TransactionEvent.TransactionType.SELL) {
            return;
        }
        Inventory shopInventory = event.getOwnerInventory();
        ItemStack[] stock = event.getStock();
        if (!StockFittingChecker.itemsFitInInventory(stock, shopInventory)) {
            event.setCancelled(PreTransactionEvent.TransactionOutcome.NOT_ENOUGH_SPACE_IN_CHEST);
        }
    }

    @EventHandler
    public static void onBuyCheck(PreTransactionEvent event) {
        if (event.isCancelled() || event.getTransactionType() != TransactionEvent.TransactionType.BUY) {
            return;
        }
        Inventory clientInventory = event.getClientInventory();
        ItemStack[] stock = event.getStock();
        if (!StockFittingChecker.itemsFitInInventory(stock, clientInventory)) {
            event.setCancelled(PreTransactionEvent.TransactionOutcome.NOT_ENOUGH_SPACE_IN_INVENTORY);
        }
    }

    private static boolean itemsFitInInventory(ItemStack[] items, Inventory inventory) {
        for (ItemStack item : items) {
            if (InventoryUtil.fits(item, inventory)) continue;
            return false;
        }
        return true;
    }
}

