/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreShopCreation;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Utils.uBlock;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class ItemChecker
implements Listener {
    private static final String AUTOFILL_CODE = "?";

    @EventHandler(priority=EventPriority.LOWEST)
    public static void onPreShopCreation(PreShopCreationEvent event) {
        String itemCode = event.getSignLine((byte)3);
        ItemStack item = MaterialUtil.getItem(itemCode);
        if (item == null) {
            boolean foundItem = false;
            if (Properties.ALLOW_AUTO_ITEM_FILL && itemCode.equals(AUTOFILL_CODE) && uBlock.findConnectedChest(event.getSign()) != null) {
                for (ItemStack stack : uBlock.findConnectedChest(event.getSign()).getInventory().getContents()) {
                    if (MaterialUtil.isEmpty(stack)) continue;
                    item = stack;
                    itemCode = MaterialUtil.getSignName(stack);
                    event.setSignLine((byte)3, itemCode);
                    foundItem = true;
                    break;
                }
            }
            if (!foundItem) {
                event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_ITEM);
                return;
            }
        }
        String metadata = ItemChecker.getMetadata(itemCode);
        String itemName = MaterialUtil.getSignMaterialName(item.getType(), metadata);
        if (ItemChecker.isSameItem(itemName + metadata, item)) {
            event.setSignLine((byte)3, itemName + metadata);
            return;
        }
        event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_ITEM);
    }

    private static boolean isSameItem(String newCode, ItemStack item) {
        ItemStack newItem = MaterialUtil.getItem(newCode);
        return newItem != null && newItem.isSimilar(item);
    }

    private static String getMetadata(String itemCode) {
        String metaCode = MaterialUtil.Metadata.getMetaCodeFromItemCode(itemCode);
        if (metaCode != null) {
            return "#" + metaCode;
        }
        return "";
    }
}

