/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Block.Break;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.ShopDestroyedEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.UUIDs.NameManager;
import com.Acrobot.ChestShop.Utils.uBlock;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class SignBreak
implements Listener {
    private static final BlockFace[] SIGN_CONNECTION_FACES = new BlockFace[]{BlockFace.SOUTH, BlockFace.NORTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP};
    private static final String METADATA_NAME = "shop_destroyer";

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public static void onSign(BlockPhysicsEvent event) {
        Block block = event.getBlock();
        if (!BlockUtil.isSign(block)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        Block attachedBlock = BlockUtil.getAttachedBlock(sign);
        if (attachedBlock.getType() == Material.AIR && ChestShopSign.isValid(sign)) {
            if (!block.hasMetadata(METADATA_NAME)) {
                return;
            }
            SignBreak.sendShopDestroyedEvent(sign, (Player)((MetadataValue)block.getMetadata(METADATA_NAME).get(0)).value());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public static void onSignBreak(BlockBreakEvent event) {
        if (!SignBreak.canBlockBeBroken(event.getBlock(), event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public static void onBrokenSign(BlockBreakEvent event) {
        if (ChestShopSign.isValid(event.getBlock())) {
            SignBreak.sendShopDestroyedEvent((Sign)event.getBlock().getState(), event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public static void onBlockPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            if (SignBreak.canBlockBeBroken(block, null)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public static void onBlockPistonRetract(BlockPistonRetractEvent event) {
        for (Block block : event.getBlocks()) {
            if (SignBreak.canBlockBeBroken(block, null)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public static void onExplosion(EntityExplodeEvent event) {
        if (event.blockList() == null || !Properties.USE_BUILT_IN_PROTECTION) {
            return;
        }
        for (Block block : event.blockList()) {
            if (SignBreak.canBlockBeBroken(block, null)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public static void onIgnite(BlockBurnEvent event) {
        if (!SignBreak.canBlockBeBroken(event.getBlock(), null)) {
            event.setCancelled(true);
        }
    }

    public static boolean canBlockBeBroken(Block block, Player breaker) {
        List<Sign> attachedSigns = SignBreak.getAttachedSigns(block);
        LinkedList<Sign> brokenBlocks = new LinkedList<Sign>();
        boolean canBeBroken = true;
        for (Sign sign : attachedSigns) {
            if (!canBeBroken || !ChestShopSign.isValid(sign)) continue;
            if (Properties.TURN_OFF_SIGN_PROTECTION || SignBreak.canDestroyShop(breaker, sign.getLine(0))) {
                brokenBlocks.add(sign);
                continue;
            }
            canBeBroken = false;
        }
        if (!canBeBroken) {
            return false;
        }
        for (Sign sign : brokenBlocks) {
            sign.setMetadata(METADATA_NAME, (MetadataValue)new FixedMetadataValue((Plugin)ChestShop.getPlugin(), (Object)breaker));
        }
        return true;
    }

    private static boolean canDestroyShop(Player player, String name) {
        return player != null && (SignBreak.hasShopBreakingPermission(player) || NameManager.canUseName(player, name));
    }

    private static boolean hasShopBreakingPermission(Player player) {
        return Permission.has((CommandSender)player, Permission.ADMIN) || Permission.has((CommandSender)player, Permission.MOD);
    }

    private static void sendShopDestroyedEvent(Sign sign, Player player) {
        Chest connectedChest = null;
        if (!ChestShopSign.isAdminShop(sign)) {
            connectedChest = uBlock.findConnectedChest(sign);
        }
        ShopDestroyedEvent event = new ShopDestroyedEvent(player, sign, connectedChest);
        ChestShop.callEvent(event);
    }

    private static List<Sign> getAttachedSigns(Block block) {
        if (block == null) {
            return Lists.newArrayList();
        }
        if (BlockUtil.isSign(block)) {
            return Collections.singletonList((Sign)block.getState());
        }
        LinkedList<Sign> attachedSigns = new LinkedList<Sign>();
        for (BlockFace face : SIGN_CONNECTION_FACES) {
            Sign sign;
            Block relative = block.getRelative(face);
            if (!BlockUtil.isSign(relative) || !BlockUtil.getAttachedBlock(sign = (Sign)relative.getState()).equals(block)) continue;
            attachedSigns.add(sign);
        }
        return attachedSigns;
    }
}

