/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreShopCreation;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Permission;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class PermissionChecker
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public static void onPreShopCreation(PreShopCreationEvent event) {
        Player player = event.getPlayer();
        if (Permission.has((CommandSender)player, Permission.ADMIN)) {
            return;
        }
        String priceLine = event.getSignLine((byte)2);
        String itemLine = event.getSignLine((byte)3);
        ItemStack item = MaterialUtil.getItem(itemLine);
        if (item == null || Permission.has((CommandSender)player, (Object)((Object)Permission.SHOP_CREATION_ID) + item.getType().name().toLowerCase())) {
            return;
        }
        if (PriceUtil.hasBuyPrice(priceLine) && !Permission.has((CommandSender)player, Permission.SHOP_CREATION_BUY)) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.NO_PERMISSION);
            return;
        }
        if (PriceUtil.hasSellPrice(priceLine) && !Permission.has((CommandSender)player, Permission.SHOP_CREATION_SELL)) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.NO_PERMISSION);
        }
    }
}

