/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.ItemNaming;

import com.Acrobot.Breeze.Utils.EnchantmentNames;
import com.Acrobot.Breeze.Utils.NumberUtil;
import com.Acrobot.Breeze.Utils.PotionNames;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Events.PreShopCreationItemDisplayNameEvent;
import com.Acrobot.ChestShop.ItemNaming.ChestShopEnchantedBookDisplayNameShortener;
import com.Acrobot.ChestShop.ItemNaming.ChestShopItemDisplayNameShortener;
import com.Acrobot.ChestShop.ItemNaming.ItemDisplayNameShortener;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MusicInstrumentMeta;
import org.bukkit.inventory.meta.OminousBottleMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class ItemNamingUtils {
    private static final ItemDisplayNameShortener CHEST_SHOP_ITEM_DISPLAY_NAME_SHORTENER = new ChestShopItemDisplayNameShortener();
    private static final ItemDisplayNameShortener CHEST_SHOP_ENCHANTED_BOOK_DISPLAY_NAME_SHORTENER = new ChestShopEnchantedBookDisplayNameShortener();
    private static final HashMap<String, Material> materialNameToMaterial = new HashMap();

    public static Material getItemFromSignName(String name) {
        return materialNameToMaterial.get(name.toLowerCase());
    }

    public static String getSignItemName(ItemStack itemStack) {
        return ItemNamingUtils.getDisplayName(itemStack, 15);
    }

    public static String getDisplayName(ItemStack itemStack) {
        return ItemNamingUtils.getDisplayName(itemStack, Integer.MAX_VALUE);
    }

    public static String getDisplayName(ItemStack itemStack, int length) {
        Component customItemName;
        OminousBottleMeta ominousBottleMeta;
        if (itemStack == null) {
            return null;
        }
        ItemDisplayNameShortener extraShortener = null;
        Material type = itemStack.getType();
        Object itemName = StringUtil.capitalizeFirstLetter(type.name(), '_');
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof MusicInstrumentMeta) {
            NamespacedKey instrumentKey;
            MusicInstrumentMeta musicInstrumentMeta = (MusicInstrumentMeta)itemMeta;
            MusicInstrument instrumentType = musicInstrumentMeta.getInstrument();
            if (instrumentType == null) {
                instrumentType = MusicInstrument.PONDER_GOAT_HORN;
            }
            String instrument = (instrumentKey = RegistryAccess.registryAccess().getRegistry(RegistryKey.INSTRUMENT).getKey((Keyed)instrumentType)) == null ? "(unknown instrument)" : StringUtil.capitalizeFirstLetter(instrumentKey.getKey().replace("_goat_horn", ""));
            itemName = (String)itemName + " " + instrument;
        } else if (itemMeta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)itemMeta;
            itemName = PotionNames.getName(potionMeta.getBasePotionType()).replace("Potion", (CharSequence)itemName);
        } else if (itemMeta instanceof FireworkMeta) {
            FireworkMeta fireworkMeta = (FireworkMeta)itemMeta;
            if (fireworkMeta.getEffectsSize() == 0) {
                itemName = "Rocket Strength " + (fireworkMeta.getPower() == 0 ? 1 : fireworkMeta.getPower());
            }
        } else if (itemMeta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta;
            Map enchants = enchantmentStorageMeta.getStoredEnchants();
            if (enchants.size() == 1) {
                Map.Entry enchantmentAndLevel = enchants.entrySet().iterator().next();
                Enchantment enchantment = (Enchantment)enchantmentAndLevel.getKey();
                int level = (Integer)enchantmentAndLevel.getValue();
                itemName = (String)itemName + " " + StringUtil.capitalizeFirstLetter(ChatColor.stripColor((String)EnchantmentNames.getName(enchantment))) + (String)(enchantment.getMaxLevel() > 1 || level != 1 ? " " + NumberUtil.toRoman(level) : "");
                extraShortener = CHEST_SHOP_ENCHANTED_BOOK_DISPLAY_NAME_SHORTENER;
            } else {
                itemName = (String)itemName + " " + enchants.size() + " Enchantments";
            }
        } else if (itemMeta instanceof OminousBottleMeta && (ominousBottleMeta = (OminousBottleMeta)itemMeta).hasAmplifier()) {
            itemName = (String)itemName + " " + NumberUtil.toRoman(ominousBottleMeta.getAmplifier() + 1);
        }
        if (itemStack.isDataOverridden((DataComponentType)DataComponentTypes.ITEM_NAME) && (customItemName = (Component)itemStack.getData(DataComponentTypes.ITEM_NAME)) != null) {
            itemName = StringUtil.capitalizeFirstLetter(PlainTextComponentSerializer.plainText().serialize(customItemName));
        }
        boolean needsItalicEffect = false;
        if (itemStack.hasItemMeta() && !itemMeta.equals((Object)new ItemStack(itemStack.getType()).getItemMeta())) {
            needsItalicEffect = true;
        }
        PreShopCreationItemDisplayNameEvent preShopCreationItemDisplayNameEvent = new PreShopCreationItemDisplayNameEvent(itemStack, (String)itemName);
        ChestShop.callEvent(preShopCreationItemDisplayNameEvent);
        itemName = preShopCreationItemDisplayNameEvent.getDisplayName();
        ItemDisplayNameShortener itemDisplayNameShortener = preShopCreationItemDisplayNameEvent.getItemDisplayNameShortener();
        itemName = ItemNamingUtils.shortenDisplayName((String)itemName, length, itemDisplayNameShortener != null ? itemDisplayNameShortener : extraShortener);
        return String.valueOf(needsItalicEffect ? ChatColor.ITALIC : "") + ((String)itemName).substring(0, Math.min(((String)itemName).length(), length));
    }

    public static String shortenDisplayName(String name, int length) {
        return ItemNamingUtils.shortenDisplayName(name, length, null);
    }

    public static String shortenDisplayName(String name, int length, ItemDisplayNameShortener customItemDisplayNameShortener) {
        String word;
        String result = name;
        if (result.length() <= length) {
            return name;
        }
        if (customItemDisplayNameShortener != null && (result = customItemDisplayNameShortener.shorten(result, length)).length() <= length) {
            return result;
        }
        if ((result = CHEST_SHOP_ITEM_DISPLAY_NAME_SHORTENER.shorten(result, length)).length() <= length) {
            return result;
        }
        String[] words = result.split(" ");
        CharSequence[] shortenedWords = new String[words.length];
        int remainingLetters = length;
        int lettersPerWord = length / words.length;
        for (int i = 0; i < words.length; ++i) {
            word = words[i];
            int letters = Math.min(lettersPerWord, word.length());
            shortenedWords[i] = word.substring(0, letters);
            remainingLetters -= letters;
        }
        int currentWord = -1;
        while (remainingLetters > 0) {
            CharSequence shortened;
            if (++currentWord >= words.length) {
                currentWord = 0;
            }
            if ((word = words[currentWord]).equals(shortened = shortenedWords[currentWord])) continue;
            shortenedWords[currentWord] = (String)shortened + word.charAt(((String)shortened).length());
            --remainingLetters;
        }
        return String.join((CharSequence)"", shortenedWords);
    }

    static {
        try {
            for (Material m : Material.values()) {
                if (!m.isItem()) continue;
                String name = ItemNamingUtils.getSignItemName(new ItemStack(m));
                materialNameToMaterial.putIfAbsent(name.toLowerCase(), m);
            }
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            // empty catch block
        }
    }
}

