/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Commands;

import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.util.RayTraceResult;

public class SetItem
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (!Permission.has(sender, Permission.SET_ITEM_COMMAND)) {
            sender.sendMessage(Messages.ACCESS_DENIED);
            return true;
        }
        RayTraceResult result = player.rayTraceBlocks(8.0);
        Block signBlock = null;
        if (result != null) {
            signBlock = result.getHitBlock();
        }
        if (signBlock == null || !ChestShopSign.isChestShop(signBlock)) {
            sender.sendMessage(Messages.MUST_LOOK_AT_SHOP_SIGN);
            return true;
        }
        Sign sign = (Sign)signBlock.getState();
        if (!ChestShopSign.canAccess((OfflinePlayer)player, sign) && !Permission.has((CommandSender)player, Permission.ADMIN)) {
            sender.sendMessage(Messages.ACCESS_DENIED);
            return true;
        }
        String newItemLine = String.join((CharSequence)" ", args);
        ArrayList<Component> line = new ArrayList<Component>(sign.getSide(Side.FRONT).lines());
        line.set(3, (Component)Component.text((String)newItemLine));
        if (!ChestShopSign.isValidPreparedSign(line)) {
            sender.sendMessage(Messages.INVALID_ITEM_LINE);
            return true;
        }
        SignChangeEvent event = new SignChangeEvent(signBlock, player, line, Side.FRONT);
        ChestShop.getPlugin().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            sender.sendMessage(Messages.SHOP_UPDATE_FAILED);
            return true;
        }
        return true;
    }
}

