/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Signs;

import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.ItemNaming.ItemNamingUtils;
import com.Acrobot.ChestShop.Signs.ChestShopMetaData;
import com.Acrobot.ChestShop.UUIDs.NameManager;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.TileState;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ChestShopSign {
    public static final byte NAME_LINE = 0;
    public static final byte QUANTITY_LINE = 1;
    public static final byte PRICE_LINE = 2;
    public static final byte ITEM_LINE = 3;
    public static final Pattern[] SHOP_SIGN_PATTERN = new Pattern[]{Pattern.compile("^?[\\w -.]*$"), Pattern.compile("^[1-9][0-9]{0,4}(?: )*(?:x(?: )*\\!?|\\!(?: )*x?)?$"), Pattern.compile("(?i)^[\\d.bs(free) :]+$")};
    private static NamespacedKey METADATA_NAMESPACED_KEY;

    public static void createNamespacedKeys(ChestShop chestShop) {
        METADATA_NAMESPACED_KEY = new NamespacedKey((Plugin)chestShop, "metadata");
    }

    public static boolean isAdminShop(Sign sign) {
        if (!ChestShopSign.isChestShop(sign)) {
            return false;
        }
        return ChestShopSign.getChestShopMetaData(sign).isAdminshop();
    }

    public static boolean canAccess(OfflinePlayer player, Sign sign) {
        if (player == null) {
            return false;
        }
        if (sign == null) {
            return true;
        }
        if (ChestShopSign.isOwner(player, sign)) {
            return true;
        }
        return ChestShopSign.isAccessor(player, sign);
    }

    public static boolean isOwner(OfflinePlayer player, Sign sign) {
        return ChestShopSign.getChestShopMetaData(sign).isOwner(player.getUniqueId());
    }

    public static UUID getOwner(Sign sign) {
        if (!ChestShopSign.isChestShop(sign)) {
            return null;
        }
        ChestShopMetaData chestShopMetaData = ChestShopSign.getChestShopMetaData(sign);
        return chestShopMetaData.getOwner();
    }

    public static ItemStack getItemStack(Sign sign) {
        if (!ChestShopSign.isChestShop(sign)) {
            return null;
        }
        ChestShopMetaData chestShopMetaData = ChestShopSign.getChestShopMetaData(sign);
        return chestShopMetaData.getItemStack();
    }

    public static void addAccessor(UUID player, Sign sign) {
        ChestShopMetaData chestShopMetaData = ChestShopSign.getChestShopMetaData(sign);
        chestShopMetaData.addAccessor(player);
        ChestShopSign.saveChestShopMetaData(sign, chestShopMetaData);
    }

    public static boolean isAccessor(OfflinePlayer player, Sign sign) {
        return ChestShopSign.isAccessor(player.getUniqueId(), sign);
    }

    public static boolean isAccessor(UUID player, Sign sign) {
        ChestShopMetaData chestShopMetaData = ChestShopSign.getChestShopMetaData(sign);
        return chestShopMetaData.isAccessor(player);
    }

    public static void removeAccessor(UUID accessor, Sign sign) {
        ChestShopMetaData chestShopMetaData = ChestShopSign.getChestShopMetaData(sign);
        chestShopMetaData.removeAccessor(accessor);
        ChestShopSign.saveChestShopMetaData(sign, chestShopMetaData);
    }

    public static boolean isChestShop(Block block) {
        BlockState state = block.getState();
        if (!(state instanceof Sign)) {
            return false;
        }
        Sign sign = (Sign)state;
        return ChestShopSign.isChestShop(sign);
    }

    public static boolean isChestShop(Sign sign) {
        return ChestShopSign.isChestShop(sign, false);
    }

    public static boolean isChestShop(Sign sign, boolean updateSign) {
        try {
            boolean isChestshop = sign.getPersistentDataContainer().has(METADATA_NAMESPACED_KEY, PersistentDataType.STRING);
            if (updateSign && isChestshop) {
                isChestshop = ChestShopSign.updateSignDisplay(sign);
            }
            return isChestshop;
        }
        catch (Exception e) {
            ChestShop.getBukkitLogger().log(Level.SEVERE, "Could not load shop info at " + String.valueOf(sign.getLocation()), e);
            return false;
        }
    }

    private static boolean updateSignDisplay(Sign sign) {
        ChestShopMetaData chestShopMetaData = ChestShopSign.getChestShopMetaData(sign);
        if (chestShopMetaData == null || chestShopMetaData.getItemStack() == null) {
            return false;
        }
        UUID owner = chestShopMetaData.getOwner();
        String fullOwnerName = NameManager.getFullNameFor(owner);
        sign.setLine(0, fullOwnerName);
        sign.setLine(3, ItemNamingUtils.getSignItemName(chestShopMetaData.getItemStack()));
        sign.update();
        return true;
    }

    public static ChestShopMetaData getChestShopMetaData(Sign sign) {
        try {
            String string = (String)sign.getPersistentDataContainer().get(METADATA_NAMESPACED_KEY, PersistentDataType.STRING);
            if (string == null) {
                return null;
            }
            YamlConfiguration yamlConfiguration = new YamlConfiguration();
            yamlConfiguration.loadFromString(string);
            ChestShopMetaData metaData = (ChestShopMetaData)yamlConfiguration.get("metadata");
            if (metaData == null) {
                throw new NullPointerException("No metadata in:\n" + string);
            }
            if (metaData.getItemStack() == null) {
                ChestShop.getBukkitLogger().log(Level.WARNING, "No ItemStack found in Shop at: \n" + String.valueOf(sign.getLocation()));
                sign.getPersistentDataContainer().remove(METADATA_NAMESPACED_KEY);
                sign.update();
                return null;
            }
            if (metaData.shouldUpdate()) {
                ChestShopSign.saveChestShopMetaData(sign, metaData);
            }
            return metaData;
        }
        catch (Exception e) {
            ChestShop.getBukkitLogger().log(Level.SEVERE, "Exception loading Chestshop Metadata (" + sign.getX() + " " + sign.getY() + " " + sign.getZ() + ").", e);
            return null;
        }
    }

    public static void saveChestShopMetaData(Sign sign, ChestShopMetaData chestShopMetaData) {
        ChestShopSign.saveChestShopMetaData(sign, chestShopMetaData, false);
    }

    public static void saveChestShopMetaData(Sign sign, ChestShopMetaData chestShopMetaData, boolean delayUpdate) {
        Runnable change = () -> {
            try {
                if (chestShopMetaData == null) {
                    sign.getPersistentDataContainer().remove(METADATA_NAMESPACED_KEY);
                } else {
                    YamlConfiguration yamlConfiguration = new YamlConfiguration();
                    yamlConfiguration.set("metadata", (Object)chestShopMetaData);
                    String string = yamlConfiguration.saveToString();
                    sign.getPersistentDataContainer().set(METADATA_NAMESPACED_KEY, PersistentDataType.STRING, (Object)string);
                }
                SignSide backSide = sign.getSide(Side.BACK);
                backSide.line(0, (Component)Component.empty());
                backSide.line(1, (Component)Component.empty());
                backSide.line(2, (Component)Component.empty());
                backSide.line(3, (Component)Component.empty());
                sign.update();
            }
            catch (Exception e) {
                ChestShop.getBukkitLogger().log(Level.WARNING, "Exception saving Chestshop Metadata (" + sign.getX() + " " + sign.getY() + " " + sign.getZ() + ").", e);
            }
        };
        if (delayUpdate) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)ChestShop.getPlugin(), change, 1L);
        } else {
            change.run();
        }
    }

    public static boolean isValidPreparedSign(String[] lines) {
        for (int i = 0; i < 3; ++i) {
            if (ChestShopSign.isValidPreparedSignLine(i, lines[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPreparedSignLine(int i, String line) {
        if (i != 3 && !SHOP_SIGN_PATTERN[i].matcher(line).matches()) {
            return false;
        }
        return i != 2 || line.indexOf(58) == line.lastIndexOf(58);
    }

    public static boolean isAdminshopLine(String ownerLine) {
        return ownerLine.replace(" ", "").equalsIgnoreCase(Properties.ADMIN_SHOP_NAME.replace(" ", ""));
    }

    public static void removeChestShopMetaData(Block signBlock, boolean delayUpdate) {
        Runnable change = () -> {
            TileState tileState;
            BlockState patt0$temp = signBlock.getState();
            if (patt0$temp instanceof TileState && (tileState = (TileState)patt0$temp).getPersistentDataContainer().has(METADATA_NAMESPACED_KEY)) {
                tileState.getPersistentDataContainer().remove(METADATA_NAMESPACED_KEY);
                tileState.update();
            }
        };
        if (delayUpdate) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)ChestShop.getPlugin(), change, 1L);
        } else {
            change.run();
        }
    }
}

