/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.UUIDs;

import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Database.Account;
import com.Acrobot.ChestShop.Database.Account2;
import com.Acrobot.ChestShop.Database.DaoCreator;
import com.Acrobot.ChestShop.Database.PlayerName;
import com.Acrobot.ChestShop.ORMlite.dao.Dao;
import com.Acrobot.ChestShop.ORMlite.stmt.DeleteBuilder;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class NameManager {
    private static Dao<Account, String> accounts;
    private static Dao<Account2, String> accounts2;
    private static Dao<PlayerName, String> playerNames;
    private static Map<String, UUID> usedShortNames;
    private static Map<UUID, String> currentShortName;
    private static Map<UUID, String> lastSeenFullName;
    private static Map<String, UUID> fullNamesToUUID;
    private static UUID adminShopUUID;
    private static UUID serverAccountUUID;

    public static String getNameFor(Player player) {
        return player.getName();
    }

    public static UUID getUUIDForFullName(String name) {
        return fullNamesToUUID.get(name.toLowerCase());
    }

    public static UUID getUUIDFor(String name) {
        if (ChestShopSign.isAdminshopLine(name)) {
            return adminShopUUID;
        }
        if (Properties.SERVER_ECONOMY_ACCOUNT != null && Properties.SERVER_ECONOMY_ACCOUNT.length() > 0 && Properties.SERVER_ECONOMY_ACCOUNT.equals(name)) {
            return serverAccountUUID;
        }
        UUID uuid = usedShortNames.get(name.toLowerCase());
        if (uuid != null) {
            return uuid;
        }
        return NameManager.getUUIDForFullName(name);
    }

    public static String getFullNameFor(UUID playerId) {
        if (NameManager.isAdminShop(playerId)) {
            return Properties.ADMIN_SHOP_NAME;
        }
        if (NameManager.isServerAccount(playerId)) {
            return Properties.SERVER_ECONOMY_ACCOUNT;
        }
        return lastSeenFullName.get(playerId);
    }

    private static String createUseableShortName(String name, int id) {
        if (id == 0) {
            return name.length() > 15 ? name.substring(0, 15) : name;
        }
        String idString = Integer.toString(id);
        int maxLength = 15 - idString.length();
        return (name.length() > maxLength ? name.substring(0, maxLength) : name) + idString;
    }

    public static void storeUsername(Player player) {
        UUID uuid = player.getUniqueId();
        String name = player.getName();
        String foundShortName = NameManager.storeUsername(uuid, name);
        currentShortName.put(uuid, foundShortName);
    }

    public static boolean freeUsername(String name) {
        UUID assignedFor;
        String assignedName;
        name = name.trim().toLowerCase();
        int rowsDeleted = 0;
        try {
            DeleteBuilder<Account2, String> del = accounts2.deleteBuilder();
            del.setWhere(del.where().like("shortName", name));
            rowsDeleted = del.delete();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (rowsDeleted > 0 && name.equalsIgnoreCase(assignedName = currentShortName.get(assignedFor = usedShortNames.remove(name)))) {
            currentShortName.remove(assignedFor);
            Player onlinePlayer = Bukkit.getServer().getPlayer(assignedFor);
            if (onlinePlayer != null) {
                NameManager.storeUsername(onlinePlayer);
            }
        }
        return rowsDeleted > 0;
    }

    private static String storeUsername(UUID uuid, String name) {
        int id = 0;
        String foundShortName = null;
        while (foundShortName == null) {
            String shortName;
            UUID inUse;
            if ((inUse = usedShortNames.get((shortName = NameManager.createUseableShortName(name, id++)).toLowerCase())) == null) {
                usedShortNames.put(shortName.toLowerCase(), uuid);
                foundShortName = shortName;
                try {
                    accounts2.create(new Account2(foundShortName, uuid));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!inUse.equals(uuid)) continue;
            foundShortName = shortName;
        }
        String storedFullName = lastSeenFullName.put(uuid, name);
        if (storedFullName == null || !storedFullName.equals(name)) {
            try {
                playerNames.createOrUpdate(new PlayerName(name, uuid));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        fullNamesToUUID.put(name.toLowerCase(), uuid);
        return foundShortName;
    }

    public static boolean canUseName(OfflinePlayer player, String name) {
        if (ChestShopSign.isAdminshopLine(name)) {
            return false;
        }
        UUID inUse = usedShortNames.get(name.toLowerCase());
        return inUse != null && inUse.equals(player.getUniqueId());
    }

    public static boolean isAdminShop(UUID uuid) {
        return adminShopUUID.equals(uuid);
    }

    public static UUID getAdminShopUUID() {
        return adminShopUUID;
    }

    public static boolean isServerAccount(UUID uuid) {
        return serverAccountUUID.equals(uuid);
    }

    public static UUID getServerAccountUUID() {
        return serverAccountUUID;
    }

    public static void load() {
        adminShopUUID = UUID.nameUUIDFromBytes("ChestShop-Adminshop".getBytes());
        serverAccountUUID = UUID.nameUUIDFromBytes("ChestShop-ServerAccount".getBytes());
        try {
            String name;
            UUID id;
            accounts = DaoCreator.getDaoAndCreateTable(Account.class);
            accounts2 = DaoCreator.getDaoAndCreateTable(Account2.class);
            playerNames = DaoCreator.getDaoAndCreateTable(PlayerName.class);
            for (PlayerName playerName : playerNames.queryForAll()) {
                lastSeenFullName.put(playerName.getUuid(), playerName.getFullName());
                fullNamesToUUID.put(playerName.getFullName().toLowerCase(), playerName.getUuid());
            }
            for (Account2 account2 : accounts2.queryForAll()) {
                id = account2.getUuid();
                name = account2.getShortName();
                usedShortNames.put(name.toLowerCase(), id);
            }
            for (Account account : accounts.queryForAll()) {
                id = account.getUuid();
                name = account.getName();
                String name2 = account.getLastSeenName();
                if (name != null && !name.equalsIgnoreCase(Properties.ADMIN_SHOP_NAME)) {
                    ChestShop.getBukkitLogger().info("Importing " + name + " (" + String.valueOf(id) + ")...");
                    NameManager.storeUsername(id, name);
                }
                if (name2 == null || name2.equals(name) || name2.equalsIgnoreCase(Properties.ADMIN_SHOP_NAME)) continue;
                ChestShop.getBukkitLogger().info("Importing " + name2 + " (" + String.valueOf(id) + ")...");
                NameManager.storeUsername(id, name2);
            }
            accounts.deleteBuilder().delete();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    static {
        usedShortNames = new HashMap<String, UUID>();
        currentShortName = new HashMap<UUID, String>();
        lastSeenFullName = new HashMap<UUID, String>();
        fullNamesToUUID = new HashMap<String, UUID>();
    }
}

