/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Metadata;

import com.Acrobot.Breeze.Utils.Encoding.Base62;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Database.DaoCreator;
import com.Acrobot.ChestShop.Database.Item;
import com.Acrobot.ChestShop.ORMlite.dao.Dao;
import com.Acrobot.ChestShop.ORMlite.stmt.SelectArg;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.file.YamlConstructor;
import org.bukkit.configuration.file.YamlRepresenter;
import org.bukkit.inventory.ItemStack;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class ItemDatabase {
    private Dao<Item, Integer> itemDao;

    public ItemDatabase() {
        try {
            this.itemDao = DaoCreator.getDaoAndCreateTable(Item.class);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String getItemCode(ItemStack item) {
        try {
            ItemStack clone = new ItemStack(item);
            clone.setAmount(1);
            String code = this.encodeItemStack(clone);
            Item itemEntity = (Item)this.itemDao.queryBuilder().where().eq("code", new SelectArg((Object)code)).queryForFirst();
            if (itemEntity != null) {
                return Base62.encode(itemEntity.getId());
            }
            itemEntity = new Item(code);
            this.itemDao.create(itemEntity);
            int id = itemEntity.getId();
            return Base62.encode(id);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ItemStack getFromCode(String code) {
        try {
            int id = Base62.decode(code);
            Item item = (Item)this.itemDao.queryBuilder().where().eq("id", new SelectArg(id)).queryForFirst();
            if (item == null) {
                return null;
            }
            String serialized = item.getBase64ItemCode();
            return this.decodeItemStack(serialized);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void upgrade(boolean fromLegacy) {
        try {
            List<Item> items = this.itemDao.queryBuilder().query();
            int modified = 0;
            int mutants = 0;
            int collisions = 0;
            int errors = 0;
            int total = items.size();
            int current = 0;
            for (Item item : items) {
                if (++current % 100 == 0 || current == total) {
                    ChestShop.getPlugin().getLogger().info("Converting... " + current + "/" + total);
                }
                try {
                    String reserialized;
                    String serialized = item.getBase64ItemCode();
                    if (serialized.equals(reserialized = this.encodeItemStack(fromLegacy ? this.decodeItemStackLegacy(serialized) : this.decodeItemStack(serialized)))) continue;
                    String reserialized2 = this.encodeItemStack(this.decodeItemStack(reserialized));
                    if (!fromLegacy && !reserialized.equals(reserialized2)) {
                        ++mutants;
                        ChestShop.getPlugin().getLogger().info("Before:\n" + reserialized);
                        ChestShop.getPlugin().getLogger().info("After:\n" + reserialized2);
                        continue;
                    }
                    Item itemCollision = (Item)this.itemDao.queryBuilder().where().eq("code", new SelectArg((Object)reserialized2)).queryForFirst();
                    if (itemCollision != null && fromLegacy) {
                        itemCollision = null;
                        reserialized2 = this.encodeItemStack(this.decodeItemStack(reserialized2), true);
                        ++collisions;
                    }
                    if (itemCollision == null) {
                        item.setBase64ItemCode(reserialized2);
                        this.itemDao.update(item);
                        ++modified;
                        continue;
                    }
                    ++collisions;
                }
                catch (Throwable e) {
                    ++errors;
                    ChestShop.getPlugin().getLogger().log(Level.SEVERE, "Could not upgrade item " + item.getId() + " (" + Base62.encode(item.getId()) + "): " + e.getClass().getSimpleName(), e);
                    try {
                        this.itemDao.delete(item);
                    }
                    catch (Exception ex) {
                        ChestShop.getPlugin().getLogger().log(Level.SEVERE, "Could not delete item " + item.getId(), ex);
                    }
                }
            }
            ChestShop.getPlugin().getLogger().info("Updated " + modified + "/" + items.size() + " items (" + collisions + " collisions, " + mutants + " mutants, " + errors + " errors)");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String encodeItemStack(ItemStack stack) {
        return this.encodeItemStack(stack, false);
    }

    public String encodeItemStack(ItemStack stack, boolean addRandomValue) {
        Preconditions.checkState((boolean)Bukkit.isPrimaryThread(), (Object)"Not called from main thread!");
        YamlConfiguration conf = new YamlConfiguration();
        conf.set("item", (Object)stack);
        if (addRandomValue) {
            conf.set("random", (Object)UUID.randomUUID().toString());
        }
        return Base64.getEncoder().encodeToString(conf.saveToString().getBytes(Charset.forName("UTF-8")));
    }

    public ItemStack decodeItemStack(String serialized) {
        Preconditions.checkState((boolean)Bukkit.isPrimaryThread(), (Object)"Not called from main thread!");
        YamlConfiguration conf = new YamlConfiguration();
        try {
            conf.loadFromString(new String(Base64.getDecoder().decode(serialized), Charset.forName("UTF-8")));
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        return new ItemStack(conf.getItemStack("item"));
    }

    public ItemStack decodeItemStackLegacy(String serialized) throws IOException {
        Preconditions.checkState((boolean)Bukkit.isPrimaryThread(), (Object)"Not called from main thread!");
        try {
            Yaml yaml = new Yaml((BaseConstructor)new YamlBukkitConstructor(this), (Representer)new YamlRepresenter(), new DumperOptions());
            return new ItemStack((ItemStack)yaml.loadAs((String)com.Acrobot.Breeze.Utils.Encoding.Base64.decodeToObject(serialized), ItemStack.class));
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    private class YamlBukkitConstructor
    extends YamlConstructor {
        public YamlBukkitConstructor(ItemDatabase itemDatabase) {
            this.yamlConstructors.put(new Tag("tag:yaml.org,2002:org.bukkit.inventory.ItemStack"), (Construct)this.yamlConstructors.get(Tag.MAP));
        }
    }
}

